﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.UC;

namespace ClothesSys.FormStockManage
{
    
    public partial class formStockDetail : Form
    {
        ucStockManage ucSM;
        string stockId;
        public formStockDetail(string stockid,ucStockManage uc)
        {
            InitializeComponent();
            stockId = stockid;
            ucSM = uc;
        }

        private void formStockDetail_Load(object sender, EventArgs e)
        {
            bindAllControls();
        }

        private void bindAllControls()
        {
            Stock st = StockManager.GetStockByStockId(stockId);
            txbUser.Text = UserManager.GetUserByID(st.UserId).Name;
            txbGoodId.Text = st.GoodsId;
            txbGoodsName.Text = GoodManager.GetGoodById(st.GoodsId).GoodName;
            txbGoodsNum.Text = st.GoodsNum.ToString();
            txbGoodsPrice.Text = st.GoodPrice.ToString();
            txbNeedPay.Text = st.NeedPay.ToString();
            txbRealPay.Text = st.RealPay.ToString();
            txbCompanyName.Text = st.CompanyName;
            txbCompanyAddress.Text = st.CompanyAddress;
            txbCompanyTel.Text = st.CompanyTel;
            txbStockTime.Text = st.StockTime.ToString();
            txbStockNum.Text = st.StockNum.ToString();
            txbRemark.Text = st.Remark;
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            Stock st = StockManager.GetStockByStockId(stockId);
            st.Remark = txbRemark.Text;
            bool f = StockManager.UpdateStock(st);
            if (f)
            {
                MessageBox.Show("更新成功", "提示");
                ucSM.bindDgvStock();
                this.Close();
            }
            else
            {
                MessageBox.Show("更新失败", "提示");
 
            }

        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
