﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.UC;

namespace ClothesSys.FormStockManage
{
    public partial class formStockIn : Form
    {
        string userId;
        ucStockManage ucSM;
        public formStockIn(string userid,ucStockManage uc)
        {
            InitializeComponent();
            userId = userid;
            ucSM = uc;
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void formStockIn_Load(object sender, EventArgs e)
        {
            bindCmbUser();
            bindCmbCompany();
            bindCmbGoods();
        }

        private void bindCmbUser()
        {
            cmbUser.DataSource = UserManager.GetAllUsersOfTable();
            cmbUser.DisplayMember = "Name";
            cmbUser.ValueMember = "UserId";
            cmbUser.SelectedValue = userId;
            
             
        }

        private void bindCmbCompany()
        {
            cmbCompanyName.DataSource = CompanyManager.GetAllCompaniesOfTable();
            cmbCompanyName.DisplayMember = "companyName";
            cmbCompanyName.ValueMember = "companyId";
            cmbCompanyName.SelectedIndex = 0;
            
        }

        private void bindCmbGoods()
        {
            cmbGoodsId.DataSource = GoodManager.GetAllGoodsOfTable();
            cmbGoodsId.DisplayMember = "goodId";
            cmbGoodsId.ValueMember = "goodId";
            cmbGoodsId.SelectedIndex = 0;
        }

        

        private void cmbCompanyName_DropDownClosed(object sender, EventArgs e)
        {
            string ci = cmbCompanyName.SelectedValue.ToString();
            Company com = CompanyManager.GetCompanyById(ci.ToString());
            txbCompanyName.Text = com.CompanyName;
            txbCompanyAddress.Text = com.CompanyAddress;
            txbCompanyTel.Text = com.CompanyTel;
        }

        private void cmbGoodsId_DropDownClosed(object sender, EventArgs e)
        {
            string gi = cmbGoodsId.SelectedValue.ToString();
            Good good = GoodManager.GetGoodById(gi);
            txbGoodsName.Text = good.GoodName;
        }

        private void btnStockIn_Click(object sender, EventArgs e)
        {
            bool v = Common.CommonUtility.ValidateTexbBoxesEmpty(this.Controls);
            if (v)
            {

                string userid = cmbUser.SelectedValue.ToString();
                string goodid = cmbGoodsId.SelectedValue.ToString();
                int goodsNum = Convert.ToInt32(txbGoodsNum.Text);
                int goodsPrice = Convert.ToInt32(txbGoodsPrice.Text);
                int needPay = goodsNum * goodsPrice;
                int realPay = Convert.ToInt32(txbRealPay.Text);

                string companyName = txbCompanyName.Text;
                string companyAddress = txbCompanyAddress.Text;
                string companyTel = txbCompanyTel.Text;

                string remark = txbRemark.Text;

                string stockTime = DateTime.Now.ToString();

                Stock stock = new Stock();
                stock.UserId = userid;
                stock.GoodsId = goodid;
                stock.GoodsNum = goodsNum;
                stock.GoodPrice = goodsPrice;
                stock.NeedPay = needPay;
                stock.RealPay = realPay;
                stock.CompanyName = companyName;
                stock.CompanyAddress = companyAddress;
                stock.CompanyTel = companyAddress;
                stock.Remark = remark;
                stock.StockTime = Convert.ToDateTime(stockTime);

                int oldStockNum = StockManager.GetStockNumByGoodId(goodid);
                if (oldStockNum > 0)
                {
                    stock.StockNum = oldStockNum + goodsNum;
                    StockManager.UpdateStocskNumByGoodId(goodid, goodsNum);
                }
                else
                {
                    stock.StockNum = goodsNum;
                }


                bool f = StockManager.StockIn(stock);
                if (f)
                {
                    MessageBox.Show("服装入库成功!", "提示");
                    this.Close();
                    ucSM.bindDgvStock();
                }
                else
                {
                    MessageBox.Show("服装入库失败!", "提示");
                }
            }
            else
            {
                MessageBox.Show("请填写完整信息!", "提示");
 
            }

        }

        private void txbGoodsPrice_TextChanged(object sender, EventArgs e)
        {
            if (txbGoodsPrice.Text != "" && txbGoodsNum.Text != "")
            {
                int goodsNum = Convert.ToInt32(txbGoodsNum.Text);
                int goodsPrice = Convert.ToInt32(txbGoodsPrice.Text);
                int needPay = goodsNum * goodsPrice;
                txbNeedPay.Text = needPay.ToString();
            }
        }

        private void txbGoodsNum_KeyPress(object sender, KeyPressEventArgs e)
        {
            Common.CommonUtility.ValidateNumber(e);
        }

        private void txbGoodsPrice_KeyPress(object sender, KeyPressEventArgs e)
        {
            Common.CommonUtility.ValidateNumber(e);

        }

        private void txbRealPay_KeyPress(object sender, KeyPressEventArgs e)
        {
            Common.CommonUtility.ValidateNumber(e);
        }

        private void txbCompanyTel_KeyPress(object sender, KeyPressEventArgs e)
        {
            Common.CommonUtility.ValidateTel(e);
        }

        private void txbGoodsNum_TextChanged(object sender, EventArgs e)
        {
            if (txbGoodsPrice.Text != "" && txbGoodsNum.Text != "")
            {
                int goodsNum = Convert.ToInt32(txbGoodsNum.Text);
                int goodsPrice = Convert.ToInt32(txbGoodsPrice.Text);
                int needPay = goodsNum * goodsPrice;
                txbNeedPay.Text = needPay.ToString();
            }
        }


        


    }
}
