﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.CompanyManage;
using ClothesSys.BLL;

namespace ClothesSys
{
    public partial class ucCompanyManage : UserControl
    {

        string companyId;
        public ucCompanyManage()
        {
            InitializeComponent();
            

        }

        private void btnCompanyAdd_Click(object sender, EventArgs e)
        {
            formCompanyAdd fcadd = new formCompanyAdd(this);
            fcadd.ShowDialog();
        }

        public void bindDgvCompany()
        {
            dgvCompany.DataSource = CompanyManager.GetAllCompaniesOfTable();
             
        }

        private void ucCompanyManage_Load(object sender, EventArgs e)
        {
            bindDgvCompany();
            dgvCompany.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill; //让dataGridView填充满控件
            dgvCompany.Columns["companyid"].Visible = false;
            dgvCompany.Columns["companyName"].HeaderText = "供应商名称";
            dgvCompany.Columns["companyTel"].HeaderText = "供应商电话";
            dgvCompany.Columns["companyAddress"].HeaderText = "供应商地址";
            dgvCompany.AllowUserToAddRows = false;
            dgvCompany.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
        }

        private void btnCompanyUpdate_Click(object sender, EventArgs e)
        {
            
                formCompanyUpdate fcu = new formCompanyUpdate(companyId, this);
                fcu.ShowDialog();
            
        }

        private void btnCompanyDelete_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("确认要删除么?", "提示", MessageBoxButtons.YesNo);
            if (result == DialogResult.Yes)
            {
                bool f = CompanyManager.DeleteCompanyById(companyId);
                if (f)
                {
                    MessageBox.Show("删除成功!", "提示");
                    bindDgvCompany();
                }
                else
                {
                    MessageBox.Show("删除失败!", "提示");

                }
            }
        }

        private void dgvCompany_CellEnter(object sender, DataGridViewCellEventArgs e)  //选择CellEnter事件比CellClick事件更好!
        {
            if (e.RowIndex >= 0)
            {
                companyId = dgvCompany.Rows[e.RowIndex].Cells["companyId"].Value.ToString();
            }
        }
    }
}
