﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.CustomerManage;

namespace ClothesSys.UC
{
    public partial class ucCustomerManage : UserControl
    {

        string customerId;
        public ucCustomerManage()
        {
            InitializeComponent();
        }

        private void ucCustomerManage_Load(object sender, EventArgs e)
        {
            bindDgvCustomers();  //注意语句顺序，这一句要放在第一句
            dgvCustomers.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill; //让dataGridView填充满控件
            dgvCustomers.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dgvCustomers.Columns["customerid"].HeaderText = "顾客ID/手机号";
            dgvCustomers.Columns["customername"].HeaderText = "顾客姓名";
            dgvCustomers.Columns["score"].HeaderText = "积分";
            dgvCustomers.Columns["remark"].HeaderText = "备注";
            dgvCustomers.AllowUserToAddRows = false;
            
        }

        public void bindDgvCustomers()
        {
            dgvCustomers.DataSource = CustomerManager.GetAllCustomersOfTable();
        }

        private void btnCustomerAdd_Click(object sender, EventArgs e)
        {
            formCustomerAdd fcadd = new formCustomerAdd(this);
            fcadd.ShowDialog();
        }

        private void btnCustomerUpdate_Click(object sender, EventArgs e)
        {
            formCustomerUpdate fcupdate = new formCustomerUpdate(customerId, this);
            fcupdate.ShowDialog();
        }

        private void dgvCustomers_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0)
            {
               customerId =  dgvCustomers.Rows[e.RowIndex].Cells["customerid"].Value.ToString();
            }
        }

        private void btnCustomerDelete_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("确认要删除么?", "提示", MessageBoxButtons.YesNo);
            if (result == DialogResult.Yes)
            {
                bool f = CustomerManager.DeleteCustomerById(customerId);
                if (f)
                {
                    MessageBox.Show("删除成功!", "提示");
                    bindDgvCustomers();
                }
                else
                {
                    MessageBox.Show("删除失败!", "提示");

                }
            }
        }
    }
}
