﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.GoodCategoryManage;
using ClothesSys;

namespace ClothesSys.UC
{
    public partial class ucGoodCategoryManage : UserControl
    {

        string categoryId;
        public ucGoodCategoryManage()
        {
            InitializeComponent();
        }

        private void ucGoodCategoryManage_Load(object sender, EventArgs e)
        {
            bindLsbGc();
            DataTable dt = GoodCategoryManager.GetAllGoodCategoryOfTable();
            if ( dt.Rows.Count>0)
            {
                lsbGoodCategory.SelectedIndex = 0;
                categoryId = lsbGoodCategory.SelectedValue.ToString();
            }
        }

        public void bindLsbGc()
        {
            lsbGoodCategory.DataSource = GoodCategoryManager.GetAllGoodCategoryOfTable();
            lsbGoodCategory.DisplayMember = "goodcategoryname";
            lsbGoodCategory.ValueMember = "goodCategoryId";
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            formCategoryAdd fCAdd = new formCategoryAdd(this);
            fCAdd.ShowDialog();
        }

        private void lsbGoodCategory_SelectedIndexChanged(object sender, EventArgs e)
        {
            categoryId = lsbGoodCategory.SelectedValue.ToString();
            
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            GoodCategory gc = GoodCategoryManager.GetCategoryByCategoryId(categoryId);
            if (gc != null)
            {
                formCategoryUpdate fcUpdate = new formCategoryUpdate(categoryId, this);
                fcUpdate.ShowDialog();
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            GoodCategory gc = GoodCategoryManager.GetCategoryByCategoryId(categoryId);
            if (gc != null)
            {
                DialogResult result = MessageBox.Show("确定要删除么?", "提示", MessageBoxButtons.YesNo);
                if (result == DialogResult.Yes)
                {
                    bool f = GoodCategoryManager.DeleteGoodCategoryById(categoryId);
                    if (f)
                    {
                        MessageBox.Show("删除成功!", "提示");
                        bindLsbGc();
                    }
                    else
                    {
                        MessageBox.Show("该服装类别下还有服装,不能删除!", "提示");
                    }
                }
            }
        }
    }
}
