﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.FormGoodManage;

namespace ClothesSys.UC
{
    public partial class ucGoodManage : UserControl
    {

        string goodId;
        public ucGoodManage()
        {
            InitializeComponent();
        }

        private void ucGoodManage_Load(object sender, EventArgs e)
        {
            bindDgvGood();
        }

        public void bindDgvGood()
        {
            dgvGood.DataSource = GoodManager.GetAllGoodsOfTable();
            dgvGood.Columns["goodId"].HeaderText = "服装ID";
            dgvGood.Columns["goodName"].HeaderText = "服装名称";
            dgvGood.Columns["produceArea"].HeaderText = "产地";
            dgvGood.Columns["goodcategoryName"].HeaderText = "服装类别";
            dgvGood.Columns["remark"].HeaderText = "备注";
            dgvGood.AllowUserToAddRows = false;
            dgvGood.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dgvGood.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            DataTable dt = GoodCategoryManager.GetAllGoodCategoryOfTable();
            if (dt.Rows.Count > 0)
            {
                formGoodAdd fgAdd = new formGoodAdd(this);
                fgAdd.ShowDialog();
            }
            else
            {
                MessageBox.Show("还没有服装类别,无法添加服装!", "提示");
            }
        }

        private void dgvGood_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0)
            {
               goodId =  dgvGood.Rows[e.RowIndex].Cells["goodId"].Value.ToString();
 
            }
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            Good g = GoodManager.GetGoodById(goodId);
            if (g != null)
            {
                formGoodUpdate fgUpdate = new formGoodUpdate(goodId, this);
                fgUpdate.ShowDialog();
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            Good g = GoodManager.GetGoodById(goodId);
            if (g != null)
            {
                DialogResult result = MessageBox.Show("确定要删除么?", "提示", MessageBoxButtons.YesNo);
                if (result == DialogResult.Yes)
                {
                    bool f = GoodManager.DeleteGoodById(goodId);
                    if (f)
                    {
                        MessageBox.Show("删除成功!", "提示");
                        bindDgvGood();
                    }
                    else
                    {
                        MessageBox.Show("删除失败!", "提示");

                    }

                }
            }
        }

        
    }
}
