﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.FormSaleManage;


namespace ClothesSys.UC
{
    public partial class ucGoodSellManage : UserControl
    {

        string userId;
        string sellId=null;
        public ucGoodSellManage(string uid)
        {
            InitializeComponent();
            userId = uid;
        }

        private void ucGoodSellManage_Load(object sender, EventArgs e)
        {
            dgvGoodSale.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            dgvGoodSale.AllowUserToAddRows = false;
            dgvGoodSale.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            bindDgvSellRecordToday();
            dgvGoodSale.Columns["billId"].HeaderText = "销售单ID";
            dgvGoodSale.Columns["billId"].AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            dgvGoodSale.Columns["sellId"].Visible = false;
            dgvGoodSale.Columns["sellTime"].HeaderText = "销售时间";
            dgvGoodSale.Columns["sellTime"].AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            dgvGoodSale.Columns["goodName"].HeaderText = "服装名称";
            dgvGoodSale.Columns["goodsPrice"].HeaderText = "单价";
            dgvGoodSale.Columns["sellNum"].HeaderText = "销量";
            dgvGoodSale.Columns["realPay"].HeaderText = "实际支付";
            



        }

        public void bindDgvSellRecordToday()
        {
            dgvGoodSale.DataSource = BillManager.GetBillsOfTableToday();

            bindTxbSellTotalToday();
 
        }

        void bindTxbSellTotalToday()
        {
            int count = dgvGoodSale.Rows.Count;
            int sum=0;
            for (int i = 0; i < count; i++)
            {
                sum += Convert.ToInt32(dgvGoodSale.Rows[i].Cells["realPay"].Value);
 
            }

            txbSellTotalToday.Text = sum.ToString();
        }

        private void btnGoodSell_Click(object sender, EventArgs e)
        {
            FormGoodSell fGS = new FormGoodSell(userId,this);
            fGS.ShowDialog();
        }

        private void dgvGoodSale_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if(e.RowIndex>=0)
            {
                sellId = dgvGoodSale.Rows[e.RowIndex].Cells["sellId"].Value.ToString();
            }
        }

        private void btnDetail_Click(object sender, EventArgs e)
        {
            if (sellId != "")
            {
                FormSellDetail fSD = new FormSellDetail(sellId);
                fSD.ShowDialog();
            }
        }

        
    }
}
