﻿using System;
using System.Windows.Forms;
using ClothesSys.BLL;

using ClothesSys.FormReGoodsManage;


namespace ClothesSys.UC
{
    public partial class ucReGoodManage : UserControl
    {
        string userId;
        string reGoodsBillId;
        public ucReGoodManage()
        {
            InitializeComponent();
        }

        public ucReGoodManage(string uid)
        {
            InitializeComponent();
            userId = uid;
        }

        public void bindDgvRegoods()
        {
            dgvRegoods.DataSource = ReGoodsManager.GetReGoodsOfToday();
        }

        private void btnReGood_Click(object sender, EventArgs e)
        {
            FormReGood fRG = new FormReGood(userId,this);
            fRG.ShowDialog();
            
        }

        private void ucReGoodManage_Load(object sender, EventArgs e)
        {
            bindDgvRegoods();
            InitialDgvReGoods();
        }

        void InitialDgvReGoods()
        {
            dgvRegoods.AllowUserToAddRows = false;
            dgvRegoods.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            dgvRegoods.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;

            dgvRegoods.Columns["regoodsbillId"].Visible = false;
            dgvRegoods.Columns["regoodsId"].HeaderText = "服装ID";
            dgvRegoods.Columns["regoodsNum"].HeaderText = "退货数量";
            dgvRegoods.Columns["regoodsPrice"].Visible = false;
            dgvRegoods.Columns["reNeedPay"].Visible = false;
            dgvRegoods.Columns["reRealPay"].HeaderText = "实退金额";
            dgvRegoods.Columns["reGoodsResult"].HeaderText = "退货理由";
            dgvRegoods.Columns["reGoodsTime"].HeaderText = "退货时间";
            dgvRegoods.Columns["reGoodsTime"].AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            dgvRegoods.Columns["userId"].HeaderText = "操作员ID";
            dgvRegoods.Columns["goodName"].HeaderText = "服装名称";
 
        }

        private void btnDetail_Click(object sender, EventArgs e)
        {
            FormReGoodDetail frgDetail = new FormReGoodDetail(reGoodsBillId);
            frgDetail.ShowDialog();
        }

        private void dgvRegoods_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0)
            {
                reGoodsBillId = dgvRegoods.Rows[e.RowIndex].Cells["regoodsBillId"].Value.ToString();
 
            }
        }
    }
}
