﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;
using ClothesSys.FormStockManage;

namespace ClothesSys.UC
{
    public partial class ucStockManage : UserControl
    {
        string userId;
        string stockId;
        public ucStockManage(string uid)
        {
            InitializeComponent();
            userId = uid;
        }

        private void ucStockManage_Load(object sender, EventArgs e)
        {
            bindDgvStock();
            dgvStock.Columns["stockId"].Visible = false;
            dgvStock.Columns["stockTime"].HeaderText = "入库时间";
            dgvStock.Columns["stockTIme"].AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells;
            dgvStock.Columns["stockNum"].HeaderText = "库存量";
            dgvStock.Columns["goodsNum"].HeaderText = "入库数量";
            dgvStock.Columns["Name"].HeaderText = "操作员";
            dgvStock.Columns["goodsId"].HeaderText = "服装ID";
            dgvStock.Columns["realPay"].HeaderText = "支付费用";
            dgvStock.AllowUserToAddRows = false;
            dgvStock.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.Fill;
            dgvStock.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
        }

        public void bindDgvStock()
        {
            dgvStock.DataSource = StockManager.GetAllStockOfTable();


        }

        private void btnStock_Click(object sender, EventArgs e)
        {
            formStockIn fSIn = new formStockIn(userId,this);
            fSIn.ShowDialog();
        }

        private void dgvStock_CellEnter(object sender, DataGridViewCellEventArgs e)
        {
            
            if (e.RowIndex >= 0)
            {
                stockId = dgvStock.Rows[e.RowIndex].Cells["stockId"].Value.ToString();
 
            }

        }

        private void btnDetail_Click(object sender, EventArgs e)
        {
            formStockDetail fSD = new formStockDetail(stockId, this);
            fSD.ShowDialog();
        }
    }
}
