﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ClothesSys.BLL;
using ClothesSys.Model;


namespace ClothesSys
{
    public partial class ucUserManage : UserControl
    {
        string userid;

        public ucUserManage()
        {
            InitializeComponent();

        }

        private void ucUserManage_Load(object sender, EventArgs e)
        {
            bindlsbUser();
                         
            
        }

        public void bindlsbUser()
        {
            List<User> list = UserManager.GetAllUsers();

            lsbUsers.DataSource = list;
            lsbUsers.ValueMember = "userid";
            lsbUsers.DisplayMember = "name";
        }

        private void btnAddUser_Click(object sender, EventArgs e)
        {
            formUserAdd fuseradd = new formUserAdd(this);
            fuseradd.ShowDialog();
            
        }

        private void lsbUsers_SelectedIndexChanged(object sender, EventArgs e)
        {
            userid = lsbUsers.SelectedValue.ToString();
        }

        private void btnUserUpdate_Click(object sender, EventArgs e)
        {
            formUserUpdate fUserUpdate = new formUserUpdate(userid,this);
            fUserUpdate.ShowDialog();
        }

        private void btnUserDelete_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("确定要删除么?", "提示", MessageBoxButtons.YesNo);
            if (result == DialogResult.Yes)
            {
                bool f = UserManager.DeleteUserById(userid);
                if (f)
                {
                    MessageBox.Show("删除成功!", "提示");
                    bindlsbUser();
                }
                else
                {
                    MessageBox.Show("无法删除,该操作员已经进行过服装入库操作!", "提示");
                }
            }
        }

        

        
    }
}
