﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ClothesSys.Model;
using ClothesSys.UC;


namespace ClothesSys
{
    public partial class formMain : Form
    {

        User user =  new User();
        public static string UserID = null;
        public formMain()
        {
            InitializeComponent();
        }

        public formMain(User u)
        {
            InitializeComponent();
            this.user = u;
            UserID = user.UserID;
            toolStripStatusLabelUserName.Text = "操作员:"+u.Name;
        }

        private void UserManageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucUserManage ucum = new ucUserManage();            
            panelMain.Controls.Add(ucum);
            

        }

        private void formMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            DialogResult result = MessageBox.Show("确认要退出程序么?", "退出提示", MessageBoxButtons.YesNo);
            if (result == DialogResult.No)
            {           
                e.Cancel = true;
                
            }
        }

        private void formMain_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();  //不能放在FormClosing事件中!
        }

        ucCompanyManage ucCM = new ucCompanyManage();
        private void CompanyManageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucCompanyManage uccm = new ucCompanyManage();
            panelMain.Controls.Add(uccm);
            ucCM = uccm;
        }

        ucCustomerManage ucCuM = new ucCustomerManage();
        private void CustomerManageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucCustomerManage ucCM = new ucCustomerManage();
            panelMain.Controls.Add(ucCM);
            ucCuM = ucCM;
        }

        private void GoodCategoryToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucGoodCategoryManage ucGcm = new ucGoodCategoryManage();
            panelMain.Controls.Add(ucGcm);
        }

        private void GoodInfoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucGoodManage ucGood = new ucGoodManage();
            panelMain.Controls.Add(ucGood);
        }

        ucStockManage ucSM = new ucStockManage(UserID);
        private void StockManageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucStockManage ucsm = new ucStockManage(user.UserID);
            panelMain.Controls.Add(ucsm);
            ucSM = ucsm;

        }

        ucGoodSellManage ucGSM = new ucGoodSellManage(UserID);
        private void GoodSellToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucGoodSellManage ucgsm = new ucGoodSellManage(user.UserID);
            ucGSM = ucgsm;
            panelMain.Controls.Add(ucgsm);
        }

        private void ReGoodsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucReGoodManage ucRGM = new ucReGoodManage(user.UserID);
            panelMain.Controls.Add(ucRGM);

        }

        private void tsbtnAddCustomer_Click(object sender, EventArgs e)
        {
            CustomerManage.formCustomerAdd fCA = new CustomerManage.formCustomerAdd(ucCuM);
            fCA.ShowDialog();
        }

        private void tsbtnGoodSell_Click(object sender, EventArgs e)
        {
            FormSaleManage.FormGoodSell fGS = new FormSaleManage.FormGoodSell(user.UserID,ucGSM);
            fGS.ShowDialog();
        }

        private void tsbtnGoodStockIn_Click(object sender, EventArgs e)
        {
            FormStockManage.formStockIn fSI = new FormStockManage.formStockIn(user.UserID, ucSM);
            fSI.ShowDialog();
        }

        private void tsbtnAddCompany_Click(object sender, EventArgs e)
        {
            CompanyManage.formCompanyAdd fCA = new CompanyManage.formCompanyAdd(ucCM);
            fCA.ShowDialog();
            
        }

        private void tsbtnSellStatics_Click(object sender, EventArgs e)
        {
            pictureBox1.Visible = false;
            panelMain.Controls.Clear();
            ucGoodSellManage ucgsm = new ucGoodSellManage(user.UserID);
            ucGSM = ucgsm;
            panelMain.Controls.Add(ucgsm);
        }

        private void formMain_Load(object sender, EventArgs e)
        {
            
        }

        private void AbouThisToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            formAboutThis formAT = new formAboutThis();
            formAT.ShowDialog();
        }

        
    }
}
