﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SQLite;
using ClothesSys.Model;
using ClothesSys.DBUtility;

namespace ClothesSys.DAL
{
    public class BillService
    {
        public static DataTable GetBillsOfTableToday()
        {
            DataTable dt = null;
            string sql="select billId,T_sell.sellId,selltime,goodname,goodsprice,sellnum,realpay from T_sell,T_good,T_bill where T_bill.sellId=T_sell.sellId and T_sell.goodsId=T_good.goodId ";
            sql+="and  sellTime>datetime('now','start of day') and sellTime<datetime('now','localtime')";
            dt = SQLiteHelper.GetTable(sql);
            return dt;
        }

        public static Bill GetBillByBillId(string bid)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@billId",bid)
            };

            Bill bill=null;
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_bill where billId=@billId", sqlparams))
            {
                while (sdr.Read())
                {
                    bill = new Bill();
                    bill.BillId = sdr.GetValue(0).ToString();
                    bill.SellId = sdr.GetValue(1).ToString();
                    bill.BillTime = Convert.ToDateTime(sdr.GetValue(2));
                    bill.UserId = sdr.GetValue(3).ToString();
 
                }
                sdr.Close();
            }
            return bill;
 
        }

        public static Bill GetBillBySellId(string sid)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@sellId",sid)
            };

            Bill bill = null;
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_bill where sellId=@sellId", sqlparams))
            {
                while (sdr.Read())
                {
                    bill = new Bill();
                    bill.BillId = sdr.GetValue(0).ToString();
                    bill.SellId = sdr.GetValue(1).ToString();
                    bill.BillTime = Convert.ToDateTime(sdr.GetValue(2));
                    bill.UserId = sdr.GetValue(3).ToString();

                }
                sdr.Close();
            }
            return bill;
 
        }

        public static int AddBill(SQLiteTransaction trans,List<Sell> list)
        {
            int i = -1;
            foreach (Sell sell in list)
            {
                SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@billId",GetbillId()),
                new SQLiteParameter("@sellId",sell.SellID),
                new SQLiteParameter("@userId",sell.UserID),
                new SQLiteParameter("@billTime",sell.SellTime)
                };

                i = SQLiteHelper.ExecuteNonQuery(trans, "insert into T_bill(billId,sellId,userId,billTime) values(@billId,@sellId,@userId,@billTime)", sqlparams);
            }
            return i;
        }


        /// <summary>
        /// 自动生成BillId
        /// </summary>
        /// <returns></returns>
        public static string GetbillId()
        {
            return DateTime.Now.ToString("yyyyMMddHHmmss");
        }

        public static DataTable GetBillsByBillId(string bid)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@billId",bid)
            };
            string sql="select T_sell.sellId,selltime,goodname,goodsprice,sellnum,realpay,customerId from T_sell,T_good,T_bill where T_bill.sellId=T_sell.sellId and T_sell.goodsId=T_good.goodId ";
            sql+="and billId=@billId";
            return SQLiteHelper.GetTable(sql,sqlparams);
 
        }

        public static DataTable GetBillsByCustomerId(string cid)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerID",cid)
            };
            string sql = "select T_sell.sellId,selltime,goodname,goodsprice,sellnum,realpay,customerId from T_sell,T_good,T_bill where T_bill.sellId=T_sell.sellId and T_sell.goodsId=T_good.goodId ";
            sql += "and customerId=@customerId";
            return SQLiteHelper.GetTable(sql, sqlparams);
        }

        public static List<Bill> GetAllBills()
        {
            List<Bill> list = new List<Bill>();
            Bill bill = null;
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_bill"))
            {
                while (sdr.Read())
                {
                    bill = new Bill();
                    bill.BillId = sdr.GetValue(0).ToString();
                    bill.SellId = sdr.GetValue(1).ToString();
                    bill.BillTime = Convert.ToDateTime(sdr.GetValue(2));
                    bill.UserId = sdr.GetValue(3).ToString();
                    list.Add(bill);
                }
                sdr.Close();
 
            }
            return list;
        }
    }
}
