﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.Model;
using ClothesSys.DBUtility;
using System.Data.SQLite;
using System.Data;

namespace ClothesSys.DAL
{
    public class CompanyService
    {


        /// <summary>
        /// 根据CompanyId取得Company对象
        /// </summary>
        /// <param name="cid"></param>
        /// <returns></returns>
        public static Company GetCompanyById(string cid)
        {
            Company com=null;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@companyId",Convert.ToInt32(cid))
            };
            using (SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select * from T_company where companyid=@companyId", sqlparams))
            {
                while (sdr.Read())
                {
                    com = new Company();
                    com.CompanyID = Convert.ToInt32(cid);
                    com.CompanyName = sdr.GetValue(1).ToString();
                    com.CompanyAddress = sdr.GetValue(2).ToString();
                    com.CompanyTel = sdr.GetValue(3).ToString();

                }
                sdr.Close();
            }

            return com;
            
        }

        /// <summary>
        /// 返回所有公司的DataTable
        /// </summary>
        /// <returns></returns>
        public static DataTable GetAllCompaniesOfTable()
        {
            return SQLiteHelper.GetTable("select * from T_Company");
        }


        /// <summary>
        /// 增加一家供应商
        /// </summary>
        /// <param name="com"></param>
        /// <returns></returns>
        public static int AddCompany(Company com)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@companyName",com.CompanyName),
                new SQLiteParameter("@companyAddress",com.CompanyAddress),
                new SQLiteParameter("@companyTel",com.CompanyTel)
            };
            int i=SQLiteHelper.ExecuteNoQuery("insert into T_company(companyName,companyAddress,companyTel) values(@companyName,@companyAddress,@companyTel)", sqlparams);
            return i;

        }


        public static int UpdateCompany(Company com)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@companyId",com.CompanyID),
                new SQLiteParameter("@companyName",com.CompanyName),
                new SQLiteParameter("@companyAddress",com.CompanyAddress),
                new SQLiteParameter("@companyTel",com.CompanyTel)
            };
            int i = SQLiteHelper.ExecuteNoQuery("update T_company set companyName=@companyName,companyAddress=@companyAddress,companyTel=@companyTel where companyId=@companyId", sqlparams);
            return i;
        }

        public static int DeleteCompanyById(string id)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@companyId",Convert.ToInt32(id))
            };
            int i = SQLiteHelper.ExecuteNoQuery("delete from T_company where companyid=@companyId", sqlparams);
            return i;
        }


    }
}
