﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.Model;
using ClothesSys.DBUtility;
using System.Data.SQLite;
using System.Data;

namespace ClothesSys.DAL
{
    public class CustomerService
    {
        public static int AddCustomer(Customer ct)
        {
            int i = -1;

            SQLiteParameter[] preparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",ct.CustomerID)
            };

            if (SQLiteHelper.ExecuteScalar("select count(*) from T_customer where customerid=@customerId", preparams))
            {

                SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",ct.CustomerID),
                new SQLiteParameter("@customerName",ct.CustomerName),
                new SQLiteParameter("@remark",ct.Remark),
                new SQLiteParameter("@score",ct.Socre)
            };
                i = SQLiteHelper.ExecuteNoQuery("insert into T_customer(customerid,customername,score,remark) values(@customerId,@customerName,@score,@remark)", sqlparams);
            }
            return i;
        }


        /// <summary>
        /// 更新用户信息
        /// </summary>
        /// <param name="oldid">用户的旧ID</param>
        /// <param name="ct">新的用户对象</param>
        /// <returns></returns>
        public static int UpdateCustomer(string oldid,Customer ct)
        {
            int i = -1;
            if (oldid != ct.CustomerID)
            {
                SQLiteParameter[] preparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",ct.CustomerID)
                 };
                if (SQLiteHelper.ExecuteScalar("select count(*) from T_customer where customerid=@customerId", preparams))  //这里注意，搜不到存在ID才会继续执行
                {
                    SQLiteParameter[] secparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",oldid)
                };

                    SQLiteHelper.ExecuteNoQuery("delete from T_customer where customerid=@customerId", secparams);

                    SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",ct.CustomerID),
                new SQLiteParameter("@customerName",ct.CustomerName),
                new SQLiteParameter("@remark",ct.Remark),
                new SQLiteParameter("@score",ct.Socre)
                };
                    i = SQLiteHelper.ExecuteNoQuery("insert into T_customer(customerid,customername,score,remark) values(@customerId,@customerName,@score,@remark)", sqlparams);
                }

            }

            else
            {
                SQLiteParameter[] sqlparams2 = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",ct.CustomerID),
                new SQLiteParameter("@customerName",ct.CustomerName),
                new SQLiteParameter("@remark",ct.Remark),
                new SQLiteParameter("@score",ct.Socre)
                };

                i = SQLiteHelper.ExecuteNoQuery("update T_customer set customername=@customerName,remark=@remark,score=@score where customerid=@customerId", sqlparams2);
 
            }
            return i;
 
        }


        public static int IncreaseCustomerScore(SQLiteTransaction trans,List<Sell> list)
        {

            int i = -1;
            foreach (Sell sell in list)
            {
                Customer ct = GetCustomerByIdNoClose(sell.CustomerID);
                if (ct != null)
                {
                    SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                        new SQLiteParameter("@customerId",ct.CustomerID),                
                        new SQLiteParameter("@score",ct.Socre+sell.RealPay)
                    };

                    i = SQLiteHelper.ExecuteNonQuery(trans, "update T_customer set score=@score where customerid=@customerId", sqlparams);
 
                }
            }
                       
            return i;
        }

        public static int DecreaseCustomerScore(SQLiteTransaction trans, ReGoods regoods)
        {
            int i = -1;
            
                Sell sell = SellService.GetSellBySellIdNoClose(regoods.SellId);
                Customer ct = GetCustomerByIdNoClose(sell.CustomerID);
                if (ct != null)
                {
                    SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                        new SQLiteParameter("@customerId",ct.CustomerID),                
                        new SQLiteParameter("@score",ct.Socre-regoods.ReRealPay)
                    };

                    i = SQLiteHelper.ExecuteNonQuery(trans, "update T_customer set score=@score where customerid=@customerId", sqlparams);

                }
            

            return i;
 
        }





        public static int DeleteCustomerById(string id)
        {
            int i = -1;
            SQLiteParameter[] secparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",id)
                };

            i = SQLiteHelper.ExecuteNoQuery("delete from T_customer where customerid=@customerId", secparams);
            return i;
 
        }

        public static DataTable GetAllCustomersOfTable()
        {
            return SQLiteHelper.GetTable("select * from T_customer");
        }

        public static Customer GetCustomerById(string id)
        {
            Customer ct = null;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",id)
            };
            SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_customer where customerid=@customerId", sqlparams);
            if (sdr.Read())
            {
                ct = new Customer();
                ct.CustomerID = sdr.GetValue(0).ToString();
                ct.CustomerName = sdr.GetValue(1).ToString();
                ct.Socre = Convert.ToInt32(sdr.GetValue(2));
                ct.Remark = sdr.GetValue(3).ToString();
            }
            sdr.Close();

            return ct;           
        }

        public static Customer GetCustomerByIdNoClose(string id)
        {
            Customer ct = null;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@customerId",id)
            };
            SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_customer where customerid=@customerId", sqlparams);
            if (sdr.Read())
            {
                ct = new Customer();
                ct.CustomerID = sdr.GetValue(0).ToString();
                ct.CustomerName = sdr.GetValue(1).ToString();
                ct.Socre = Convert.ToInt32(sdr.GetValue(2));
                ct.Remark = sdr.GetValue(3).ToString();
            }
            

            return ct;
        }

        public static List<Customer> GetCustomersID()
        {
            List<Customer> list = new List<Customer>();
            Customer customer = null;
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select customerID from T_customer"))
            {
                while (sdr.Read())
                {
                    customer = new Customer();
                    customer.CustomerID = sdr.GetValue(0).ToString();
                    list.Add(customer);
                }
                sdr.Close();
 
            }

            return list;
        }
    }
}
