﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SQLite;
using ClothesSys.Model;
using ClothesSys.DBUtility;


namespace ClothesSys.DAL
{
    public class GoodCategoryService
    {
        public static DataTable GetAllGoodCategoryOfTable()
        {
            return SQLiteHelper.GetTable("select * from T_GoodCategory");            
        }

        public static int AddCategory(string cname)
        {
            int i = -1;


            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodcategoryname",cname)
            };

            //判断是否已存在同名的类别,若已存在，则不再插入
            if (SQLiteHelper.ExecuteScalar("select count(*) from T_GoodCategory where goodCategoryName=@goodcategoryname", sqlparam))
            {

                i = SQLiteHelper.ExecuteNoQuery("insert into T_Goodcategory(goodcategoryname) values(@goodcategoryname)", sqlparam);
            }

            return i;
            
        }

        public static int UpdateCategory(string oldName,GoodCategory category)
        {
            int i = -1;
            if (oldName != category.GoodCategoryName)
            {
                SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodcategoryname",category.GoodCategoryName),
                new SQLiteParameter("@goodcategoryId",category.GoodCategoryId)
                };

                //判断是否已存在同名的类别,若已存在，则不再修改
                if (SQLiteHelper.ExecuteScalar("select count(*) from T_GoodCategory where goodCategoryName=@goodcategoryname", sqlparam))
                {

                    i = SQLiteHelper.ExecuteNoQuery("update T_GoodCategory set goodCategoryName=@goodcategoryname where goodCategoryId=@goodcategoryId", sqlparam);
                }

                return i;
            }
            else
            {
                return 1;
            }
        }

        public static GoodCategory GetCategoryByCategoryId(string Categoryid)
        {
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodCategoryId",Categoryid)
            };
            GoodCategory category = null;
            using (SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select * from T_GoodCategory where goodCategoryId=@goodCategoryId", sqlparam))
            {
                
                while (sdr.Read())
                {
                    category = new GoodCategory();
                    category.GoodCategoryId = Convert.ToInt32(sdr.GetValue(0));
                    category.GoodCategoryName = sdr.GetValue(1).ToString();
 
                }
                sdr.Close();
            }
            return category;
        }

        

        public static int DeleteGoodCategoryById(string goodCategoryid)
        {
            int i = -1;
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodCategoryId",goodCategoryid)
            };
            if (SQLiteHelper.ExecuteScalar("select count(*) from T_good where categoryId=@goodCategoryId", sqlparam))
            {
                i = SQLiteHelper.ExecuteNoQuery("delete from T_goodCategory where goodCategoryId=@goodCategoryId", sqlparam);
            }
            return i;
        }
    }
}
