﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SQLite;
using ClothesSys.Model;
using ClothesSys.DBUtility;

namespace ClothesSys.DAL
{
    public class GoodService
    {
        public static DataTable GetAllGoodsOfTable()
        {
            return SQLiteHelper.GetTable("select a.goodId,a.goodName,a.produceArea,b.goodCategoryName,a.remark from T_good as a,T_goodCategory as b where a.categoryId=b.goodCategoryId");
        }

        public static int AddGood(Good good)
        {
            int i = -1;


            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@goodId",good.GoodID),
                new SQLiteParameter("@goodName",good.GoodName),
                new SQLiteParameter("@produceArea",good.ProduceArea),
                new SQLiteParameter("@categoryId",good.CategoryID),
                new SQLiteParameter("@remark",good.Remark)
            };


            //增加商品之前先查询有无相同ID商品
            if (SQLiteHelper.ExecuteScalar("select count(*) from T_good where goodId=@goodId", sqlparams))
            {
                i = SQLiteHelper.ExecuteNoQuery("insert into T_good(goodId,goodName,produceArea,categoryId,remark) values(@goodId,@goodName,@produceArea,@categoryId,@remark)", sqlparams);
            }
            return i;
        }

        public static int UpdateGood(string oldid, Good good)
        {
            int i = -1;

            
                SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@goodId",good.GoodID),
                new SQLiteParameter("@goodName",good.GoodName),
                new SQLiteParameter("@produceArea",good.ProduceArea),
                new SQLiteParameter("@categoryId",good.CategoryID),
                new SQLiteParameter("@remark",good.Remark)
            };

                if (oldid != good.GoodID)
                {
                    SQLiteParameter[] param = new SQLiteParameter[]{
                new SQLiteParameter("@oldid",oldid)
                 };


                    //增加商品之前先查询有无相同ID商品
                    if (SQLiteHelper.ExecuteScalar("select count(*) from T_good where goodId=@goodId", sqlparams))
                    {

                        SQLiteHelper.ExecuteNoQuery("delete from T_good where goodId=@oldid", param);

                        i = SQLiteHelper.ExecuteNoQuery("insert into T_good(goodId,goodName,produceArea,categoryId,remark) values(@goodId,@goodName,@produceArea,@categoryId,@remark)", sqlparams);
                    }
                }
                else
                {
                    i = SQLiteHelper.ExecuteNoQuery("update T_good set goodName=@goodName,produceArea=@produceArea,remark=@remark,categoryId=@categoryId where goodId=@goodId", sqlparams);

                }

            return i;
 
        }

        public static int DeleteGoodById(string id)
        {
            int i = -1;
            SQLiteParameter[] param = new SQLiteParameter[]{
                new SQLiteParameter("@goodId",id)
            };
            i = SQLiteHelper.ExecuteNoQuery("delete from T_good where goodId=@goodId", param);
            return i;
        }



        /// <summary>
        /// 
        /// </summary>
        /// <param name="id">GoodID</param>
        /// <returns></returns>
        public static Good GetGoodById(string id)
        {
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodId",id)
            };

            Good g = null;
            using (SQLiteDataReader sdr
                = SQLiteHelper.GetReader("select * from T_good where goodId=@goodId", sqlparam))
            {
                while (sdr.Read())
                {
                    g = new Good();
                    g.GoodID = sdr.GetValue(0).ToString();
                    g.GoodName = sdr.GetValue(1).ToString();
                    g.ProduceArea = sdr.GetValue(2).ToString();
                    g.CategoryID = Convert.ToInt32(sdr.GetValue(3));
                    g.Remark = sdr.GetValue(4).ToString();
                }
                sdr.Close();
 
            }

            return g;
        }


        public static List<Good> GetGoods()
        {

            List<Good> list = new List<Good>();
            Good good = null;
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select goodId from T_good"))
            {
                while (sdr.Read())
                {
                    good = new Good();
                    good.GoodID = sdr.GetValue(0).ToString();
                    list.Add(good);
                }
                sdr.Close();
 
            }

            return list;
        }


        /// <summary>
        /// 根据CategoryId获得Good表
        /// </summary>
        /// <param name="cid">CategoryId</param>
        /// <returns></returns>
        public static DataTable GetGoodsByCategoryId(string cid)
        {
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@categoryId",cid)
            };
            DataTable dt = null;
            dt = SQLiteHelper.GetTable("select goodid,goodname from T_good where categoryId=@categoryId", sqlparam);
            return dt;
        }


        
    }
}
