﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SQLite;
using ClothesSys.Model;
using ClothesSys.DBUtility;


namespace ClothesSys.DAL
{
    public class ReGoodService
    {
        /// <summary>
        /// 获得当天退货记录
        /// </summary>
        /// <returns></returns>
        public static DataTable GetReGoodsOfToday()
        {
            

            string sql = "select regoodsBillId,regoodsId,goodName,regoodsNum,regoodsPrice,reNeedPay,reRealPay,reGoodsResult,reGoodsTime,userId from T_regoods,T_good where T_good.goodId=T_regoods.regoodsId";
            sql += " and regoodsTime<datetime('now','localtime') and regoodsTime>datetime('now','start of day')";
            return SQLiteHelper.GetTable(sql);
 
        }


        public static bool ReGoodSumbit(ReGoods regoods)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@regoodsId",regoods.ReGoodsID),
                new SQLiteParameter("@regoodsNum",regoods.ReGoodsNum),
                new SQLiteParameter("@regoodsPrice",regoods.ReGoodsPrice),
                new SQLiteParameter("@reNeedPay",regoods.ReNeedPay),
                new SQLiteParameter("@reRealpay",regoods.ReRealPay),
                new SQLiteParameter("@regoodsResult",regoods.ReGoodResult),
                new SQLiteParameter("@userId",regoods.UserId),
                new SQLiteParameter("@sellId",regoods.SellId),
                new SQLiteParameter("@regoodsTime",regoods.RegoodsTime.ToString("yyyy-MM-dd HH:mm:ss"))
            };

            string sql = "insert into T_regoods(regoodsid,regoodsNum,regoodsPrice,reNeedPay,reRealPay,regoodsResult,userId,regoodsTime,sellId) ";
            sql+=" values(@regoodsid,@regoodsNum,@regoodsPrice,@reNeedPay,@reRealPay,@regoodsResult,@userId,@regoodsTime,@sellId)";
            try
            {
                SQLiteConnection con = SQLiteHelper.GetConnection();
                SQLiteTransaction trans = con.BeginTransaction();

                SQLiteHelper.ExecuteNonQuery(trans, sql, sqlparams);

                CustomerService.DecreaseCustomerScore(trans, regoods);
                StockService.IncreaseStocskNumByGoodId(regoods.ReGoodsID, regoods.ReGoodsNum);

                trans.Commit();
                return true;
            }
            catch (Exception ex)
            {
                return false;
                throw ex;
            }
 
        }


        public static ReGoods GetReGoodsByReGoodsBillId(string id)
        {
            ReGoods regood = null;

            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_regoods"))
            {
                while (sdr.Read())
                {
                    regood = new ReGoods();
                    regood.ReGoodsID = sdr.GetValue(0).ToString();
                    regood.ReGoodsNum = Convert.ToInt32(sdr.GetValue(2));
                    regood.ReGoodsPrice = Convert.ToInt32(sdr.GetValue(3));
                    regood.ReNeedPay = Convert.ToInt32(sdr.GetValue(4));
                    regood.ReRealPay = Convert.ToInt32(sdr.GetValue(5));
                    regood.ReGoodResult = sdr.GetValue(6).ToString();
                    regood.UserId = sdr.GetValue(7).ToString();
                    regood.RegoodsTime = Convert.ToDateTime(sdr.GetValue(8));
                    regood.RegoodsBillId = Convert.ToInt32(sdr.GetValue(9));
                    regood.SellId = sdr.GetValue(10).ToString();
                }

                sdr.Close();
            }

            return regood;
        }
    }
}
