﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SQLite;
using ClothesSys.DBUtility;
using ClothesSys.Model;
using ClothesSys.DAL;

namespace ClothesSys.DAL
{
    public class SellService
    {

        /// <summary>
        /// 得到目前为止今日的销售情况表
        /// </summary>
        /// <returns></returns>
        public static DataTable GetSellRecordsOfToday()
        {
            DataTable dt = null;
            //string sql = "select sellTime,goodName,goodsPrice,sellNum,realPay from T_sell,T_good ";
            //sql += "where sellTime<datetime('now','localtime') and sellTime>datetime('now','start of day')";

            string sql = "select selltime,goodname,goodsprice,sellnum,realpay from T_sell,T_good where T_sell.goodsId=T_good.goodId";
            sql += " and sellTime>datetime('now','start of day') and sellTime<datetime('now','localtime')";

            dt = SQLiteHelper.GetTable(sql);
            return dt;
        }



        /// <summary>
        ///得到一段时间的销售情况表
        /// </summary>
        /// <param name="date"></param>
        /// <returns></returns>
        public static DataTable GetSellRecordsByDay(DateTime starttime,DateTime endtime)
        {
            DataTable dt = null;
            string daystart = starttime.ToString("yyyy-MM-dd") + " 00:00:00";
            string dayend = endtime.ToString("yyyy-MM-dd") + " 23:59:59";
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@dayStart",daystart),
                new SQLiteParameter("@dayEnd",dayend)
            };

            string sql = "select sellTime,goodName,goodsPrice,sellNum,realPay from T_stock,T_good ";
            sql += "where sellTime>@dayStart and sellTime<@dayEnd";

            dt = SQLiteHelper.GetTable(sql, sqlparams);
            return dt;

        }


        public static bool AddSells(List<Sell> list)
        {
            int i = -1;
            string sql = "insert into T_sell(sellId,userId,customerId,goodsId,sellNum,sellTime,goodsPrice,needPay,realPay,remark) ";
            sql += "values(@sellId,@userId,@customerId,@goodsId,@sellNum,@sellTime,@goodsPrice,@needPay,@realPay,@remark)";
            SQLiteConnection con = SQLiteHelper.GetConnection();
            SQLiteTransaction trans = con.BeginTransaction();
            try
            {

                Customer ct = null;
                foreach (Sell sell in list)
                {

                    SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@sellId",sell.SellID),
                new SQLiteParameter("@userId",sell.UserID),
                new SQLiteParameter("@customerId",sell.CustomerID),
                new SQLiteParameter("@goodsId",sell.GoodsId),
                new SQLiteParameter("@sellNum",sell.SellNum),
                new SQLiteParameter("@sellTime",sell.SellTime.ToString("yyyy-MM-dd HH:mm:ss")),  //2012-06-14T22:21:17  SQLite要求必须这种时间格式
                new SQLiteParameter("@goodsPrice",sell.GoodsPrice),
                new SQLiteParameter("@needPay",sell.NeedPay),
                new SQLiteParameter("@realPay",sell.RealPay),
                new SQLiteParameter("@remark",sell.Remark)
                };


                    i += SQLiteHelper.ExecuteNonQuery(trans, sql, sqlparams);

                    

                }

                i += BillService.AddBill(trans, list);
                i += CustomerService.IncreaseCustomerScore(trans, list);
                i += StockService.DecreaseStocskNum(trans, list);
                
                

                trans.Commit();
                return true;

            }
            catch (Exception ex)
            {
                trans.Rollback();
                return false;
                throw ex;
            }

        }



        public static int AddOneSell(Sell sell)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@sellId",sell.SellID),
                new SQLiteParameter("@userId",sell.UserID),
                new SQLiteParameter("@customerId",sell.CustomerID),
                new SQLiteParameter("@goodsId",sell.GoodsId),
                new SQLiteParameter("@sellNum",sell.SellNum),
                new SQLiteParameter("@sellTime",sell.SellTime.ToString()),
                new SQLiteParameter("@goodsPrice",sell.GoodsPrice),
                new SQLiteParameter("@needPay",sell.NeedPay),
                new SQLiteParameter("@realPay",sell.RealPay),
                new SQLiteParameter("@remark",sell.Remark)
            };
            int i = -1;
            string sql = "insert into T_sell(sellId,userId,custoemrId,goodsId,sellNum,sellTime,goodsPrice,needPay,realPay,remark) ";
            sql += "values(@sellId,@userId,@custoemrId,@goodsId,@sellNum,@sellTime,@goodsPrice,@needPay,@realPay,@remark)";
            i = SQLiteHelper.ExecuteNoQuery(sql, sqlparams);
            return i;
        }

        public static int DeleteSellBySellId(string sid)
        {
            int i = -1;
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@sellId",sid)
            };
            i = SQLiteHelper.ExecuteNoQuery("delte from T_sell where sellId=@sellId", sqlparam);
            return i;

        }

        public static Sell GetSellBySellId(string sid)
        {
            Sell sell = null;
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@sellId",sid)
            };
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_sell where sellId=@sellId", sqlparam))
            {
                while (sdr.Read())
                {
                    sell = new Sell();
                    sell.SellID = sdr.GetValue(0).ToString();
                    sell.UserID = sdr.GetValue(1).ToString();
                    sell.CustomerID = sdr.GetValue(2).ToString();
                    sell.GoodsId = sdr.GetValue(3).ToString();
                    sell.SellNum = Convert.ToInt32(sdr.GetValue(5));
                    sell.SellTime = Convert.ToDateTime(sdr.GetValue(6));
                    sell.GoodsPrice = Convert.ToInt32(sdr.GetValue(7));
                    sell.NeedPay = Convert.ToInt32(sdr.GetValue(8));
                    sell.RealPay = Convert.ToInt32(sdr.GetValue(9));
                    sell.Remark = sdr.GetValue(10).ToString();
                }
                sdr.Close();
            }
            return sell;

        }


        public static Sell GetSellBySellIdNoClose(string sid)
        {
            Sell sell = null;
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@sellId",sid)
            };
            SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_sell where sellId=@sellId", sqlparam);
            {
                while (sdr.Read())
                {
                    sell = new Sell();
                    sell.SellID = sdr.GetValue(0).ToString();
                    sell.UserID = sdr.GetValue(1).ToString();
                    sell.CustomerID = sdr.GetValue(2).ToString();
                    sell.GoodsId = sdr.GetValue(3).ToString();
                    sell.SellNum = Convert.ToInt32(sdr.GetValue(5));
                    sell.SellTime = Convert.ToDateTime(sdr.GetValue(6));
                    sell.GoodsPrice = Convert.ToInt32(sdr.GetValue(7));
                    sell.NeedPay = Convert.ToInt32(sdr.GetValue(8));
                    sell.RealPay = Convert.ToInt32(sdr.GetValue(9));
                    sell.Remark = sdr.GetValue(10).ToString();
                }
                
            }
            return sell;

        }



    }
}
