﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SQLite;
using ClothesSys.Model;
using ClothesSys.DBUtility;

namespace ClothesSys.DAL
{
    public class StockService
    {
        public static DataTable GetAllStockOfTable()
        {
            return SQLiteHelper.GetTable("select s.stockId,s.stockTime,u.Name,s.goodsId,s.goodsNum,s.stockNum,s.realPay from T_stock as s,T_user as u where s.userId=u.userId");
        }

        public static Stock GetStockByStockId(string sid)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@stockId",sid)
            };
            Stock st = null;
            using (SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_stock where stockId=@stockId", sqlparams))
            {
                
                while (sdr.Read())
                {
                    st = new Stock();
                    st.StockId = Convert.ToInt32(sdr.GetValue(0));
                    st.UserId = sdr.GetValue(1).ToString();
                    st.CompanyName = sdr.GetValue(2).ToString();
                    st.CompanyAddress = sdr.GetValue(3).ToString();
                    st.CompanyTel = sdr.GetValue(4).ToString();
                    st.GoodsId = sdr.GetValue(5).ToString();
                    st.GoodsNum = Convert.ToInt32(sdr.GetValue(6));
                    st.StockTime = Convert.ToDateTime(sdr.GetValue(7));
                    st.StockNum = Convert.ToInt32(sdr.GetValue(8));
                    st.GoodPrice = Convert.ToInt32(sdr.GetValue(9));
                    st.NeedPay = Convert.ToInt32(sdr.GetValue(10));
                    st.RealPay = Convert.ToInt32(sdr.GetValue(11));
                    st.Remark = sdr.GetValue(12).ToString();
                    
                }
                sdr.Close();
            }
            return st;

        }

        public static int StockIn(Stock stock)
        {
            int i = -1;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@userId",stock.UserId),
                new SQLiteParameter("@companyName",stock.CompanyName),
                new SQLiteParameter("@companyAddress",stock.CompanyAddress),
                new SQLiteParameter("@companyTel",stock.CompanyTel),
                new SQLiteParameter("@goodsId",stock.GoodsId),
                new SQLiteParameter("@goodsNum",stock.GoodsNum), //入库数量
                new SQLiteParameter("@goodsPrice",stock.GoodPrice),
                new SQLiteParameter("@stockTime",stock.StockTime),
                new SQLiteParameter("@stockNum",stock.StockNum),
                new SQLiteParameter("@needPay",stock.NeedPay),
                new SQLiteParameter("@realPay",stock.RealPay),
                new SQLiteParameter("@remark",stock.Remark)
            };
            string sql = "insert into T_stock(userId,companyName,companyAddress,companyTel,goodsId,goodsNum,goodsPrice,stockTime,stockNum,needPay,realPay,remark) ";
            sql += "values(@userId,@companyName,@companyAddress,@companyTel,@goodsId,@goodsNum,@goodsPrice,@stockTime,@stockNum,@needPay,@realPay,@remark)";
            i = SQLiteHelper.ExecuteNoQuery(sql, sqlparams);

            return i;
        }


        public static Stock GetStockBySGoodIdNoClose(string gid)
        {
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@goodsId",gid)
            };
            Stock st = null;
            SQLiteDataReader sdr = SQLiteHelper.GetReader("select * from T_stock where goodsId=@goodsId", sqlparams);
            {

                while (sdr.Read())
                {
                    st = new Stock();
                    st.StockId = Convert.ToInt32(sdr.GetValue(0));
                    st.UserId = sdr.GetValue(1).ToString();
                    st.CompanyName = sdr.GetValue(2).ToString();
                    st.CompanyAddress = sdr.GetValue(3).ToString();
                    st.CompanyTel = sdr.GetValue(4).ToString();
                    st.GoodsId = sdr.GetValue(5).ToString();
                    st.GoodsNum = Convert.ToInt32(sdr.GetValue(6));
                    st.StockTime = Convert.ToDateTime(sdr.GetValue(7));
                    st.StockNum = Convert.ToInt32(sdr.GetValue(8));
                    st.GoodPrice = Convert.ToInt32(sdr.GetValue(9));
                    st.NeedPay = Convert.ToInt32(sdr.GetValue(10));
                    st.RealPay = Convert.ToInt32(sdr.GetValue(11));
                    st.Remark = sdr.GetValue(12).ToString();

                }
                
            }
            return st;

        }

        public static int DecreaseStocskNum(SQLiteTransaction trans, List<Sell> list)
        {
            int i = -1;
            foreach (Sell sell in list)
            {
                Stock stock = GetStockBySGoodIdNoClose(sell.GoodsId);
                if (stock != null)
                {
                    SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                    new SQLiteParameter("@goodsId",stock.GoodsId),
                    new SQLiteParameter("@stockNum",stock.StockNum-sell.SellNum),                
                    };

                    i = SQLiteHelper.ExecuteNonQuery(trans, "update T_stock set stockNum=@stockNum where goodsId=@goodsId", sqlparams);
 
                }
            }
            return i;
        }

        public static List<Stock> GetStocksByGoodId(string gid)
        {
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodsid",gid)
            };
            
            List<Stock> ls = new List<Stock>();
            using (SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select * from T_stock where goodsId=@goodsid", sqlparam))
            {
                Stock st = null;
                while (sdr.Read())
                {
                    st = new Stock();
                    st.StockId = Convert.ToInt32(sdr.GetValue(0));
                    st.UserId = sdr.GetValue(1).ToString();
                    st.CompanyName = sdr.GetValue(2).ToString();
                    st.CompanyAddress = sdr.GetValue(3).ToString();
                    st.CompanyTel = sdr.GetValue(4).ToString();
                    st.GoodsId = sdr.GetValue(5).ToString();
                    st.GoodsNum = Convert.ToInt32(sdr.GetValue(6));
                    st.StockTime = Convert.ToDateTime(sdr.GetValue(7));
                    st.StockNum = Convert.ToInt32(sdr.GetValue(8));
                    st.GoodPrice = Convert.ToInt32(sdr.GetValue(9));
                    st.NeedPay = Convert.ToInt32(sdr.GetValue(10));
                    st.RealPay = Convert.ToInt32(sdr.GetValue(11));
                    st.Remark = sdr.GetValue(12).ToString();

                    ls.Add(st);
                }
                sdr.Close();
 
            }

            return ls;
        }

        public static int IncreaseStocskNumByGoodId(string gid, int goodsnum)
        {
            int i = -1;
            int oldStockNum = GetStockNumByGoodIdNoClose(gid);
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@goodsId",gid),
                new SQLiteParameter("@stockNum",oldStockNum+goodsnum)
            };

            i= SQLiteHelper.ExecuteNoQuery("update T_stock set stockNum=@stockNum where goodsId=@goodsId", sqlparams);
            return i;
        }

        public static int DecreaseStocskNumByGoodId(string gid, int goodsnum)
        {
            int i = -1;
            int oldStockNum = GetStockNumByGoodIdNoClose(gid);
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@goodsId",gid),
                new SQLiteParameter("@stockNum",oldStockNum-goodsnum)
            };

            i = SQLiteHelper.ExecuteNoQuery("update T_stock set stockNum=@stockNum where goodsId=@goodsId", sqlparams);
            return i;
        }


        public static int GetStockNumByGoodIdNoClose(string gid)
        {
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodsid",gid)
            };
            int stockNum = -1;
            SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select stockNum from T_stock where goodsId=@goodsid", sqlparam);
            {
                if (sdr.Read())
                {
                    stockNum = Convert.ToInt32(sdr.GetValue(0));
                }
                
            }

            return stockNum;

        }


        public static int GetStockNumByGoodId(string gid)
        {
            SQLiteParameter[] sqlparam = new SQLiteParameter[]{
                new SQLiteParameter("@goodsid",gid)
            };
            int stockNum = -1;
            using (SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select stockNum from T_stock where goodsId=@goodsid", sqlparam))
            {
                if (sdr.Read())
                {
                    stockNum = Convert.ToInt32(sdr.GetValue(0));
                }
                sdr.Close();
            }

            return stockNum;
 
        }

        public static int UpdateStock(Stock stock)
        {
            int i = -1;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@stockId",stock.StockId),
                new SQLiteParameter("@userId",stock.UserId),
                new SQLiteParameter("@companyName",stock.CompanyName),
                new SQLiteParameter("@companyAddress",stock.CompanyAddress),
                new SQLiteParameter("@companyTel",stock.CompanyTel),
                new SQLiteParameter("@goodsId",stock.GoodsId),
                new SQLiteParameter("@goodsNum",stock.GoodsNum), //入库数量
                new SQLiteParameter("@goodsPrice",stock.GoodPrice),
                new SQLiteParameter("@stockTime",stock.StockTime),
                new SQLiteParameter("@stockNum",stock.StockNum),
                new SQLiteParameter("@needPay",stock.NeedPay),
                new SQLiteParameter("@realPay",stock.RealPay),
                new SQLiteParameter("@remark",stock.Remark)
            };
            string sql = "update T_stock set remark=@remark where stockId=@stockId";
            i = SQLiteHelper.ExecuteNoQuery(sql, sqlparams);

            return i;
 
        }
    }
}
