﻿using System;
using System.Collections.Generic;
using System.Text;
using ClothesSys.Model;
using ClothesSys.DBUtility;
using System.Data.SQLite;
using System.Data;

namespace ClothesSys.DAL
{
    public class UserService
    {

        /// <summary>
        /// 根据ID取得User对象
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static User GetUserByID(string userID)
        {
            User user = null;

            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@userid",userID)
            };

            using (SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select * from T_user where userid=@userid", sqlparams))
            {
                if (sdr.Read())
                {
                    user = new User();
                    user.UserID = userID;
                    user.Name = sdr.GetValue(1).ToString();
                    user.Password = sdr.GetValue(2).ToString();
                }

                sdr.Close();
            }

            return user;          
        }


        /// <summary>
        /// 返回所有操作员表
        /// </summary>
        /// <returns></returns>
        public static DataTable GetAllUsersOfTable()
        {
            return SQLiteHelper.GetTable("select * from T_user"); 
        }

        public static List<User> GetAllUsers()
        {
            User user = null;

            List<User> list = new List<User>();

            using (SQLiteDataReader sdr =
                SQLiteHelper.GetReader("select * from T_user"))
            {
                while (sdr.Read())
                {
                    user = new User();
                    user.UserID = sdr.GetValue(0).ToString();
                    user.Name = sdr.GetValue(1).ToString();
                    user.Password = sdr.GetValue(2).ToString();
                    list.Add(user);
                }

                sdr.Close();
            }

            return list;
            
        }


        /// <summary>
        /// 增加用户
        /// </summary>
        /// <param name="user"></param>
        /// <returns>i>0表示增加用户成功</returns>
        public static int AddUser(User user)
        {
            int i = -1;
            SQLiteParameter[] preparams = new SQLiteParameter[]{
                new SQLiteParameter("@userid",user.UserID)
            };

            if (SQLiteHelper.ExecuteScalar("select count(*) from T_user where userid=@userid", preparams))
            {

                SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@userid",user.UserID),
                new SQLiteParameter("@name",user.Name),
                new SQLiteParameter("@password",user.Password)
            };


                i = SQLiteHelper.ExecuteNoQuery("insert into T_user(userid,name,password) values(@userid,@name,@password)", sqlparams);
            }
            return i;
        }



        /// <summary>
        /// 根据用户ID更新用户信息
        /// </summary>
        /// <param name="user"></param>
        /// <returns></returns>
        public static int UpdateUser(User user)
        {
            int i = -1;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@userid",user.UserID),
                new SQLiteParameter("@name",user.Name),
                new SQLiteParameter("@password",user.Password)
            };
            i = SQLiteHelper.ExecuteNoQuery("update T_user set name=@name,password=@password where userid=@userid", sqlparams);
            return i;
        }

        /// <summary>
        /// 根据用户ID删除用户
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public static int DeleteUserByID(string userid)
        {
            int i = -1;
            SQLiteParameter[] sqlparams = new SQLiteParameter[]{
                new SQLiteParameter("@userid",userid)
            };

            if (SQLiteHelper.ExecuteScalar("select count(*) from T_stock where userId=@userid", sqlparams))
            {
                i = SQLiteHelper.ExecuteNoQuery("delete from T_user where userid=@userid", sqlparams);
            }
            return i;
        }






    }
}
