package filter;

import java.io.IOException;

import javax.servlet.Filter;

import javax.servlet.FilterChain;

import javax.servlet.FilterConfig;

import javax.servlet.ServletException;

import javax.servlet.ServletRequest;

import javax.servlet.ServletResponse;

import javax.servlet.UnavailableException;

import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;

public class SetCharacterEncodingFilter implements Filter{

 

  public SetCharacterEncodingFilter() {

  }

 

  protected String encoding = null;

  protected FilterConfig filterConfig = null;

  protected boolean ignore = true;

 

  public void destroy(){

    this.encoding = null;

    this.filterConfig = null;

  }

 

  public void doFilter(ServletRequest request,ServletResponse response,FilterChain chain)throws IOException,ServletException{

    if(ignore || request.getCharacterEncoding() == null){

      encoding = selectEncoding(request);

      if(encoding != null){

        request.setCharacterEncoding(encoding);

      }

    }

    chain.doFilter(request,response);

  }

 

  public void init(FilterConfig filterConfig) throws ServletException {

    this.filterConfig = filterConfig;

    this.encoding = filterConfig.getInitParameter("encoding");

    String value = filterConfig.getInitParameter("ignore");

    if(value == null){

      ignore = true;

    } else if(value.equalsIgnoreCase("true")){

       ignore = true;

    } else if(value.equalsIgnoreCase("yes")){

       ignore = true;

    } else{

       ignore = false;

    }

  }

 

  protected String selectEncoding(ServletRequest request){

    return this.encoding;

  }

 

}

