/*==============================================================*/
/* DBMS name:      Microsoft SQL Server 2005                    */
/* Created on:     2021/1/18 9:26:34                            */
/*==============================================================*/

create database LanMengDB
go
use LanMengDB


if exists (select 1
   from sys.sysreferences r join sys.sysobjects o on (o.id = r.constid and o.type = 'F')
   where r.fkeyid = object_id('NewsInfo') and o.name = 'FK_NEWSINFO_REFERENCE_USERINFO')
alter table NewsInfo
   drop constraint FK_NEWSINFO_REFERENCE_USERINFO
go

if exists (select 1
            from  sysobjects
           where  id = object_id('AlbumInfo')
            and   type = 'U')
   drop table AlbumInfo
go

if exists (select 1
            from  sysobjects
           where  id = object_id('Comments;')
            and   type = 'U')
   drop table Comments;
go

if exists (select 1
            from  sysobjects
           where  id = object_id('MusicInfo')
            and   type = 'U')
   drop table MusicInfo
go

if exists (select 1
            from  sysobjects
           where  id = object_id('MusicList')
            and   type = 'U')
   drop table MusicList
go

if exists (select 1
            from  sysobjects
           where  id = object_id('MusicListInfo')
            and   type = 'U')
   drop table MusicListInfo
go

if exists (select 1
            from  sysobjects
           where  id = object_id('NewsInfo')
            and   type = 'U')
   drop table NewsInfo
go

if exists (select 1
            from  sysobjects
           where  id = object_id('SingType')
            and   type = 'U')
   drop table SingType
go

if exists (select 1
            from  sysobjects
           where  id = object_id('SingerInfo')
            and   type = 'U')
   drop table SingerInfo
go

if exists (select 1
            from  sysobjects
           where  id = object_id('UserInfo')
            and   type = 'U')
   drop table UserInfo
go


/*==============================================================*/
/* Table: UserInfo                                              */
/*==============================================================*/
create table UserInfo (
   [UID]                int     primary key   identity,
   UserName             nvarchar(50)         null,
   [PassWord]             nvarchar(50)         null,
   Sex                  varchar(10)          null,
   Interest             nvarchar(50)         null,
   Email                varchar(100)         null,
   NativePlace          nvarchar(50)         null,
   Remark               text                 null
)

/*==============================================================*/
/* Table: SingerInfo  Ϣ                                          */
/*==============================================================*/
create table SingerInfo (
   [SID]   int primary key   identity,
   SName  nvarchar(50) not null,
   Sex     varchar(10) not null,
   Explain   text  null,
)
go

/*==============================================================*/
/* Table: AlbumInfo  ר                                      */
/*==============================================================*/
create table AlbumInfo (
   AID   int  primary key  identity,
   AName  nvarchar(100) not null,
   AExplain   text  null,
   PublicDate  datetime   not null,
   [SID] int foreign key references SingerInfo (SID) not null,  
)
go



/*==============================================================*/
/* Table: SingType                                             */
/*==============================================================*/
create table SingType (
   TypeID               int    primary key              identity,
   TypeName             nvarchar(100)     not   null
)
go
/*==============================================================*/
/* Table: MusicInfo                                             */
/*==============================================================*/
create table MusicInfo (
   MID                  int    primary key              identity,
   AID                  int   foreign key references AlbumInfo (AID) not null,
   [SID]                int   foreign key references SingerInfo (SID) not null,
   TypeID               int   foreign key references SingType (TypeID) not null,
   PublicDate           datetime           not  null,
   MExplain             text               not  null,
   Mtitle               nvarchar(100)      not  null,
   MFile                varchar(200)         null
)
go

/*==============================================================*/
/* Table: MusicList    赥                                         */
/*==============================================================*/
create table MusicList (
   MLID                 int     primary key             identity,
   Title                nvarchar(200)      not  null,
   UserId               int    foreign key references UserInfo (Uid) not  null,
   Explain              text                 null
)
go

/*==============================================================*/
/* Table: MusicListInfo   MusicListInfo                                      */
/*==============================================================*/
create table MusicListInfo (
   LID                  int       primary key           identity,
   MID                  int     foreign key references MusicInfo (MID) not  null,
   UDate                datetime             null,
   MLID                 int    foreign key references MusicList (MLID) not  null
)
go

/*==============================================================*/
/* Table: NewsInfo     ר                                         */
/*==============================================================*/
create table NewsInfo (
   NewsID               int   primary key    identity,
   [UID]                  int   foreign key references UserInfo (UID) not  null,
   NewsTitle            nvarchar(500)     not   null,
   NewsContent          text              not   null,
   PublicDate           datetime             null
)
go







/*==============================================================*/
/* Table: Comments ۱jQueryԤ                                             */
/*==============================================================*/
create table Comments (
   CID                  int     primary key             identity,
   MID                  int     foreign key references MusicInfo (MID) not  null,
   UserID               int    foreign key references UserInfo (UID) not  null,
   Content              text                 null,
   SDate                datetime             null
)
go

SELECT MID,MusicInfo.AID,AName,MusicInfo.[SID],SName,MusicInfo.TypeID,TypeName,MusicInfo.PublicDate,MExplain,Mtitle,MFile
                              FROM MusicInfo,AlbumInfo,SingerInfo,SingType
                              where MusicInfo.AID=AlbumInfo.AID and MusicInfo.[SID]=SingerInfo.[SID]
                              and MusicInfo.TypeID=SingType.TypeID  and SingerInfo.SName like '%%'




							select AID,AName,s.SName,AExplain,PublicDate from  AlbumInfo as a ,SingerInfo as s where a.SID=s.SID
							and AName like  '%%'
		INSERT INTO [dbo].[AlbumInfo]
           ([AName]
           ,[AExplain]
           ,[PublicDate]
           ,[SID])
     VALUES('쳾ջ','ǳ','2021-01-01',1)