﻿(function($) {
	$.quickFlip = {
		wrappers : [],
		options : [],
		objs : [],

		init : function(options, box) {
			var options = options || {};

			options.closeSpeed = options.closeSpeed || 180;
			options.openSpeed = options.openSpeed || 120;

			options.ctaSelector = options.ctaSelector || '.quickFlipCta';

			options.refresh = options.refresh || false;

			options.easing = options.easing || 'swing';

			var $box = typeof (box ) != 'undefined' ? $(box) : $('.quickFlip');
			var $kids = $box.children();

			// define $box css
			if ($box.css('position') == 'static')
				$box.css('position', 'relative');

			// define this index
			var i = $.quickFlip.wrappers.length;

			// close all but first panel before calculating dimensions
			$kids.each(function(j) {
				var $this = $(this);

				// attach standard click handler
				if (options.ctaSelector)
					$.quickFlip.attachHandlers($(options.ctaSelector, $this), i, j);

				if (j)
					$this.hide();
			});

			$.quickFlip.options.push(options);

			$.quickFlip.objs.push({
				$box : $($box),
				$kids : $($kids)
			});

			$.quickFlip.buildQuickFlip(i);

			// quickFlip set up again on window resize

			$(window).resize(function() {
				for (var i = 0; i < $.quickFlip.wrappers.length; i++) {
					$.quickFlip.removeFlipDivs(i);

					$.quickFlip.buildQuickFlip(i);
				}
			});
		},

		buildQuickFlip : function(i, currPanel) {
			// get box width and height
			$.quickFlip.options[i].panelWidth = $.quickFlip.options[i].panelWidth || $.quickFlip.objs[i].$box.width();
			$.quickFlip.options[i].panelHeight = $.quickFlip.options[i].panelHeight || $.quickFlip.objs[i].$box.height();

			// init quickFlip, gathering info and building necessary objects
			var options = $.quickFlip.options[i];

			var thisFlip = {
				wrapper : $.quickFlip.objs[i].$box,
				index : i,
				halfwidth : parseInt(options.panelWidth / 2),
				classNames : [],
				panels : [],
				flipDivs : [],
				flipDivCols : [],
				currPanel : currPanel || 0,
				options : options
			};

			// define each panel
			$.quickFlip.objs[i].$kids.each(function(j) {
				var $thisPanel = addPanelCss($(this));

				thisFlip.panels.push($thisPanel);
				thisFlip.classNames.push($thisPanel[0].className);

				// build flipDivs
				var $flipDivs = buildFlip(thisFlip, j).hide().appendTo(thisFlip.wrapper);

				thisFlip.flipDivs.push($flipDivs);
				thisFlip.flipDivCols.push($flipDivs.children());
			});

			$.quickFlip.wrappers[i] = thisFlip;

			function buildFlip(x, y) {
				var $out = $('<div></div>');

				var inner = x.panels[y].html();

				var $leftCol = $(buildFlipCol(x, x.classNames[y], inner)).appendTo($out);
				var $rightCol = $(buildFlipCol(x, x.classNames[y], inner)).appendTo($out);

				$leftCol.css('right', x.halfwidth);
				$rightCol.css('left', x.halfwidth);

				$rightCol.children().css({
					right : 0,
					left : 'auto'
				});

				return $out;
			}

			// builds one column of the flip divs (left or right side)
			function buildFlipCol(x, classNames, inner) {
				var $col = $('<div></div>');

				$col.css({
					width : x.halfwidth,
					height : options.panelHeight,
					position : 'absolute',
					top : 0,
					overflow : 'hidden',
					margin : 0,
					padding : 0
				});

				var $inner = addPanelCss('<div></div>');
				$inner.addClass(classNames);
				$inner.html(inner);

				$col.html($inner);

				return $col;
			}

			// add css for inner panel
			function addPanelCss($panel) {
				if ( typeof ($panel.css ) == 'undefined')
					$panel = $($panel);

				$panel.css({
					position : 'absolute',
					top : 0,
					left : 0,
					margin : 0,
					padding : 0,
					width : options.panelWidth,
					height : options.panelHeight
				});

				return $panel;
			}

		},

		// function flip ( i is quickflip index, j is index of currently open panel)

		flip : function(i, nextPanel, repeater, options) {

			if ( typeof (i) != 'number' || typeof ($.quickFlip.wrappers[i]) == 'undefined')
				return false;

			var x = $.quickFlip.wrappers[i];

			var j = x.currPanel;
			var k = ( typeof (nextPanel) != 'undefined' && nextPanel != null ) ? nextPanel : (x.panels.length > j + 1 ) ? j + 1 : 0;
			x.currPanel = k;

			var repeater = typeof (repeater) != 'undefined' ? repeater : 1;

			var options = $.quickFlip.combineOptions(options, $.quickFlip.options[i]);

			x.panels[j].hide()

			// if refresh set, remove flipDivs and rebuild
			if (options.refresh) {
				$.quickFlip.removeFlipDivs(i);
				$.quickFlip.buildQuickFlip(i, k);

				x = $.quickFlip.wrappers[i];
			}

			x.flipDivs[j].show();

			// these are due to multiple animations needing a callback
			var panelFlipCount1 = 0;
			var panelFlipCount2 = 0;

			x.flipDivCols[j].animate({
				width : 0
			}, options.closeSpeed, options.easing, function() {
				if (!panelFlipCount1) {
					panelFlipCount1++;
				} else {
					x.flipDivs[k].show();

					x.flipDivCols[k].css('width', 0);

					x.flipDivCols[k].animate({
						width : x.halfwidth
					}, options.openSpeed, options.easing, function() {
						if (!panelFlipCount2) {
							panelFlipCount2++;
						} else {

							x.flipDivs[k].hide();

							x.panels[k].show();

							// handle any looping of the animation
							switch( repeater ) {
								case 0:
								case -1:
									$.quickFlip.flip(i, null, -1);
									break;

								//stop if is last flip, and attach events for msie
								case 1:
									break;

								default:
									$.quickFlip.flip(i, null, repeater - 1);
									break;
							}
						}
					});
				}
			});

		},

		// attach click handlers
		attachHandlers : function($the_cta, i, panel) {
			//attach flip
			$the_cta.click(function(ev) {
				ev.preventDefault();
				$.quickFlip.flip(i);
			});
		},

		removeFlipDivs : function(i) {
			for (var j = 0; j < $.quickFlip.wrappers[i].flipDivs.length; j++)
				$.quickFlip.wrappers[i].flipDivs[j].remove();
		},

		compareObjs : function(obj1, obj2) {
			if (!obj1 || !obj2 || !obj1.length || !obj2.length || obj1.length != obj2.length)
				return false;

			for (var i = 0; i < obj1.length; i++) {
				if (obj1[i] !== obj2[i])
					return false;
			}
			return true;
		},

		combineOptions : function(opts1, opts2) {
			opts1 = opts1 || {};
			opts2 = opts2 || {};

			for (x in opts1 ) {
				opts2[x] = opts1[x];
			}

			return opts2;
		}
	};

	$.fn.quickFlip = function(options) {
		this.each(function() {
			new $.quickFlip.init(options, this);
		});

		return this;
	};

	$.fn.whichQuickFlip = function() {
		var out = null;

		for (var i = 0; i < $.quickFlip.wrappers.length; i++) {
			if ($.quickFlip.compareObjs(this, $($.quickFlip.wrappers[i].wrapper)))
				out = i;
		}

		return out;
	};

	$.fn.quickFlipper = function(options, nextPanel, repeater) {
		this.each(function() {
			var $this = $(this);
			var thisIndex = $this.whichQuickFlip();

			// if doesnt exist, set it up
			if (thisIndex == null) {
				$this.quickFlip(options);

				thisIndex = $this.whichQuickFlip();
			}

			$.quickFlip.flip(thisIndex, nextPanel, repeater, options);
		});
	};

})(jQuery);
$('document').ready(function() {
	$('#flip-container').quickFlip();
	$('#flip-navigation li a').each(function() {
		$(this).click(function() {
			$('#flip-navigation li').each(function() {
				$(this).removeClass('selected');
			});
			$(this).parent().addClass('selected');
			var flipid = $(this).attr('id').substr(4);
			$('#flip-container').quickFlipper({ }, flipid, 1);
			return false;
		});
	});
	media();
});
//
function media() {
	baiduMp3();
	changeBackImg();
	tencent();
	favicons();
	bdshare();
	wenhou();
	var u, w = 600, h = 400, y, t;
	if (!$('#youku')[0]) {
		return false;
	}
	y = $('#youku').text().split(',');
	if (y.length < 3) {
		u = y[0];
	} else {
		u = y[0];
		w = y[1];
		h = y[2];
	}
	t = '<embed type="application/x-shockwave-flash" src="http://static.youku.com/v/swf/qplayer.swf';
	t += '?VideoIDS=' + u + '" width="' + w + '" height="' + h + '" id="movie_player" name="movie_player" bgcolor="#FFFFFF" quality="high"';
	t += 'allowfullscreen="true" wmode="opaque" allowscriptaccess="always" flashvars="Cp=0&Light=on&THX=off&Tid=0&Version=/v1.0.0668&show_ce=1&winType=adshow&isAutoPlay=false"';
	t += 'pluginspage="http://www.macromedia.com/go/getflashplayer" />';
	$('#youku').html(t);
}

function favicons() {
	if (!$('#link')[0]) {
		return false;
	}
	$("#link li a").each(function(e) {
		$(this).prepend("<img src=http://www.google.com/s2/favicons?domain=" + this.href.replace(/^(http:\/\/[^\/]+).*$/, '$1').replace('http://', '') + " style=float:left;margin-right:5px;>");
	});
}

function bdshare() {
	if (!$('#bdshare')[0]) {
		return false;
	}
	var script = document.createElement('script');
	script.type = 'text/javascript';
	script.id = 'bdshare_js';
	script.setAttribute('data', 'type=tools&uid=636112');
	var script2 = document.createElement('script');
	script2.id = 'bdshell_js';
	script2.src = 'http://bdimg.share.baidu.com/static/js/shell_v2.js?cdnversion=' + Math.ceil(new Date() / 3600000);
	document.body.appendChild(script);
	document.body.appendChild(script2);
}

function tencent() {
	var u, w = 600, h = 400, y, t;
	if (!$('#vqq')[0]) {
		return false;
	}
	y = $('#vqq').text().split(',');
	if (y.length < 3) {
		u = y[0];
	} else {
		u = y[0];
		w = y[1];
		h = y[2];

	}
	t = '<embed type="application/x-shockwave-flash" src="http://imgcache.qq.com/tencentvideo_v1/player/TencentPlayer.swf';
	t += '?vid=' + u + '" width="' + w + '" height="' + h + '" id="movie_player" name="movie_player" bgcolor="#FFFFFF" quality="high"';
	t += 'allowfullscreen="true" wmode="opaque" allowscriptaccess="always" flashvars=""';
	t += 'pluginspage="http://www.macromedia.com/go/getflashplayer" />';
	$('#vqq').html(t);
}

function baiduMp3() {
	var t, w = 500, h = 74;
	if (!$('#baidu')[0]) {
		return false;
	}
	y = $('#baidu').text().split(',');
	t = '<embed src="http://box.baidu.com/widget/flash/song.swf?name=' + y[0] + '&artist=' + y[1] + '&autoPlay=true" type="application/x-shockwave-flash" quality="high" height="' + h + '" width="' + w + '"/>';
	$('#baidu').html(t);
}

function changeBackImg() {
	now = new Date();
	erke = now.getSeconds();
	erke = erke - parseInt(erke / 14) * 14 + 1;
	$('#web_bg').html('<img style="position: fixed;" src="images/bg/bg' + erke + '.jpg" height="100%" width="100%" />');
}
function wenhou() {
	if (!$('#wenhou')[0]) {
		return false;
	}
	var now = (new Date()).getHours();
	var t;
	if (now > 0 && now <= 6) {
		htm = "午夜好骚年，快睡觉去，妹纸等你久了会不耐烦的哦...";
	} else if (now > 6 && now <= 11) {
		htm = "早上好骚年，昨夜运动那么长时间还这么早起床，真爷们...";
	} else if (now > 11 && now <= 14) {
		htm = "中午好骚年，停下手中的工作，快去吃饭晚了就没的吃了...";
	} else if (now > 14 && now <= 18) {
		htm = "下午好骚年，累了一上午了，快去休息会扒根烟喝杯茶...";
	} else {
		htm = "晚上好骚年，快睡觉吧别忙了，明天的日头照样红...";
	}
	$('#wenhou').html(t);
}