/*
 *  Copyright (c) 2020 NetEase Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* Code generated by cmd/cgo; DO NOT EDIT. */

/* package command-line-arguments */


#line 1 "cgo-builtin-export-prolog"

#include <stddef.h> /* for ptrdiff_t below */

#ifndef GO_CGO_EXPORT_PROLOGUE_H
#define GO_CGO_EXPORT_PROLOGUE_H

#ifndef GO_CGO_GOSTRING_TYPEDEF
typedef struct { const char *p; ptrdiff_t n; } _GoString_;
#endif

#endif

/* Start of preamble from import "C" comments.  */


#line 3 "etcdclient.go"

#include <stdlib.h>

enum EtcdErrCode
{
    // grpc errCode, 具体的含义见:
    // https://godoc.org/go.etcd.io/etcd/etcdserver/api/v3rpc/rpctypes#ErrGRPCNoSpace
    // https://godoc.org/google.golang.org/grpc/codes#Code
    EtcdOK = 0,
    EtcdCanceled = 1,
    EtcdUnknown = 2,
    EtcdInvalidArgument = 3,
    EtcdDeadlineExceeded = 4,
    EtcdNotFound = 5,
    EtcdAlreadyExists = 6,
    EtcdPermissionDenied = 7,
    EtcdResourceExhausted = 8,
    EtcdFailedPrecondition = 9,
    EtcdAborted = 10,
    EtcdOutOfRange = 11,
    EtcdUnimplemented = 12,
    EtcdInternal = 13,
    EtcdUnavailable = 14,
    EtcdDataLoss = 15,
    EtcdUnauthenticated = 16,

    // 自定义错误码
    EtcdTxnUnkownOp = 17,
    EtcdObjectNotExist = 18,
    EtcdErrObjectType = 19,
    EtcdKeyNotExist = 20,
    EtcdCampaignInternalErr = 21,
    EtcdCampaignLeaderSuccess = 22,
    EtcdObserverLeaderInternal = 23,
    EtcdObserverLeaderChange = 24,
    EtcdLeaderResignErr = 25,
    EtcdLeaderResiginSuccess = 26,
    EtcdGetLeaderKeyErr = 27,
    EtcdGetLeaderKeyOK = 28,
    EtcdObserverLeaderNotExist = 29,
    EtcdObjectLenNotEnough = 30,
};

enum OpType {
  OpPut = 1,
  OpDelete = 2
};

struct EtcdConf {
    char *Endpoints;
    int len;
    int DialTimeout;
};

struct Operation {
    enum OpType opType;
    char *key;
    char *value;
    int keyLen;
    int valueLen;
};

#line 1 "cgo-generated-wrapper"


/* End of preamble from import "C" comments.  */


/* Start of boilerplate cgo prologue.  */
#line 1 "cgo-gcc-export-header-prolog"

#ifndef GO_CGO_PROLOGUE_H
#define GO_CGO_PROLOGUE_H

typedef signed char GoInt8;
typedef unsigned char GoUint8;
typedef short GoInt16;
typedef unsigned short GoUint16;
typedef int GoInt32;
typedef unsigned int GoUint32;
typedef long long GoInt64;
typedef unsigned long long GoUint64;
typedef GoInt64 GoInt;
typedef GoUint64 GoUint;
typedef __SIZE_TYPE__ GoUintptr;
typedef float GoFloat32;
typedef double GoFloat64;
typedef float _Complex GoComplex64;
typedef double _Complex GoComplex128;

/*
  static assertion to make sure the file is being used on architecture
  at least with matching size of GoInt.
*/
typedef char _check_for_64_bit_pointer_matching_GoInt[sizeof(void*)==64/8 ? 1:-1];

#ifndef GO_CGO_GOSTRING_TYPEDEF
typedef _GoString_ GoString;
#endif
typedef void *GoMap;
typedef void *GoChan;
typedef struct { void *t; void *v; } GoInterface;
typedef struct { void *data; GoInt len; GoInt cap; } GoSlice;

#endif

/* End of boilerplate cgo prologue.  */

#ifdef __cplusplus
extern "C" {
#endif


// TODO(lixiaocui): 日志打印看是否需要glog

extern GoUint32 NewEtcdClientV3(struct EtcdConf p0);

extern void EtcdCloseClient();

extern GoUint32 EtcdClientPut(int p0, char* p1, char* p2, int p3, int p4);

/* Return type for EtcdClientPutRewtihRevision */
struct EtcdClientPutRewtihRevision_return {
	GoUint32 r0;
	GoInt64 r1;
};

extern struct EtcdClientPutRewtihRevision_return EtcdClientPutRewtihRevision(int p0, char* p1, char* p2, int p3, int p4);

/* Return type for EtcdClientGet */
struct EtcdClientGet_return {
	GoUint32 r0;
	char* r1;
	GoInt r2;
	GoInt64 r3;
};

extern struct EtcdClientGet_return EtcdClientGet(int p0, char* p1, int p2);

/* Return type for EtcdClientList */
struct EtcdClientList_return {
	GoUint32 r0;
	GoUint64 r1;
	GoInt64 r2;
};

// TODO(lixiaocui): list可能需要有长度限制

extern struct EtcdClientList_return EtcdClientList(int p0, char* p1, char* p2, int p3, int p4);

/* Return type for EtcdClientListWithLimitAndRevision */
struct EtcdClientListWithLimitAndRevision_return {
	GoUint32 r0;
	GoUint64 r1;
	GoInt r2;
	GoInt64 r3;
};

extern struct EtcdClientListWithLimitAndRevision_return EtcdClientListWithLimitAndRevision(unsigned int p0, char* p1, char* p2, int p3, int p4, GoInt64 p5, GoInt64 p6);

extern GoUint32 EtcdClientDelete(int p0, char* p1, int p2);

/* Return type for EtcdClientDeleteRewithRevision */
struct EtcdClientDeleteRewithRevision_return {
	GoUint32 r0;
	GoInt64 r1;
};

extern struct EtcdClientDeleteRewithRevision_return EtcdClientDeleteRewithRevision(int p0, char* p1, int p2);

extern GoUint32 EtcdClientTxn2(int p0, struct Operation p1, struct Operation p2);

extern GoUint32 EtcdClientTxn3(int p0, struct Operation p1, struct Operation p2, struct Operation p3);

extern GoUint32 EtcdClientCompareAndSwap(int p0, char* p1, char* p2, char* p3, int p4, int p5, int p6);

/* Return type for EtcdElectionCampaign */
struct EtcdElectionCampaign_return {
	GoUint32 r0;
	GoUint64 r1;
};

extern struct EtcdElectionCampaign_return EtcdElectionCampaign(char* p0, int p1, char* p2, int p3, GoUint32 p4, GoUint32 p5);

extern GoUint32 EtcdLeaderObserve(GoUint64 p0, char* p1, int p2);

extern GoUint32 EtcdLeaderResign(GoUint64 p0, GoUint64 p1);

/* Return type for EtcdClientGetSingleObject */
struct EtcdClientGetSingleObject_return {
	GoUint32 r0;
	char* r1;
	GoInt r2;
};

extern struct EtcdClientGetSingleObject_return EtcdClientGetSingleObject(GoUint64 p0);

/* Return type for EtcdClientGetMultiObject */
struct EtcdClientGetMultiObject_return {
	GoUint32 r0;
	char* r1;
	GoInt r2;
	char* r3;
	GoInt r4;
};

extern struct EtcdClientGetMultiObject_return EtcdClientGetMultiObject(GoUint64 p0, GoInt p1);

extern void EtcdClientRemoveObject(GoUint64 p0);

#ifdef __cplusplus
}
#endif
