/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.connection;

import com.orientechnologies.orient.connection.OSourceNeo4jInfo;
import com.orientechnologies.orient.context.ONeo4jImporterContext;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;

public class ONeo4jConnectionManager {
    private OSourceNeo4jInfo sourceNeo4jInfo;

    public ONeo4jConnectionManager(OSourceNeo4jInfo sourceNeo4jInfo) {
        this.sourceNeo4jInfo = sourceNeo4jInfo;
    }

    public Session getSession() throws Exception {
        Driver driver = null;
        Session session = null;
        try {
            Config noSSL = Config.build().withEncryptionLevel(Config.EncryptionLevel.NONE).toConfig();
            driver = GraphDatabase.driver(this.sourceNeo4jInfo.getNeo4jUrl(), AuthTokens.basic(this.sourceNeo4jInfo.getNeo4jUsername(), this.sourceNeo4jInfo.getNeo4jPassword()), noSSL);
            session = driver.session();
        }
        catch (Exception e) {
            String mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new RuntimeException(e.getMessage());
        }
        return session;
    }

    public void checkConnection() throws Exception {
        Driver driver = null;
        try (Session session = null;){
            driver = GraphDatabase.driver(this.sourceNeo4jInfo.getNeo4jUrl(), AuthTokens.basic(this.sourceNeo4jInfo.getNeo4jUsername(), this.sourceNeo4jInfo.getNeo4jPassword()));
            session = driver.session();
        }
    }
}

