/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.context;

import com.orientechnologies.orient.context.ONeo4jImporterStatistics;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ONeo4jImporterContext {
    private OrientDB orient;
    private static ONeo4jImporterContext instance = null;
    private OPluginMessageHandler messageHandler;
    private ONeo4jImporterStatistics statistics = new ONeo4jImporterStatistics();

    public ONeo4jImporterContext(OrientDB orientDBInstance) {
        this.orient = orientDBInstance;
    }

    public ONeo4jImporterContext(String url) {
        this.initOrientDBInstance(url);
    }

    public static ONeo4jImporterContext getInstance() {
        return instance;
    }

    public static ONeo4jImporterContext newInstance(OrientDB orientDBInstance) {
        instance = new ONeo4jImporterContext(orientDBInstance);
        return instance;
    }

    public static ONeo4jImporterContext newInstance(String url) {
        instance = new ONeo4jImporterContext(url);
        return instance;
    }

    public String printExceptionMessage(Exception e, String message, String level) {
        message = e.getMessage() != null ? message + "\n" + e.getClass().getName() + " - " + e.getMessage() : message + "\n" + e.getClass().getName();
        switch (level) {
            case "debug": {
                this.messageHandler.debug((Object)this, message);
                break;
            }
            case "info": {
                this.messageHandler.info((Object)this, message);
                break;
            }
            case "warn": {
                this.messageHandler.warn((Object)this, message);
                break;
            }
            case "error": {
                this.messageHandler.error((Object)this, message);
            }
        }
        return message;
    }

    public String printExceptionStackTrace(Exception e, String level) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String s = ((Object)writer).toString();
        switch (level) {
            case "debug": {
                this.messageHandler.debug((Object)this, "\n" + s + "\n");
                break;
            }
            case "info": {
                this.messageHandler.info((Object)this, "\n" + s + "\n");
                break;
            }
            case "warn": {
                this.messageHandler.warn((Object)this, "\n" + s + "\n");
                break;
            }
            case "error": {
                this.messageHandler.error((Object)this, "\n" + s + "\n");
            }
        }
        return s;
    }

    public OrientDB getOrientDBInstance() {
        return this.orient;
    }

    public void initOrientDBInstance(String url) {
        this.orient = new OrientDB(url, OrientDBConfig.defaultConfig());
    }

    public void initOrientDBInstance(String url, OrientDBConfig config) {
        this.orient = new OrientDB(url, config);
    }

    public void closeOrientDBInstance() {
        this.orient.close();
    }

    public OPluginMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(OPluginMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public ONeo4jImporterStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(ONeo4jImporterStatistics statistics) {
        this.statistics = statistics;
    }
}

