/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.http;

import com.orientechnologies.orient.connection.ONeo4jConnectionManager;
import com.orientechnologies.orient.connection.OSourceNeo4jInfo;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.http.ONeo4ImporterListener;
import com.orientechnologies.orient.http.ONeo4jImporterJob;
import com.orientechnologies.orient.server.OServer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ONeo4jImporterHandler {
    private ExecutorService pool = Executors.newFixedThreadPool(1);
    private ONeo4jImporterJob currentJob = null;

    public void executeImport(ODocument cfg, OServer server) {
        ONeo4jImporterJob job = new ONeo4jImporterJob(cfg, server, new ONeo4ImporterListener(){

            @Override
            public void onEnd(ONeo4jImporterJob oTeleporterJob) {
                ONeo4jImporterHandler.this.currentJob = null;
            }
        });
        job.validate();
        this.currentJob = job;
        this.pool.execute(job);
    }

    public void checkConnection(ODocument args) throws Exception {
        String neo4jUrl = (String)args.field("neo4jUrl");
        String neo4jUsername = (String)args.field("neo4jUsername");
        String neo4jPassword = (String)args.field("neo4jPassword");
        OSourceNeo4jInfo sourceNeo4jInfo = new OSourceNeo4jInfo(neo4jUrl, neo4jUsername, neo4jPassword);
        ONeo4jConnectionManager connectionManager = new ONeo4jConnectionManager(sourceNeo4jInfo);
        connectionManager.checkConnection();
    }

    public ODocument status() {
        ODocument status = new ODocument();
        ArrayList<ODocument> jobs = new ArrayList<ODocument>();
        if (this.currentJob != null) {
            jobs.add(this.currentJob.status());
        }
        status.field("jobs", jobs);
        return status;
    }
}

