/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.http;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.context.ONeo4jImporterMessageHandler;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.http.ONeo4ImporterListener;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterPlugin;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSettings;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.orient.server.OServer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ONeo4jImporterJob
implements Runnable {
    private final ODocument cfg;
    private ONeo4ImporterListener listener;
    public Status status;
    public PrintStream stream;
    private ByteArrayOutputStream baos;
    private OPluginMessageHandler messageHandler;
    private OServer currentServerInstance;

    public ONeo4jImporterJob(ODocument cfg, OServer currentServerInstance, ONeo4ImporterListener listener) {
        this.cfg = cfg;
        this.listener = listener;
        this.baos = new ByteArrayOutputStream();
        this.stream = new PrintStream(this.baos);
        this.currentServerInstance = currentServerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String neo4jUrl = (String)this.cfg.field("neo4jUrl");
        String neo4jUsername = (String)this.cfg.field("neo4jUsername");
        String neo4jPassword = (String)this.cfg.field("neo4jPassword");
        String odbName = (String)this.cfg.field("odbName");
        String odbProtocol = (String)this.cfg.field("odbProtocol");
        boolean overrideDB = (Boolean)this.cfg.field("overwriteDB");
        boolean indexesOnRelationships = (Boolean)this.cfg.field("indexesOnRelationships");
        int logLevel = Integer.parseInt((String)this.cfg.field("logLevel"));
        if (logLevel > 0) {
            ++logLevel;
        }
        this.status = Status.RUNNING;
        this.messageHandler = new ONeo4jImporterMessageHandler(this.stream, logLevel);
        ONeo4jImporterSettings settings = new ONeo4jImporterSettings(neo4jUrl, neo4jUsername, neo4jPassword, odbName, odbProtocol, overrideDB, indexesOnRelationships);
        ONeo4jImporterPlugin neo4jImporterPlugin = new ONeo4jImporterPlugin();
        try {
            String databaseDirectory = null;
            OrientDB orientDBInstance = null;
            if (this.currentServerInstance != null) {
                databaseDirectory = this.currentServerInstance.getDatabaseDirectory();
                orientDBInstance = this.currentServerInstance.getContext();
            }
            neo4jImporterPlugin.executeJob(settings, this.messageHandler, databaseDirectory, orientDBInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ONeo4ImporterListener oNeo4ImporterListener = this.listener;
        synchronized (oNeo4ImporterListener) {
            this.status = Status.FINISHED;
            try {
                this.listener.wait(5000L);
                this.listener.onEnd(this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void validate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument status() {
        ONeo4ImporterListener oNeo4ImporterListener = this.listener;
        synchronized (oNeo4ImporterListener) {
            ODocument status = new ODocument();
            status.field("cfg", (Object)this.cfg);
            status.field("status", (Object)this.status);
            String lastBatchLog = "";
            if (this.messageHandler != null) {
                lastBatchLog = this.extractBatchLog();
            }
            status.field("log", (Object)lastBatchLog);
            if (this.status == Status.FINISHED) {
                this.listener.notifyAll();
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractBatchLog() {
        String lastBatchLog = "Current status not correctly loaded.";
        OPluginMessageHandler oPluginMessageHandler = this.messageHandler;
        synchronized (oPluginMessageHandler) {
            int baosInitSize = this.baos.size();
            try {
                lastBatchLog = this.baos.toString("UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int baosFinalSize = this.baos.size();
            if (baosFinalSize - baosInitSize > 0) {
                OLogManager.instance().info((Object)this, "Losing some buffer info.", new Object[0]);
            } else {
                this.baos.reset();
            }
        }
        return lastBatchLog;
    }

    public static enum Status {
        STARTED,
        RUNNING,
        FINISHED;

    }
}

