/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.connection.OSourceNeo4jInfo;
import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.context.ONeo4jImporterStatistics;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterInitializer;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSchemaMigrator;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSettings;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterVerticesAndEdgesMigrator;
import com.orientechnologies.orient.util.OFunctionsHandler;
import java.text.DecimalFormat;
import org.neo4j.driver.v1.Session;

public class ONeo4jImporter {
    public static final String PROGRAM_NAME = "Neo4j to OrientDB Importer";
    private final ONeo4jImporterSettings settings;
    private String orientdbDatabasesAbsolutePath;

    public ONeo4jImporter(ONeo4jImporterSettings settings) throws Exception {
        this.settings = settings;
    }

    public ONeo4jImporter(ONeo4jImporterSettings settings, String orientdbDatabasesAbsolutePath) throws Exception {
        this.settings = settings;
        this.orientdbDatabasesAbsolutePath = orientdbDatabasesAbsolutePath;
    }

    public int execute() throws Exception {
        String dbName;
        int returnCode = 1;
        String logString = "";
        String keepLogString = "";
        long startTime = System.currentTimeMillis();
        boolean migrateRels = true;
        boolean migrateNodes = true;
        boolean relSampleOnly = false;
        DecimalFormat df = new DecimalFormat("#");
        DecimalFormat dfd = new DecimalFormat("#.##");
        logString = "Neo4j to OrientDB Importer - v." + OConstants.getVersion() + " started!\n\n";
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
        String neo4jUrl = this.settings.getNeo4jUrl();
        String neo4jUsername = this.settings.getNeo4jUsername();
        String neo4jPassword = this.settings.getNeo4jPassword();
        String outDbUrl = this.settings.getOrientDbPath();
        String orientDbProtocol = this.settings.getOrientDbProtocol();
        boolean overwriteOrientDBDir = this.settings.getOverwriteOrientDbDir();
        boolean neo4jRelIdIndex = this.settings.getCreateIndexOnNeo4jRelID();
        if (outDbUrl.contains("embedded") || outDbUrl.contains("plocal")) {
            outDbUrl = outDbUrl.replace("plocal", "embedded");
            dbName = outDbUrl.substring(outDbUrl.lastIndexOf(47) + 1);
        } else {
            dbName = outDbUrl.contains("remote") ? outDbUrl.substring(outDbUrl.lastIndexOf(47) + 1) : outDbUrl.substring(outDbUrl.lastIndexOf(47) + 1);
        }
        if (ONeo4jImporterContext.getInstance().getOrientDBInstance().exists(dbName)) {
            if (overwriteOrientDBDir) {
                logString = "The '" + dbName + "' database already exists and the overwrite option is 'true'. The database will be erased before the new migration.";
                ONeo4jImporterContext.getInstance().getMessageHandler().warn((Object)this, logString);
                ONeo4jImporterContext.getInstance().getOrientDBInstance().drop(dbName);
            } else {
                logString = "The '" + dbName + "' database already exists and the overwrite option is 'false' (default). Please delete the database or run the migration with the 'overwrite' option set to true. Terminating the migration.\n\n";
                ONeo4jImporterContext.getInstance().getMessageHandler().error((Object)this, logString);
                throw new RuntimeException(logString);
            }
        }
        try {
            OSourceNeo4jInfo sourceNeo4jInfo = new OSourceNeo4jInfo(neo4jUrl, neo4jUsername, neo4jPassword);
            ONeo4jImporterInitializer initializer = new ONeo4jImporterInitializer(sourceNeo4jInfo, orientDbProtocol, dbName);
            Session neo4jSession = initializer.initConnections();
            String orientVertexClass = initializer.getOrientVertexClass();
            ODatabaseDocument oDb = initializer.getoDb();
            ONeo4jImporterStatistics statistics = ONeo4jImporterContext.getInstance().getStatistics();
            ONeo4jImporterVerticesAndEdgesMigrator verticesAndEdgesImporter = new ONeo4jImporterVerticesAndEdgesMigrator(keepLogString, migrateRels, migrateNodes, df, orientVertexClass, oDb, statistics, relSampleOnly, neo4jRelIdIndex);
            verticesAndEdgesImporter.invoke(neo4jSession);
            keepLogString = verticesAndEdgesImporter.getKeepLogString();
            ONeo4jImporterSchemaMigrator schemaMigrator = new ONeo4jImporterSchemaMigrator(keepLogString, df, oDb, statistics);
            schemaMigrator.invoke(neo4jSession);
            this.stopServers(neo4jSession, oDb);
            this.printSummary(startTime, df, dfd, statistics, initializer, verticesAndEdgesImporter, schemaMigrator, neo4jRelIdIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        returnCode = 0;
        return returnCode;
    }

    private void stopServers(Session neo4jSession, ODatabaseDocument oDb) throws Exception {
        String logString = "\nShutting down OrientDB connection...";
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
        oDb.close();
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\rShutting down OrientDB connection...Done\n");
        logString = "Shutting down Neo4j connection...";
        try {
            if (neo4jSession != null) {
                neo4jSession.close();
            }
        }
        catch (Exception e) {
            String mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new RuntimeException(e.getMessage());
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\rShutting down Neo4j connection...Done\n");
    }

    private void printSummary(long startTime, DecimalFormat df, DecimalFormat dfd, ONeo4jImporterStatistics counters, ONeo4jImporterInitializer initializer, ONeo4jImporterVerticesAndEdgesMigrator migrator, ONeo4jImporterSchemaMigrator schemaMigrator, boolean neo4jRelIdIndex) {
        double value;
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        long elapsedTimeSeconds = elapsedTime / 1000L;
        long initializationElapsedTime = initializer.getInitializationStopTime() - initializer.getInitializationStartTime();
        long initializationElapsedTimeSeconds = initializationElapsedTime / 1000L;
        long importingNodesElapsedTime = counters.importingNodesStopTime - counters.importingNodesStartTime;
        long importingNodesElapsedTimeSeconds = importingNodesElapsedTime / 1000L;
        long importingRelsElapsedTime = migrator.getImportingRelsStopTime() - migrator.getImportingRelsStartTime();
        long importingRelsElapsedTimeSeconds = importingRelsElapsedTime / 1000L;
        long importingSchemaElapsedTime = schemaMigrator.getImportingSchemaStopTime() - schemaMigrator.getImportingSchemaStartTime();
        long importingSchemaElapsedTimeSeconds = importingSchemaElapsedTime / 1000L;
        long internalVertexIndicesElapsedTime = counters.internalVertexIndicesStopTime - counters.internalVertexIndicesStartTime;
        long internalVertexIndicesElapsedTimeSeconds = internalVertexIndicesElapsedTime / 1000L;
        long internalEdgeIndicesElapsedTime = counters.internalEdgeIndicesStopTime - counters.internalEdgeIndicesStartTime;
        long internalEdgeIndicesElapsedTimeSeconds = internalEdgeIndicesElapsedTime / 1000L;
        double neo4jTotalInternalIndicesCounter = counters.neo4jInternalVertexIndicesCounter + counters.neo4jInternalEdgeIndicesCounter;
        String format = "%-100s %s";
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "===============");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "Import Summary:");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "===============");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Found Neo4j Nodes", ": " + df.format(counters.neo4jNodeCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- With at least one Label", ": " + df.format(counters.neo4jNodeMultipleLabelsCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- With multiple Labels", ": " + df.format(counters.neo4jNodeMultipleLabelsCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Without Labels", ": " + df.format(counters.neo4jNodeNoLabelCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Imported OrientDB Vertices", ": " + df.format(counters.orientDBImportedVerticesCounter)});
        if (counters.neo4jNodeCounter > 0.0) {
            value = counters.orientDBImportedVerticesCounter / counters.neo4jNodeCounter * 100.0;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + df.format(value) + "%)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Found Neo4j Relationships", ": " + df.format(counters.neo4jRelCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Imported OrientDB Edges", ": " + df.format(counters.orientDBImportedEdgesCounter)});
        if (counters.neo4jRelCounter > 0.0) {
            value = counters.orientDBImportedEdgesCounter / counters.neo4jRelCounter * 100.0;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + df.format(value) + "%)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Found Neo4j Constraints", ": " + df.format(counters.neo4jConstraintsCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Imported OrientDB Constraints (UNIQUE Indices created)", ": " + df.format(counters.orientDBImportedConstraintsCounter)});
        if (counters.neo4jConstraintsCounter > 0.0) {
            value = counters.orientDBImportedConstraintsCounter / counters.neo4jConstraintsCounter * 100.0;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + df.format(value) + "%)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- NOT UNIQUE Indices created due to failure in creating UNIQUE Indices", ": " + df.format(counters.orientDBImportedNotUniqueWorkaroundCounter)});
        if (counters.neo4jConstraintsCounter > 0.0) {
            value = counters.orientDBImportedNotUniqueWorkaroundCounter / counters.neo4jConstraintsCounter * 100.0;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + df.format(value) + "%)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Found Neo4j (non-constraint) Indices", ": " + df.format(counters.neo4jNonConstraintsIndicesCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Imported OrientDB Indices", ": " + df.format(counters.orientDBImportedIndicesCounter)});
        if (counters.neo4jNonConstraintsIndicesCounter > 0.0) {
            value = counters.orientDBImportedIndicesCounter / counters.neo4jNonConstraintsIndicesCounter * 100.0;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + df.format(value) + "%)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Additional internal Indices created", ": " + df.format(neo4jTotalInternalIndicesCounter) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"- Total Import time:", ": " + OFunctionsHandler.getHMSFormat(elapsedTime) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Initialization time", ": " + OFunctionsHandler.getHMSFormat(initializationElapsedTime) + "\n"});
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Time to Import Nodes", ": " + OFunctionsHandler.getHMSFormat(importingNodesElapsedTime)});
        if (importingNodesElapsedTimeSeconds > 0L) {
            value = counters.orientDBImportedVerticesCounter / (double)importingNodesElapsedTimeSeconds;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + dfd.format(value) + " nodes/sec)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Time to Import Relationships", ": " + OFunctionsHandler.getHMSFormat(importingRelsElapsedTime)});
        if (importingRelsElapsedTimeSeconds > 0L) {
            value = counters.orientDBImportedEdgesCounter / (double)importingRelsElapsedTimeSeconds;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + dfd.format(value) + " rels/sec)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Time to Import Constraints and Indices", ": " + OFunctionsHandler.getHMSFormat(importingSchemaElapsedTime)});
        if (importingSchemaElapsedTimeSeconds > 0L) {
            value = (counters.orientDBImportedConstraintsCounter + counters.orientDBImportedIndicesCounter) / (double)importingSchemaElapsedTimeSeconds;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + dfd.format(value) + " indices/sec)");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Time to Create Internal Indices (on vertex properties 'neo4jNodeID' & 'neo4jLabelList')", ": " + OFunctionsHandler.getHMSFormat(internalVertexIndicesElapsedTime)});
        if (internalVertexIndicesElapsedTimeSeconds > 0L) {
            value = counters.neo4jInternalVertexIndicesCounter / (double)internalVertexIndicesElapsedTimeSeconds;
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + dfd.format(value) + " indices/sec)");
        }
        if (neo4jRelIdIndex) {
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, format, new Object[]{"-- Time to Create Internal Indices (on edge property 'neo4jRelID')", ": " + OFunctionsHandler.getHMSFormat(internalEdgeIndicesElapsedTime)});
            if (internalEdgeIndicesElapsedTimeSeconds > 0L) {
                value = counters.neo4jInternalEdgeIndicesCounter / (double)internalEdgeIndicesElapsedTimeSeconds;
                ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, " (" + dfd.format(value) + " indices/sec)");
            }
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\n");
        String logString = "Neo4j to OrientDB Importer - v." + OConstants.getVersion() + " - PHASE 4 completed!\n\n";
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
    }
}

