/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.context.ONeo4jImporterMessageHandler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.listener.OProgressMonitor;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporter;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterSettings;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import java.util.Timer;
import java.util.TimerTask;

public class ONeo4jImporterMain {
    private static OPluginMessageHandler messageHandler = new ONeo4jImporterMessageHandler(2);

    public static void main(String[] args) throws Exception {
        int returnValue = 1;
        String neo4jUrl = "bolt://localhost:7687";
        String neo4jUsername = "neo4j";
        String neo4jPassword = "admin";
        String odbDir = "/Users/gabriele/orientdb-community-2.2.18-SNAPSHOT/databases/neo4jImport";
        String odbProtocol = "plocal";
        boolean overwriteDB = true;
        boolean createIndexOnNeo4jRelID = true;
        ONeo4jImporterSettings settings = new ONeo4jImporterSettings(neo4jUrl, neo4jUsername, neo4jPassword, odbDir, odbProtocol, overwriteDB, createIndexOnNeo4jRelID);
        returnValue = ONeo4jImporterMain.executeJob(settings);
        System.exit(returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeJob(ONeo4jImporterSettings settings) {
        String outDbUrl = settings.getOrientDbProtocol() + ":" + settings.getOrientDbPath();
        String serverInitUrl = outDbUrl.substring(0, outDbUrl.lastIndexOf(47) + 1);
        ONeo4jImporterContext.newInstance(serverInitUrl);
        ONeo4jImporterContext.getInstance().setMessageHandler(messageHandler);
        ONeo4jImporterContext.getInstance().getMessageHandler().info(ONeo4jImporterMain.class, "\n");
        ONeo4jImporterContext.getInstance().getMessageHandler().info(ONeo4jImporterMain.class, String.format("Neo4j to OrientDB Importer v.%s - %s\n\n", OConstants.getVersion(), "Copyrights (c) 2017 OrientDB LTD"));
        ONeo4jImporterContext.getInstance().getMessageHandler().info(ONeo4jImporterMain.class, "\n");
        int returnValue = 1;
        try {
            OProgressMonitor progressMonitor = new OProgressMonitor();
            progressMonitor.initialize();
            Timer timer = new Timer();
            try {
                timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
                    }
                }, 0L, 1000L);
                ONeo4jImporter neo4jImporter = new ONeo4jImporter(settings);
                returnValue = neo4jImporter.execute();
            }
            finally {
                timer.cancel();
            }
        }
        catch (Exception e) {
            String mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new RuntimeException(e);
        }
        return returnValue;
    }
}

