/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.context.ONeo4jImporterStatistics;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.neo4jimporter.ONeo4jImporterUtils;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.Neo4jException;

class ONeo4jImporterSchemaMigrator {
    private String keepLogString;
    private DecimalFormat df;
    private ODatabaseDocument oDb;
    private ONeo4jImporterStatistics statistics;
    private long importingSchemaStartTime;
    private long importingSchemaStopTime;

    public ONeo4jImporterSchemaMigrator(String keepLogString, DecimalFormat df, ODatabaseDocument oDb, ONeo4jImporterStatistics statistics) {
        this.keepLogString = keepLogString;
        this.df = df;
        this.oDb = oDb;
        this.statistics = statistics;
    }

    public long getImportingSchemaStartTime() {
        return this.importingSchemaStartTime;
    }

    public long getImportingSchemaStopTime() {
        return this.importingSchemaStopTime;
    }

    public void invoke(Session neo4jSession) throws Exception {
        try {
            this.statistics.importingElements = "constraints";
            this.importConstraints(neo4jSession);
            ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\nDone\n\n");
            this.statistics.importingElements = "nothing";
            this.statistics.importingElements = "indices";
            this.importIndices(neo4jSession);
            ONeo4jImporterContext.getInstance().getStatistics().notifyListeners();
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\nDone\n\n");
            this.statistics.importingElements = "nothing";
            String logString = "Neo4j to OrientDB Importer - v." + OConstants.getVersion() + " - PHASE 3 completed!\n";
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void importIndices(Session session) {
        Object mess;
        String logString = "Getting Indices from Neo4j and creating corresponding ones in OrientDB...\n";
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
        List<Record> indices = null;
        try {
            String query = "CALL db.indexes()";
            indices = session.run(query).list();
            this.statistics.neo4jTotalIndices = indices.size();
        }
        catch (Exception e) {
            mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, (String)mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
        try {
            String orientDBIndexClassName = "";
            for (Record currentIndexDefinition : indices) {
                String neo4jLabelOfIndex;
                this.statistics.neo4jIndicesCounter += 1.0;
                String indexDescription = currentIndexDefinition.get("description").asString();
                orientDBIndexClassName = neo4jLabelOfIndex = indexDescription.substring(indexDescription.indexOf(":") + 1, indexDescription.indexOf("("));
                ONeo4jImporterContext.getInstance().getMessageHandler().debug((Object)this, "all index: on label " + neo4jLabelOfIndex);
                this.statistics.neo4jNonConstraintsIndicesCounter += 1.0;
                ONeo4jImporterContext.getInstance().getMessageHandler().debug((Object)this, "non constraint index: on label " + neo4jLabelOfIndex);
                String rawProps = indexDescription.substring(indexDescription.indexOf("(") + 1, indexDescription.indexOf(")"));
                String[] properties = rawProps.split(",");
                if (!this.oDb.getMetadata().getSchema().existsClass(neo4jLabelOfIndex)) {
                    orientDBIndexClassName = ONeo4jImporterUtils.checkVertexClassCreation(neo4jLabelOfIndex, this.oDb);
                }
                for (int i = 0; i < properties.length; ++i) {
                    boolean propertyCreationSuccess = ONeo4jImporterUtils.createOrientDBProperty(session, neo4jLabelOfIndex, orientDBIndexClassName, properties[i], this.oDb, "NOT UNIQUE");
                }
                try {
                    List<String> propertiesList;
                    OClass orientDBClass = this.oDb.getMetadata().getSchema().getClass(orientDBIndexClassName);
                    if (orientDBClass.areIndexed(propertiesList = Arrays.asList(properties))) continue;
                    String statement = propertiesList.size() == 1 ? "create index `" + orientDBClass + "." + propertiesList.get(0) + "` on `" + orientDBClass.getName() + "` (" + rawProps + ") notunique_hash_index" : "create index `" + orientDBClass + ".props` on `" + orientDBClass.getName() + "` (" + rawProps + ") notunique_hash_index";
                    this.oDb.command(statement, new Object[0]);
                    this.statistics.orientDBImportedIndicesCounter += 1.0;
                }
                catch (Exception e) {
                    String mess2 = "Found an error when trying to create a NOTUNIQUE Index in OrientDB. Node label '" + neo4jLabelOfIndex + "': " + e.getMessage();
                    ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess2, "error");
                    ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                }
            }
        }
        catch (Exception e) {
            mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, (String)mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
        this.importingSchemaStopTime = System.currentTimeMillis();
    }

    private String importConstraints(Session session) throws Exception {
        String mess;
        Map<String, Object> neo4jConstraintDefinition;
        Record currentRecord;
        StatementResult result;
        String query;
        String logString;
        OClass multipleLabelClass;
        this.importingSchemaStartTime = System.currentTimeMillis();
        String neo4jPropKey = "";
        Boolean isConstraintsOnNode = false;
        Boolean isConstraintsOnRelationship = false;
        boolean propertyCreationSuccess = false;
        boolean indexWorkaround = true;
        if (indexWorkaround && this.oDb.getMetadata().getSchema().existsClass("MultipleLabelNeo4jConversion") && (multipleLabelClass = this.oDb.getMetadata().getSchema().getClass("MultipleLabelNeo4jConversion")).existsProperty("neo4jLabelList") && this.oDb.getMetadata().getIndexManager().existsIndex("MultipleLabelNeo4jConversion.neo4jLabelList")) {
            logString = "Rebuilding Index MultipleLabelNeo4jConversion.neo4jLabelList. Please wait...\n";
            ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
            try {
                this.oDb.getMetadata().getIndexManager().getClassIndex("MultipleLabelNeo4jConversion", "MultipleLabelNeo4jConversion.neo4jLabelList").rebuild();
                ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\r" + logString + "Done\n");
            }
            catch (Exception e) {
                ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, "\r" + logString + "Failed\n");
                String mess2 = "Found an error when trying to rebuild the index 'MultipleLabelNeo4jConversion.neo4jLabelList': " + e.getMessage();
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess2, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
        }
        logString = "Getting Constraints from Neo4j and creating corresponding ones in OrientDB...\n";
        ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
        try {
            query = "CALL db.constraints()";
            result = session.run(query);
            while (result.hasNext()) {
                currentRecord = result.next();
                neo4jConstraintDefinition = currentRecord.asMap();
                this.statistics.neo4jTotalConstraints += 1.0;
                if ("UNIQUENESS".equals(neo4jConstraintDefinition.get("type"))) {
                    this.statistics.neo4jTotalUniqueConstraints += 1.0;
                }
                if ("NODE_PROPERTY_EXISTENCE".equals(neo4jConstraintDefinition.get("type"))) {
                    this.statistics.neo4jTotalNodePropertyExistenceConstraints += 1.0;
                }
                if (!"RELATIONSHIP_PROPERTY_EXISTENCE".equals(neo4jConstraintDefinition.get("type"))) continue;
                this.statistics.neo4jTotalRelPropertyExistenceConstraints += 1.0;
            }
        }
        catch (Neo4jException e) {
            String mess3 = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess3, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
        try {
            query = "CALL db.constraints()";
            result = session.run(query);
            while (result.hasNext()) {
                currentRecord = result.next();
                neo4jConstraintDefinition = currentRecord.asMap();
                this.statistics.neo4jConstraintsCounter += 1.0;
                String neo4jConstraintType = this.getConstraintType(neo4jConstraintDefinition);
                String orientDBIndexClass = "";
                String neo4jLabel = "";
                try {
                    orientDBIndexClass = neo4jLabel = this.getConstraintLabel(neo4jConstraintDefinition);
                    if (!this.oDb.getMetadata().getSchema().existsClass(neo4jLabel)) {
                        orientDBIndexClass = ONeo4jImporterUtils.checkVertexClassCreation(neo4jLabel, this.oDb);
                    }
                    isConstraintsOnNode = true;
                    isConstraintsOnRelationship = false;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    String neo4jConstraintRelationshipType = this.getRelationshipType(neo4jConstraintDefinition);
                    if (neo4jConstraintRelationshipType != null) {
                        orientDBIndexClass = neo4jConstraintRelationshipType;
                        if (!this.oDb.getMetadata().getSchema().existsClass(orientDBIndexClass)) {
                            this.oDb.createEdgeClass(orientDBIndexClass);
                        }
                        isConstraintsOnNode = false;
                        isConstraintsOnRelationship = true;
                    }
                }
                catch (IllegalStateException neo4jConstraintRelationshipType) {
                    // empty catch block
                }
                neo4jPropKey = this.getConstraintProperty(neo4jConstraintDefinition);
                propertyCreationSuccess = ONeo4jImporterUtils.createOrientDBProperty(session, neo4jLabel, orientDBIndexClass, neo4jPropKey, this.oDb, neo4jConstraintType);
                if (propertyCreationSuccess) {
                    if ("UNIQUENESS".equals(neo4jConstraintType)) {
                        this.statistics.neo4jUniqueConstraintsCounter += 1.0;
                        try {
                            if (isConstraintsOnNode.booleanValue() && this.oDb.getMetadata().getSchema().getClass(orientDBIndexClass).isSubClassOf(this.oDb.getMetadata().getSchema().getClass("V"))) {
                                OIndex orientDBIndex = null;
                                if (!this.oDb.getMetadata().getSchema().getClass(orientDBIndexClass).areIndexed(new String[]{neo4jPropKey})) {
                                    orientDBIndex = this.oDb.getMetadata().getSchema().getClass(orientDBIndexClass).getProperty(neo4jPropKey).createIndex(OClass.INDEX_TYPE.UNIQUE, new ODocument().field("ignoreNullValues", (Object)true));
                                    ONeo4jImporterContext.getInstance().getMessageHandler().debug((Object)this, "\nCreated index: " + orientDBIndex);
                                }
                                ONeo4jImporterContext.getInstance().getMessageHandler().debug((Object)this, "\nIndex already exists: " + orientDBIndex);
                                this.statistics.orientDBImportedUniqueConstraintsCounter += 1.0;
                                this.statistics.orientDBImportedConstraintsCounter += 1.0;
                            }
                        }
                        catch (Exception e) {
                            String mess4 = "Found an error when trying to create a UNIQUE Index in OrientDB. Corresponding Property in Neo4j is '" + neo4jPropKey + "' on node label '" + orientDBIndexClass + "': " + e.getMessage();
                            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess4, "error");
                            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                            try {
                                logString = "Trying to create a NOT UNIQUE Index as workaround...";
                                ONeo4jImporterContext.getInstance().getMessageHandler().info((Object)this, logString);
                                OIndex orientDBIndex = this.oDb.getMetadata().getSchema().getClass(orientDBIndexClass).getProperty(neo4jPropKey).createIndex(OClass.INDEX_TYPE.NOTUNIQUE, new ODocument().field("ignoreNullValues", (Object)true));
                                this.statistics.orientDBImportedNotUniqueWorkaroundCounter += 1.0;
                            }
                            catch (Exception e2) {
                                String mess2 = "";
                                ONeo4jImporterContext.getInstance().printExceptionMessage(e2, mess4, "error");
                                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e2, "error");
                            }
                        }
                    }
                    if ("NODE_PROPERTY_EXISTENCE".equals(neo4jConstraintType)) {
                        // empty if block
                    }
                    if ("RELATIONSHIP_PROPERTY_EXISTENCE ".equals(neo4jConstraintType)) {
                        // empty if block
                    }
                }
                double value = 100.0 * (this.statistics.neo4jConstraintsCounter / this.statistics.neo4jTotalConstraints);
                if ("UNIQUENESS".equals(neo4jConstraintType)) {
                    // empty if block
                }
                if ("NODE_PROPERTY_EXISTENCE".equals(neo4jConstraintType)) {
                    // empty if block
                }
                if (!"RELATIONSHIP_PROPERTY_EXISTENCE ".equals(neo4jConstraintType)) continue;
            }
        }
        catch (Neo4jException e) {
            mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
        return neo4jPropKey;
    }

    public String getConstraintType(Map<String, Object> neo4jConstraintDefinition) {
        String constraintDescription = neo4jConstraintDefinition.get("description").toString();
        if (constraintDescription.contains("IS UNIQUE")) {
            return "UNIQUENESS";
        }
        return "UNKNOWN";
    }

    private String getConstraintLabel(Map<String, Object> neo4jConstraintDefinition) {
        String constraintDescription = neo4jConstraintDefinition.get("description").toString();
        String label = constraintDescription.substring(constraintDescription.indexOf("(") + 1, constraintDescription.indexOf(")"));
        if ((label = label.replace(" ", "")).contains(":")) {
            label = label.substring(label.indexOf(":") + 1);
        }
        return label;
    }

    private String getRelationshipType(Map<String, Object> neo4jConstraintDefinition) {
        String constraintDescription = neo4jConstraintDefinition.get("description").toString();
        String relationshipType = null;
        if (constraintDescription.contains("exists(")) {
            relationshipType = constraintDescription.substring(constraintDescription.indexOf("exists(") + 1, constraintDescription.lastIndexOf(")"));
            relationshipType = relationshipType.substring(0, relationshipType.indexOf("."));
        }
        return relationshipType;
    }

    private String getConstraintProperty(Map<String, Object> neo4jConstraintDefinition) {
        String constraintDescription = neo4jConstraintDefinition.get("description").toString();
        String propertyName = constraintDescription.substring(constraintDescription.indexOf(") ASSERT ") + 1, constraintDescription.indexOf("IS"));
        propertyName = propertyName.replace("ASSERT", "");
        propertyName = propertyName.replace(" ", "");
        propertyName = propertyName.substring(propertyName.indexOf(".") + 1);
        return propertyName;
    }
}

