/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.neo4jimporter;

import com.orientechnologies.orient.context.ONeo4jImporterContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;

public class ONeo4jImporterUtils {
    public static String checkVertexClassCreation(String neo4jLabel, ODatabaseDocument odb) {
        String logString = "";
        String orientDBClassName = neo4jLabel;
        String sqlQuery = "SELECT @rid FROM V WHERE @class = 'MultipleLabelNeo4jConversion' AND neo4jLabelList CONTAINS '" + neo4jLabel + "' LIMIT 1";
        int u = 0;
        OResultSet vertices = odb.command(sqlQuery, new Object[0]);
        while (vertices.hasNext()) {
            ++u;
            OVertex v = vertices.next().getVertex().orElse(null);
            ONeo4jImporterContext.getInstance().getMessageHandler().debug(ONeo4jImporterUtils.class, "\n\n\nfound it: " + orientDBClassName + " " + v);
            orientDBClassName = "MultipleLabelNeo4jConversion";
        }
        if (u == 0) {
            ONeo4jImporterContext.getInstance().getMessageHandler().debug(ONeo4jImporterUtils.class, "\n\n\ndid not find it: " + orientDBClassName);
            OClass orientDBClass = odb.createVertexClass(orientDBClassName);
            try {
                orientDBClass.createProperty("neo4jLabelList", OType.EMBEDDEDLIST, OType.STRING);
                try {
                    orientDBClass.getProperty("neo4jLabelList").createIndex(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX);
                }
                catch (Exception e) {
                    String mess = "Found an error when trying to create a NOT UNIQUE Index in OrientDB on the 'neo4jLabelList' Property of the vertex Class '" + orientDBClassName + "': " + e.getMessage();
                    ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                    ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                }
            }
            catch (Exception e) {
                String mess = "Found an error when trying to create the 'neo4jLabelList' Property in OrientDB on the vertex Class '" + orientDBClassName + "': " + e.getMessage();
                ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
                ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            }
        }
        return orientDBClassName;
    }

    public static boolean createOrientDBProperty(Session session, String neo4jLabel, String orientDBIndexClass, String neo4jPropKey, ODatabaseDocument oDb, String myNeo4jConstraintType) {
        String mess;
        OType orientOtype = null;
        boolean foundNode = false;
        long debugCounter = 0L;
        String logString = "";
        try {
            String query = "MATCH (n) WHERE n:" + neo4jLabel + " AND exists(n." + neo4jPropKey + ") RETURN n." + neo4jPropKey + " as targetProp";
            StatementResult result = session.run(query);
            while (result.hasNext()) {
                ++debugCounter;
                String neo4jPropType = "";
                try {
                    Record currentNode = result.next();
                    ONeo4jImporterContext.getInstance().getMessageHandler().debug(ONeo4jImporterUtils.class, "debugCounter is: " + debugCounter + ". Working on node " + currentNode.get("id").asString());
                    Value propertyValue = currentNode.get("targetProp");
                    if (propertyValue != null) {
                        neo4jPropType = ONeo4jImporterUtils.getNeo4jPropType(propertyValue);
                        orientOtype = ONeo4jImporterUtils.mapNeo4JToOrientDBPropertyType(neo4jPropType);
                        foundNode = true;
                    }
                    ONeo4jImporterContext.getInstance().getMessageHandler().debug(ONeo4jImporterUtils.class, "Property defined on this node: " + neo4jPropKey + " value: " + propertyValue + " data type: " + neo4jPropType);
                    if (!foundNode) continue;
                }
                catch (Exception e) {
                    String mess2 = "";
                    ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess2, "error");
                    ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
                }
                break;
            }
        }
        catch (Exception e) {
            mess = "";
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
        }
        if (!foundNode) {
            orientOtype = OType.STRING;
        }
        ONeo4jImporterContext.getInstance().getMessageHandler().debug(ONeo4jImporterUtils.class, "Creating OrientDB Property '" + neo4jPropKey + "' of type '" + orientOtype + "' on Class '" + orientDBIndexClass + "' ");
        try {
            OClass orientClass = oDb.getMetadata().getSchema().getClass(orientDBIndexClass);
            if (!orientClass.existsProperty(neo4jPropKey)) {
                orientClass.createProperty(neo4jPropKey, orientOtype);
            }
            if (!foundNode) {
                logString = "The Neo4j Property '" + neo4jPropKey + "' on the Neo4j Label '" + neo4jLabel + "' associated to a Neo4j '" + myNeo4jConstraintType + "' constraint/index has been imported as STRING because there are no nodes in Neo4j that have this property, hence it was not possible to determine the type of this Neo4j Property";
                ONeo4jImporterContext.getInstance().getMessageHandler().info(ONeo4jImporterUtils.class, logString);
            } else {
                logString = "Created Property '" + neo4jPropKey + "' on the Class '" + orientDBIndexClass + "' with type '" + orientOtype + "'";
                ONeo4jImporterContext.getInstance().getMessageHandler().debug(ONeo4jImporterUtils.class, logString);
            }
            return true;
        }
        catch (Exception e) {
            mess = "Found an error when trying to create a Property in OrientDB. Corresponding Property in Neo4j is '" + neo4jPropKey + "' on node label '" + orientDBIndexClass + "': " + e.getMessage();
            ONeo4jImporterContext.getInstance().printExceptionMessage(e, mess, "error");
            ONeo4jImporterContext.getInstance().printExceptionStackTrace(e, "error");
            return false;
        }
    }

    public static OType mapNeo4JToOrientDBPropertyType(String myNeo4jPropType) {
        switch (myNeo4jPropType) {
            case "String": {
                return OType.STRING;
            }
            case "Character": {
                return OType.STRING;
            }
            case "Integer": {
                return OType.INTEGER;
            }
            case "Long": {
                return OType.LONG;
            }
            case "Boolean": {
                return OType.BOOLEAN;
            }
            case "Byte": {
                return OType.BYTE;
            }
            case "Float": {
                return OType.FLOAT;
            }
            case "Double": {
                return OType.DOUBLE;
            }
            case "Short": {
                return OType.SHORT;
            }
        }
        return OType.STRING;
    }

    public static String getNeo4jPropType(Object myPropertyValue) {
        String myNeo4jPropType = null == myPropertyValue || myPropertyValue instanceof StringValue ? "String" : (myPropertyValue instanceof IntegerValue ? "Integer" : (myPropertyValue instanceof BooleanValue ? "Boolean" : (myPropertyValue instanceof BytesValue ? "Byte" : (myPropertyValue instanceof FloatValue ? "Float" : "String"))));
        return myNeo4jPropType;
    }
}

