/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionStateVersionMismatchException;
import com.hazelcast.internal.partition.impl.InternalMigrationListener;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;

abstract class BaseMigrationOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation,
PartitionAwareOperation {
    protected MigrationInfo migrationInfo;
    protected boolean success;
    protected int partitionStateVersion;
    private transient boolean nodeStartCompleted;

    BaseMigrationOperation() {
    }

    BaseMigrationOperation(MigrationInfo migrationInfo, int partitionStateVersion) {
        this.migrationInfo = migrationInfo;
        this.partitionStateVersion = partitionStateVersion;
        this.setPartitionId(migrationInfo.getPartitionId());
    }

    @Override
    public final void beforeRun() throws Exception {
        try {
            this.onMigrationStart();
            this.verifyNodeStarted();
            this.verifyMemberUuid();
            this.verifyClusterState();
            this.verifyPartitionStateVersion();
        }
        catch (Exception e) {
            this.onMigrationComplete(false);
            throw e;
        }
    }

    private void verifyNodeStarted() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        this.nodeStartCompleted = nodeEngine.getNode().getNodeExtension().isStartCompleted();
        if (!this.nodeStartCompleted) {
            throw new IllegalStateException("Migration operation is received before startup is completed. Sender: " + this.getCallerAddress());
        }
    }

    private void verifyPartitionStateVersion() {
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        int localPartitionStateVersion = partitionService.getPartitionStateVersion();
        if (this.partitionStateVersion != localPartitionStateVersion) {
            if (this.getNodeEngine().getThisAddress().equals(this.migrationInfo.getMaster())) {
                return;
            }
            throw new PartitionStateVersionMismatchException(this.partitionStateVersion, localPartitionStateVersion);
        }
    }

    private void verifyMemberUuid() {
        Member localMember = this.getNodeEngine().getLocalMember();
        if (localMember.getAddress().equals(this.migrationInfo.getSource())) {
            if (!localMember.getUuid().equals(this.migrationInfo.getSourceUuid())) {
                throw new IllegalStateException(localMember + " is the migration source but has a different UUID! Migration: " + this.migrationInfo);
            }
        } else if (localMember.getAddress().equals(this.migrationInfo.getDestination()) && !localMember.getUuid().equals(this.migrationInfo.getDestinationUuid())) {
            throw new IllegalStateException(localMember + " is the migration destination but has a different UUID! Migration: " + this.migrationInfo);
        }
    }

    private void verifyClusterState() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        ClusterState clusterState = nodeEngine.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed()) {
            throw new IllegalStateException("Cluster state does not allow migrations! " + (Object)((Object)clusterState));
        }
    }

    void setActiveMigration() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        MigrationManager migrationManager = partitionService.getMigrationManager();
        MigrationInfo currentActiveMigration = migrationManager.setActiveMigration(this.migrationInfo);
        if (currentActiveMigration != null) {
            if (this.migrationInfo.equals(currentActiveMigration)) {
                this.migrationInfo = currentActiveMigration;
                return;
            }
            throw new RetryableHazelcastException("Cannot set active migration to " + this.migrationInfo + ". Current active migration is " + currentActiveMigration);
        }
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        partitionStateManager.setMigratingFlag(this.migrationInfo.getPartitionId());
    }

    void onMigrationStart() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalMigrationListener migrationListener = partitionService.getInternalMigrationListener();
        migrationListener.onMigrationStart(this.getMigrationParticipantType(), this.migrationInfo);
    }

    void onMigrationComplete() {
        this.onMigrationComplete(this.success);
    }

    void onMigrationComplete(boolean result) {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        InternalMigrationListener migrationListener = partitionService.getInternalMigrationListener();
        migrationListener.onMigrationComplete(this.getMigrationParticipantType(), this.migrationInfo, result);
    }

    void executeBeforeMigrations() throws Exception {
        PartitionMigrationEvent event = this.getMigrationEvent();
        Throwable t = null;
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.beforeMigration(event);
            }
            catch (Throwable e) {
                this.getLogger().warning("Error while executing beforeMigration()", e);
                t = e;
            }
        }
        if (t != null) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected abstract PartitionMigrationEvent getMigrationEvent();

    protected abstract InternalMigrationListener.MigrationParticipant getMigrationParticipantType();

    InternalPartition getPartition() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        return partitionService.getPartitionStateManager().getPartitionImpl(this.migrationInfo.getPartitionId());
    }

    public MigrationInfo getMigrationInfo() {
        return this.migrationInfo;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (!this.migrationInfo.isValid()) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public void logError(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof PartitionStateVersionMismatchException) {
            if (logger.isFineEnabled()) {
                logger.fine(e.getMessage(), e);
            }
            return;
        }
        if (!this.nodeStartCompleted && e instanceof IllegalStateException) {
            logger.warning(e.getMessage());
            if (logger.isFineEnabled()) {
                logger.fine(e);
            }
            return;
        }
        super.logError(e);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.migrationInfo.writeData(out);
        out.writeInt(this.partitionStateVersion);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.migrationInfo = new MigrationInfo();
        this.migrationInfo.readData(in);
        this.partitionStateVersion = in.readInt();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", migration=").append(this.migrationInfo);
    }
}

