/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.configuration.api;

import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.configuration.api.OConfiguredProperty;
import com.orientechnologies.teleporter.configuration.api.OConfiguredPropertyMapping;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OConfiguredClass {
    protected String name;
    protected final Map<String, OConfiguredProperty> configuredProperties = new LinkedHashMap<String, OConfiguredProperty>();
    protected OConfiguration globalConfiguration;

    public OConfiguredClass(String elementName, OConfiguration globalConfiguration) {
        this.name = elementName;
        this.globalConfiguration = globalConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<OConfiguredProperty> getConfiguredProperties() {
        return this.configuredProperties.values();
    }

    public void setConfiguredProperties(List<OConfiguredProperty> configuredProperties) {
        for (OConfiguredProperty p : configuredProperties) {
            this.configuredProperties.put(p.getPropertyName(), p);
        }
    }

    public OConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(OConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public OConfiguredProperty getProperty(String propertyName) {
        return this.configuredProperties.get(propertyName);
    }

    public OConfiguredProperty getPropertyByAttribute(String attributeName) {
        for (Map.Entry<String, OConfiguredProperty> entry : this.configuredProperties.entrySet()) {
            OConfiguredPropertyMapping mapping = entry.getValue().getPropertyMapping();
            if (mapping == null || !mapping.getColumnName().equals(attributeName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String[] getPropertiesByColumns(List<String> columns) {
        String[] properties = new String[columns.size()];
        int i = 0;
        int j = 0;
        for (Map.Entry<String, OConfiguredProperty> entry : this.configuredProperties.entrySet()) {
            OConfiguredProperty currConfiguredProperty = entry.getValue();
            if (columns.contains(currConfiguredProperty.getPropertyMapping().getColumnName())) {
                properties[j] = currConfiguredProperty.getPropertyName();
                ++j;
            }
            ++i;
            if (j < columns.size()) continue;
            break;
        }
        return properties;
    }
}

