/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.context;

import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.persistence.handler.ODriverDataTypeHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class OTeleporterContext {
    private static OTeleporterContext instance = null;
    private OrientDB orient;
    private OTeleporterStatistics statistics = new OTeleporterStatistics();
    private OPluginMessageHandler messageHandler;
    private ODriverDataTypeHandler dataTypeHandler;
    private ONameResolver nameResolver;
    private String driverDependencyPath;
    private String executionStrategy;
    private ODBQueryEngine dbQueryEngine;

    public OTeleporterContext(OrientDB orientDBInstance) {
        this.orient = orientDBInstance;
        this.executionStrategy = "not_specified";
    }

    public OTeleporterContext(String url) {
        this.executionStrategy = "not_specified";
        this.initOrientDBInstance(url);
    }

    public static OTeleporterContext getInstance() {
        return instance;
    }

    public static OTeleporterContext newInstance(OrientDB orientDBInstance) {
        instance = new OTeleporterContext(orientDBInstance);
        return instance;
    }

    public static OTeleporterContext newInstance(String url) {
        instance = new OTeleporterContext(url);
        return instance;
    }

    public OrientDB getOrientDBInstance() {
        return this.orient;
    }

    public void initOrientDBInstance(String url) {
        this.orient = new OrientDB(url, OrientDBConfig.defaultConfig());
    }

    public void initOrientDBInstance(String url, OrientDBConfig config) {
        this.orient = new OrientDB(url, config);
    }

    public void closeOrientDBInstance() {
        this.orient.close();
    }

    public void dropOrientDBDatabase(String databaseName) {
        this.orient.drop(databaseName);
    }

    public OTeleporterStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(OTeleporterStatistics statistics) {
        this.statistics = statistics;
    }

    public OPluginMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(OPluginMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public ODriverDataTypeHandler getDataTypeHandler() {
        return this.dataTypeHandler;
    }

    public void setDataTypeHandler(ODriverDataTypeHandler dataTypeHandler) {
        this.dataTypeHandler = dataTypeHandler;
    }

    public ONameResolver getNameResolver() {
        return this.nameResolver;
    }

    public void setNameResolver(ONameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public String getDriverDependencyPath() {
        return this.driverDependencyPath;
    }

    public void setDriverDependencyPath(String driverDependencyPath) {
        this.driverDependencyPath = driverDependencyPath;
    }

    public String getExecutionStrategy() {
        return this.executionStrategy;
    }

    public void setExecutionStrategy(String executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    public ODBQueryEngine getDbQueryEngine() {
        return this.dbQueryEngine;
    }

    public void setDbQueryEngine(ODBQueryEngine dbQueryEngine) {
        this.dbQueryEngine = dbQueryEngine;
    }

    public String printExceptionMessage(Exception e, String message, String level) {
        return OTeleporterContext.printExceptionMessage(this, this.messageHandler, e, message, level);
    }

    public static String printExceptionMessage(Object requester, OPluginMessageHandler messageHandler, Exception e, String message, String level) {
        message = e.getMessage() != null ? message + "\n" + e.getClass().getName() + " - " + e.getMessage() : message + "\n" + e.getClass().getName();
        switch (level) {
            case "debug": {
                messageHandler.debug(requester, message);
                break;
            }
            case "info": {
                messageHandler.info(requester, message);
                break;
            }
            case "warn": {
                messageHandler.warn(requester, message);
                break;
            }
            case "error": {
                messageHandler.error(requester, message);
            }
        }
        return message;
    }

    public String printExceptionStackTrace(Exception e, String level) {
        return OTeleporterContext.printExceptionStackTrace(this, this.messageHandler, e, level);
    }

    public static String printExceptionStackTrace(Object requester, OPluginMessageHandler messageHandler, Exception e, String level) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String s = ((Object)writer).toString();
        switch (level) {
            case "debug": {
                messageHandler.debug(requester, "\n" + s + "\n");
                break;
            }
            case "info": {
                messageHandler.info(requester, "\n" + s + "\n");
                break;
            }
            case "warn": {
                messageHandler.warn(requester, "\n" + s + "\n");
                break;
            }
            case "error": {
                messageHandler.error(requester, "\n" + s + "\n");
            }
        }
        return s;
    }
}

