/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.context;

import com.orientechnologies.orient.output.OOutputStreamManager;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import java.io.PrintStream;

public class OTeleporterMessageHandler
implements OPluginMessageHandler {
    private int level;
    private OOutputStreamManager outputManager;

    public OTeleporterMessageHandler(PrintStream outputStream, int level) {
        this.level = level;
        this.outputManager = new OOutputStreamManager(outputStream, level);
    }

    public OTeleporterMessageHandler(int level) {
        this.level = level;
        this.outputManager = new OOutputStreamManager(level);
    }

    public OTeleporterMessageHandler(OOutputStreamManager outputStreamManager) {
        this.outputManager = outputStreamManager;
        this.level = this.outputManager.getLevel();
    }

    public OOutputStreamManager getOutputManager() {
        return this.outputManager;
    }

    public void setOutputManager(OOutputStreamManager outputManager) {
        this.outputManager = outputManager;
    }

    public int getOutputManagerLevel() {
        return this.level;
    }

    public void setOutputManagerLevel(int level) {
        this.level = level;
        this.updateOutputStreamManagerLevel();
    }

    private synchronized void updateOutputStreamManagerLevel() {
        this.outputManager.setLevel(this.level);
    }

    public synchronized void debug(Object requester, String message) {
        this.outputManager.debug(message);
    }

    public synchronized void debug(Object requester, String format, Object ... args) {
        this.outputManager.debug(format, args);
    }

    public synchronized void info(Object requester, String message) {
        this.outputManager.info(message);
    }

    public synchronized void info(Object requester, String format, Object ... args) {
        this.outputManager.info(format, args);
    }

    public synchronized void warn(Object requester, String message) {
        this.outputManager.warn(message);
    }

    public synchronized void warn(Object requester, String format, Object ... args) {
        this.outputManager.warn(format, args);
    }

    public synchronized void error(Object requester, String message) {
        this.outputManager.error(message);
    }

    public synchronized void error(Object requester, String format, Object ... args) {
        this.outputManager.error(format, args);
    }
}

