/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.factory;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.persistence.handler.ODBMSDataTypeHandler;
import com.orientechnologies.teleporter.persistence.handler.ODriverDataTypeHandler;
import com.orientechnologies.teleporter.persistence.handler.OHSQLDBDataTypeHandler;
import com.orientechnologies.teleporter.persistence.handler.OMySQLDataTypeHandler;
import com.orientechnologies.teleporter.persistence.handler.OOracleDataTypeHandler;
import com.orientechnologies.teleporter.persistence.handler.OPostgreSQLDataTypeHandler;
import com.orientechnologies.teleporter.persistence.handler.OSQLServerDataTypeHandler;

public class ODataTypeHandlerFactory {
    public ODriverDataTypeHandler buildDataTypeHandler(String driver) {
        ODBMSDataTypeHandler handler = null;
        switch (driver) {
            case "oracle.jdbc.driver.OracleDriver": {
                handler = new OOracleDataTypeHandler();
                break;
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                handler = new OSQLServerDataTypeHandler();
                break;
            }
            case "com.mysql.jdbc.Driver": {
                handler = new OMySQLDataTypeHandler();
                break;
            }
            case "org.postgresql.Driver": {
                handler = new OPostgreSQLDataTypeHandler();
                break;
            }
            case "org.hsqldb.jdbc.JDBCDriver": {
                handler = new OHSQLDBDataTypeHandler();
                break;
            }
            default: {
                handler = new ODBMSDataTypeHandler();
                OTeleporterContext.getInstance().getStatistics().warningMessages.add("Driver " + driver + " is not completely supported. Thus problems may occur during type conversion.");
            }
        }
        OTeleporterContext.getInstance().setDataTypeHandler(handler);
        return handler;
    }
}

