/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.factory;

import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.mapper.OSource2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.OHibernate2GraphMapper;
import com.orientechnologies.teleporter.model.OSourceInfo;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import java.util.List;

public class OMapperFactory {
    public OSource2GraphMapper buildMapper(String chosenMapper, OSourceInfo sourceInfo, String xmlPath, List<String> includedTables, List<String> excludedTables, OConfiguration configuration) {
        OER2GraphMapper mapper = null;
        switch (chosenMapper) {
            case "basicDBMapper": {
                mapper = new OER2GraphMapper((OSourceDatabaseInfo)sourceInfo, includedTables, excludedTables, configuration);
                break;
            }
            case "hibernate": {
                mapper = new OHibernate2GraphMapper((OSourceDatabaseInfo)sourceInfo, xmlPath, includedTables, excludedTables, configuration);
                break;
            }
            default: {
                mapper = new OER2GraphMapper((OSourceDatabaseInfo)sourceInfo, includedTables, excludedTables, configuration);
            }
        }
        return mapper;
    }
}

