/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.factory;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.nameresolver.OJavaConventionNameResolver;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.nameresolver.OOriginalConventionNameResolver;

public class ONameResolverFactory {
    public ONameResolver buildNameResolver(String nameResolverConvention) {
        ONameResolver nameResolver = null;
        if (nameResolverConvention == null) {
            nameResolver = new OOriginalConventionNameResolver();
        } else {
            switch (nameResolverConvention) {
                case "java": {
                    nameResolver = new OJavaConventionNameResolver();
                    break;
                }
                case "original": {
                    nameResolver = new OOriginalConventionNameResolver();
                    break;
                }
                default: {
                    nameResolver = new OOriginalConventionNameResolver();
                    OTeleporterContext.getInstance().getStatistics().warningMessages.add("Name resolver convention '" + nameResolverConvention + "' not found, the original name convention will be adopted.");
                }
            }
        }
        OTeleporterContext.getInstance().setNameResolver(nameResolver);
        return nameResolver;
    }
}

