/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.http;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import com.orientechnologies.teleporter.http.handler.OTeleporterHandler;
import com.orientechnologies.teleporter.util.ODriverConfigurator;
import java.io.IOException;

public class OServerCommandTeleporter
extends OServerCommandAuthenticatedServerAbstract {
    OTeleporterHandler handler = new OTeleporterHandler();
    private static final String[] NAMES = new String[]{"GET|teleporter/*", "POST|teleporter/*"};

    public OServerCommandTeleporter() {
        super("server.profiler");
    }

    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] parts = this.checkSyntax(iRequest.getUrl(), 2, "Syntax error: auditing/<db>/<action>");
        if ("POST".equalsIgnoreCase(iRequest.httpMethod)) {
            this.doPost(iRequest, iResponse, parts);
        }
        if ("GET".equalsIgnoreCase(iRequest.httpMethod)) {
            this.doGet(iRequest, iResponse, parts);
        }
        return false;
    }

    private void doGet(OHttpRequest iRequest, OHttpResponse iResponse, String[] parts) throws IOException {
        if ("status".equalsIgnoreCase(parts[1])) {
            ODocument status = this.handler.status();
            iResponse.send(200, "OK", "application/json", (Object)status.toJSON("prettyPrint"), null);
        } else if ("drivers".equalsIgnoreCase(parts[1])) {
            ODriverConfigurator configurator = new ODriverConfigurator();
            ODocument drivers = configurator.readJsonFromRemoteUrl("https://raw.githubusercontent.com/orientechnologies/teleporter/develop/jdbc-drivers.json");
            iResponse.send(200, "OK", "application/json", (Object)drivers.toJSON("prettyPrint"), null);
        } else {
            throw new IllegalArgumentException("");
        }
    }

    private void doPost(OHttpRequest iRequest, OHttpResponse iResponse, String[] parts) throws IOException {
        if ("job".equalsIgnoreCase(parts[1])) {
            ODocument executionResult;
            ODocument args = new ODocument().fromJSON(iRequest.content);
            try {
                executionResult = this.handler.execute(args, this.server);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            if (executionResult != null) {
                String jsonGraphModel = executionResult.toJSON("prettyPrint");
                iResponse.send(200, "OK", "application/json", (Object)jsonGraphModel, null);
            } else {
                iResponse.send(200, "OK", "application/json", null, null);
            }
        } else if ("test".equalsIgnoreCase(parts[1])) {
            ODocument args = new ODocument().fromJSON(iRequest.content);
            try {
                this.handler.checkConnection(args, this.server);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            iResponse.send(200, "OK", "application/json", null, null);
        } else if ("tables".equalsIgnoreCase(parts[1])) {
            ODocument tables;
            ODocument params = new ODocument().fromJSON(iRequest.content);
            try {
                tables = this.handler.getTables(params, this.server);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            iResponse.send(200, "OK", "application/json", (Object)tables.toJSON("prettyPrint"), null);
        } else if ("save-config".equalsIgnoreCase(parts[1])) {
            ODocument args = new ODocument().fromJSON(iRequest.content);
            try {
                this.handler.saveConfiguration(args, this.server);
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            iResponse.send(200, "OK", "application/json", null, null);
        } else {
            throw new IllegalArgumentException("");
        }
    }

    public String[] getNames() {
        return NAMES;
    }
}

