/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.http.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.teleporter.context.OTeleporterMessageHandler;
import com.orientechnologies.teleporter.exception.OTeleporterIOException;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.http.handler.OTeleporterListener;
import com.orientechnologies.teleporter.main.OTeleporter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

public class OTeleporterJob
implements Callable<ODocument> {
    private final ODocument cfg;
    private OTeleporterListener listener;
    private String id;
    private Status status;
    private PrintStream stream;
    private ByteArrayOutputStream baos;
    private OPluginMessageHandler messageHandler;
    private OServer currentServerInstance;

    public OTeleporterJob(ODocument cfg, OServer currentServerInstance, OTeleporterListener listener) {
        this.cfg = cfg;
        this.listener = listener;
        this.baos = new ByteArrayOutputStream();
        this.stream = new PrintStream(this.baos);
        this.currentServerInstance = currentServerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument call() {
        ODocument executionResult;
        block8: {
            this.id = UUID.randomUUID().toString();
            String serverDatabaseDirectory = this.currentServerInstance.getDatabaseDirectory();
            final String driver = (String)this.cfg.field("driver");
            final String jurl = (String)this.cfg.field("jurl");
            final String username = (String)this.cfg.field("username");
            final String password = (String)this.cfg.field("password");
            String protocol = (String)this.cfg.field("protocol");
            String outDbName = (String)this.cfg.field("outDBName");
            final String chosenStrategy = (String)this.cfg.field("strategy");
            final String chosenMapper = (String)this.cfg.field("mapper");
            final String xmlPath = (String)this.cfg.field("xmlPath");
            final String nameResolver = (String)this.cfg.field("nameResolver");
            final String outputLevel = (String)this.cfg.field("level");
            final List includedTables = (List)this.cfg.field("includedTables");
            final List<String> excludedTable = null;
            final String migrationConfig = (String)this.cfg.field("migrationConfig");
            this.status = Status.RUNNING;
            final OrientDB orientDBInstance = this.currentServerInstance.getContext();
            int msgHandlerLevel = Integer.parseInt(outputLevel);
            this.messageHandler = new OTeleporterMessageHandler(this.stream, msgHandlerLevel);
            final String outDbUrl = protocol.equals("plocal") ? protocol + ":" + serverDatabaseDirectory + outDbName : protocol + ":" + outDbName;
            executionResult = null;
            try {
                if (chosenStrategy.equals("interactive") || chosenStrategy.equals("interactive-aggr")) {
                    executionResult = OTeleporter.executeJob(driver, jurl, username, password, outDbUrl, chosenStrategy, chosenMapper, xmlPath, nameResolver, outputLevel, includedTables, excludedTable, migrationConfig, this.messageHandler, orientDBInstance);
                    OTeleporterListener oTeleporterListener = this.listener;
                    synchronized (oTeleporterListener) {
                        this.status = Status.FINISHED;
                        try {
                            this.listener.wait(5000L);
                            this.listener.onEnd(this);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        break block8;
                    }
                }
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            OTeleporter.executeJob(driver, jurl, username, password, outDbUrl, chosenStrategy, chosenMapper, xmlPath, nameResolver, outputLevel, includedTables, excludedTable, migrationConfig, new OTeleporterMessageHandler(OTeleporterJob.this.stream, 2), orientDBInstance);
                        }
                        catch (OTeleporterIOException e) {
                            e.printStackTrace();
                        }
                        OTeleporterListener oTeleporterListener = OTeleporterJob.this.listener;
                        synchronized (oTeleporterListener) {
                            OTeleporterJob.this.status = Status.FINISHED;
                            try {
                                OTeleporterJob.this.listener.wait(5000L);
                                OTeleporterJob.this.listener.onEnd(OTeleporterJob.this);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }).start();
                executionResult = new ODocument();
            }
            catch (Exception e) {
                throw new OTeleporterRuntimeException(e.getMessage());
            }
        }
        return executionResult;
    }

    public void validate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument status() {
        OTeleporterListener oTeleporterListener = this.listener;
        synchronized (oTeleporterListener) {
            ODocument status = new ODocument();
            status.field("cfg", (Object)this.cfg);
            status.field("status", (Object)this.status);
            String lastBatchLog = this.extractBatchLog();
            status.field("log", (Object)lastBatchLog);
            if (this.status == Status.FINISHED) {
                this.listener.notifyAll();
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractBatchLog() {
        String lastBatchLog = "Current status not correctly loaded.";
        OPluginMessageHandler oPluginMessageHandler = this.messageHandler;
        synchronized (oPluginMessageHandler) {
            int baosInitSize = this.baos.size();
            try {
                lastBatchLog = this.baos.toString("UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int baosFinalSize = this.baos.size();
            if (baosFinalSize - baosInitSize > 0) {
                OLogManager.instance().info((Object)this, "[Teleporter] Losing some buffer info.", new Object[0]);
            } else {
                this.baos.reset();
            }
        }
        return lastBatchLog;
    }

    public static enum Status {
        STARTED,
        RUNNING,
        FINISHED;

    }
}

