/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.importengine.rdbms.graphengine;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.mapper.rdbms.OAggregatorEdge;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OLogicalRelationship;
import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import com.orientechnologies.teleporter.persistence.handler.ODBMSDataTypeHandler;
import com.orientechnologies.teleporter.util.OFunctionsHandler;
import com.orientechnologies.teleporter.util.OGraphCommands;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OGraphEngineForDB {
    private OER2GraphMapper mapper;
    private ODBMSDataTypeHandler handler;

    public OGraphEngineForDB(OER2GraphMapper mapper, ODBMSDataTypeHandler handler) {
        this.mapper = mapper;
        this.handler = handler;
    }

    public boolean alreadyFullImportedInOrient(ODatabaseDocument orientGraph, ResultSet record, OVertexType vertexType, Set<String> propertiesOfIndex) throws SQLException {
        String propsAndValuesOfKey = "";
        try {
            boolean toResolveNames = false;
            if (propertiesOfIndex == null) {
                toResolveNames = true;
                propertiesOfIndex = new LinkedHashSet<String>();
                for (OModelProperty currentProperty : vertexType.getAllProperties()) {
                    if (!currentProperty.isFromPrimaryKey()) continue;
                    propertiesOfIndex.add(currentProperty.getName());
                }
            }
            String[] propertyOfKey = new String[propertiesOfIndex.size()];
            String[] valueOfKey = new String[propertiesOfIndex.size()];
            int cont = 0;
            Iterator<String> iterator = propertiesOfIndex.iterator();
            while (iterator.hasNext()) {
                String property;
                propertyOfKey[cont] = property = iterator.next();
                valueOfKey[cont] = toResolveNames ? record.getString(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, property)) : record.getString(property);
                ++cont;
            }
            String s = "Keys and values in the lookup (upsertVisitedVertex):\t";
            for (int i = 0; i < propertyOfKey.length; ++i) {
                propsAndValuesOfKey = propsAndValuesOfKey + propertyOfKey[i] + ":" + valueOfKey[i] + ",";
            }
            propsAndValuesOfKey = propsAndValuesOfKey.length() > 0 ? propsAndValuesOfKey.substring(0, propsAndValuesOfKey.length() - 1) : "no identifier for the current record.";
            s = s + propsAndValuesOfKey;
            OVertex vertex = OGraphCommands.getVertexByIndexedKey(orientGraph, propertyOfKey, valueOfKey, vertexType.getName());
            if (vertex != null && vertexType.getAllProperties().size() <= vertex.getPropertyNames().size()) {
                return true;
            }
        }
        catch (Exception e) {
            String mess = "Problem encountered during the visit of an inserted vertex. Vertex Type: " + vertexType.getName() + ";\tOriginal Record: " + propsAndValuesOfKey;
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return false;
    }

    public OVertex upsertVisitedVertex(ODatabaseDocument orientGraph, ResultSet record, OVertexType vertexType, Set<String> propertiesOfIndex) {
        OVertex vertex;
        block36: {
            vertex = null;
            String[] propertyOfKey = null;
            String[] valueOfKey = null;
            String propsAndValuesOfKey = "";
            try {
                String currentPropertyType;
                OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
                propertyOfKey = new String[propertiesOfIndex.size()];
                valueOfKey = new String[propertiesOfIndex.size()];
                int cont = 0;
                Iterator<String> iterator = propertiesOfIndex.iterator();
                while (iterator.hasNext()) {
                    String property;
                    propertyOfKey[cont] = property = iterator.next();
                    String attributeName = this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, property);
                    String currentValue = record.getString(attributeName);
                    OModelProperty prop = vertexType.getPropertyByNameAmongAll(property);
                    if (prop.getOriginalType().equalsIgnoreCase("boolean")) {
                        switch (currentValue) {
                            case "t": {
                                currentValue = "true";
                                break;
                            }
                            case "f": {
                                currentValue = "false";
                                break;
                            }
                        }
                    }
                    valueOfKey[cont] = currentValue;
                    ++cont;
                }
                String s = "Keys and values in the lookup (upsertVisitedVertex):\t";
                for (int i = 0; i < propertyOfKey.length; ++i) {
                    propsAndValuesOfKey = propsAndValuesOfKey + propertyOfKey[i] + ":" + valueOfKey[i] + ",";
                }
                propsAndValuesOfKey = propsAndValuesOfKey.length() > 0 ? propsAndValuesOfKey.substring(0, propsAndValuesOfKey.length() - 1) : "no identifier for the current record.";
                s = s + propsAndValuesOfKey;
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n" + s + "\n");
                }
                if (propertyOfKey.length > 0 && valueOfKey.length > 0) {
                    vertex = OGraphCommands.getVertexByIndexedKey(orientGraph, propertyOfKey, valueOfKey, vertexType.getName());
                }
                LinkedHashMap<String, Object> currentProperties = new LinkedHashMap<String, Object>();
                String currentPropertyName = null;
                for (OModelProperty currentProperty : vertexType.getAllProperties()) {
                    if (!currentProperty.isIncludedInMigration()) continue;
                    currentPropertyName = currentProperty.getName();
                    currentPropertyType = OTeleporterContext.getInstance().getDataTypeHandler().resolveType(currentProperty.getOriginalType().toLowerCase(Locale.ENGLISH)).toString();
                    String currentOriginalType = currentProperty.getOriginalType();
                    try {
                        this.extractPropertiesFromRecordIntoVertex(record, currentProperties, currentPropertyType, currentPropertyName, currentOriginalType, vertexType);
                    }
                    catch (Exception e) {
                        String mess = "Problem encountered during the extraction of the values from the records. Vertex Type: " + vertexType.getName() + ";\tProperty: " + currentPropertyName + ";\tRecord: " + propsAndValuesOfKey;
                        OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                        OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
                    }
                }
                if (vertex == null) {
                    String classAndClusterName = vertexType.getName();
                    vertex = this.addVertexToGraph(orientGraph, classAndClusterName, currentProperties);
                    ++statistics.orientAddedVertices;
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nLoaded properties: %s\n", new Object[]{((Object)currentProperties).toString()});
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew vertex inserted (all props set): %s\n", new Object[]{vertex.toString()});
                    }
                    break block36;
                }
                boolean justReachedVertex = true;
                if (vertex.getPropertyNames().size() >= vertexType.getAllProperties().size()) {
                    justReachedVertex = false;
                }
                if (justReachedVertex) {
                    for (String property : vertex.getPropertyNames()) {
                        if (property.startsWith("in_") || property.startsWith("out_") || this.containsProperty(propertiesOfIndex, property)) continue;
                        justReachedVertex = false;
                        break;
                    }
                }
                if (justReachedVertex) {
                    this.setElementProperties((OElement)vertex, currentProperties);
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nLoaded properties: %s\n", new Object[]{((Object)currentProperties).toString()});
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew vertex inserted (all props set): %s\n", new Object[]{vertex.toString()});
                    }
                    break block36;
                }
                boolean equalVersions = true;
                boolean equalProperties = true;
                Set propertyNames = vertex.getPropertyNames();
                Iterator it = propertyNames.iterator();
                while (it.hasNext()) {
                    String property = (String)it.next();
                    if (!property.startsWith("out_") && !property.startsWith("in_")) continue;
                    it.remove();
                }
                if (propertyNames.size() == currentProperties.size()) {
                    for (String propertyName : propertyNames) {
                        if (currentProperties.keySet().contains(propertyName)) continue;
                        equalProperties = false;
                        equalVersions = false;
                        break;
                    }
                    if (equalProperties) {
                        for (String propertyName : propertyNames) {
                            if (vertex.getProperty(propertyName) == null && currentProperties.get(propertyName) == null) continue;
                            currentPropertyType = vertexType.getPropertyByName(propertyName).getOrientdbType();
                            if (currentPropertyType == null) {
                                currentPropertyType = OTeleporterContext.getInstance().getDataTypeHandler().resolveType(vertexType.getPropertyByName(propertyName).getOriginalType().toLowerCase(Locale.ENGLISH)).toString();
                            }
                            if (this.areEquals(vertex.getProperty(propertyName), currentProperties.get(propertyName), currentPropertyType)) continue;
                            equalVersions = false;
                            break;
                        }
                    } else {
                        equalVersions = false;
                    }
                } else {
                    equalVersions = false;
                }
                if (!equalVersions) {
                    for (String propertyKey : vertex.getPropertyNames()) {
                        if (propertyKey.startsWith("out_") || propertyKey.startsWith("in_")) continue;
                        vertex.removeProperty(propertyKey);
                    }
                    this.setElementProperties((OElement)vertex, currentProperties);
                    ++statistics.orientUpdatedVertices;
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nLoaded properties: %s\n", new Object[]{((Object)currentProperties).toString()});
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew vertex upserted (all props set): %s\n", new Object[]{vertex.toString()});
                    }
                }
            }
            catch (Exception e) {
                String mess = "Problem encountered during the migration of the records. Vertex Type: " + vertexType.getName() + ";\tRecord: " + propsAndValuesOfKey;
                OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new OTeleporterRuntimeException(e);
            }
        }
        return vertex;
    }

    public void extractPropertiesFromRecordIntoVertex(ResultSet record, Map<String, Object> properties, String currentPropertyType, String currentPropertyName, String currentOriginalType, OVertexType vertexType) throws SQLException {
        if (currentPropertyType.equals("DATE")) {
            Date currentDateValue = record.getDate(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentDateValue);
        } else if (currentPropertyType.equals("DATETIME")) {
            Timestamp currentDateValue = record.getTimestamp(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentDateValue);
        } else if (currentPropertyType.equals("BINARY")) {
            byte[] currentBinaryValue = record.getBytes(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentBinaryValue);
        } else if (currentPropertyType.equals("BOOLEAN")) {
            String currentAttributeValue;
            switch (currentAttributeValue = record.getString(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName))) {
                case "t": {
                    properties.put(currentPropertyName, "true");
                    break;
                }
                case "f": {
                    properties.put(currentPropertyName, "false");
                    break;
                }
            }
        } else if (this.handler.jsonImplemented && currentPropertyType.equals("EMBEDDED")) {
            String currentAttributeValue = record.getString(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            ODocument currentEmbeddedValue = this.handler.convertJSONToDocument(currentPropertyName, currentAttributeValue);
            properties.put(currentPropertyName, currentEmbeddedValue);
        } else if (currentPropertyType.equals("DECIMAL")) {
            BigDecimal currentDecimalValue = record.getBigDecimal(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentDecimalValue);
        } else if (currentPropertyType.equals("DOUBLE")) {
            Double currentDoubleValue = record.getDouble(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentDoubleValue);
        } else if (currentPropertyType.equals("FLOAT")) {
            Float currentFloatValue = Float.valueOf(record.getFloat(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName)));
            properties.put(currentPropertyName, currentFloatValue);
        } else if (currentPropertyType.equals("INTEGER")) {
            Integer currentIntegerValue = record.getInt(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentIntegerValue);
        } else if (currentPropertyType.equals("LONG")) {
            Long currentLongValue = record.getLong(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentLongValue);
        } else if (currentPropertyType.equals("SHORT")) {
            Short currentShortValue = record.getShort(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentShortValue);
        } else if (this.handler.geospatialImplemented && this.handler.isGeospatial(currentOriginalType)) {
            String currentAttributeValue = record.getString(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            Object currentEmbeddedValue = null;
            properties.put(currentPropertyName, currentEmbeddedValue);
        } else {
            String currentAttributeValue = record.getString(this.mapper.getAttributeNameByVertexTypeAndProperty(vertexType, currentPropertyName));
            properties.put(currentPropertyName, currentAttributeValue);
        }
    }

    public void extractPropertiesFromRecordIntoEdge(ResultSet record, Map<String, Object> properties, String currentPropertyType, String currentPropertyName, String currentOriginalType, OEdgeType edgeType) throws SQLException {
        if (currentPropertyType.equals("DATE")) {
            Date currentDateValue = record.getDate(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentDateValue);
        } else if (currentPropertyType.equals("DATETIME")) {
            Timestamp currentDateValue = record.getTimestamp(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentDateValue);
        } else if (currentPropertyType.equals("BINARY")) {
            byte[] currentBinaryValue = record.getBytes(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentBinaryValue);
        } else if (currentPropertyType.equals("BOOLEAN")) {
            String currentAttributeValue;
            switch (currentAttributeValue = record.getString(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName))) {
                case "t": {
                    properties.put(currentPropertyName, "true");
                    break;
                }
                case "f": {
                    properties.put(currentPropertyName, "false");
                    break;
                }
            }
            properties.put(currentPropertyName, currentAttributeValue);
        } else if (this.handler.jsonImplemented && currentPropertyType.equals("EMBEDDED")) {
            String currentAttributeValue = record.getString(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            ODocument currentEmbeddedValue = this.handler.convertJSONToDocument(currentPropertyName, currentAttributeValue);
            properties.put(currentPropertyName, currentEmbeddedValue);
        } else if (currentPropertyType.equals("DECIMAL")) {
            BigDecimal currentDecimalValue = record.getBigDecimal(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentDecimalValue);
        } else if (currentPropertyType.equals("DOUBLE")) {
            Double currentDoubleValue = record.getDouble(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentDoubleValue);
        } else if (currentPropertyType.equals("FLOAT")) {
            Float currentFloatValue = Float.valueOf(record.getFloat(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName)));
            properties.put(currentPropertyName, currentFloatValue);
        } else if (currentPropertyType.equals("INTEGER")) {
            Integer currentIntegerValue = record.getInt(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentIntegerValue);
        } else if (currentPropertyType.equals("LONG")) {
            Long currentLongValue = record.getLong(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentLongValue);
        } else if (currentPropertyType.equals("SHORT")) {
            Short currentShortValue = record.getShort(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentShortValue);
        } else if (this.handler.geospatialImplemented && this.handler.isGeospatial(currentOriginalType)) {
            String currentAttributeValue = record.getString(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            Object currentEmbeddedValue = null;
            properties.put(currentPropertyName, currentEmbeddedValue);
        } else {
            String currentAttributeValue = record.getString(this.mapper.getAttributeNameByEdgeTypeAndProperty(edgeType, currentPropertyName));
            properties.put(currentPropertyName, currentAttributeValue);
        }
    }

    private boolean containsProperty(Set<String> propertiesOfIndex, String property) {
        for (String currentProp : propertiesOfIndex) {
            if (!currentProp.equalsIgnoreCase(property)) continue;
            return true;
        }
        return false;
    }

    private boolean areEquals(Object oldProperty, Object newProperty, String currentPropertyType) {
        if (oldProperty != null && newProperty != null) {
            if (currentPropertyType.equals("BINARY")) {
                byte[] oldPropertyBinary = (byte[])oldProperty;
                byte[] newPropertyBinary = (byte[])newProperty;
                return Arrays.equals(oldPropertyBinary, newPropertyBinary);
            }
            if (currentPropertyType.equals("BOOLEAN")) {
                if (oldProperty.toString().equalsIgnoreCase(newProperty.toString())) {
                    return true;
                }
                return oldProperty.toString().equalsIgnoreCase("t") && newProperty.toString().equalsIgnoreCase("true") || oldProperty.toString().equalsIgnoreCase("f") && newProperty.toString().equalsIgnoreCase("false");
            }
            if (currentPropertyType.equals("DATE")) {
                Calendar oldDate = Calendar.getInstance();
                oldDate.setTime((java.util.Date)oldProperty);
                Calendar newDate = Calendar.getInstance();
                newDate.setTime((java.util.Date)newProperty);
                return oldDate.get(0) == newDate.get(0) && oldDate.get(1) == newDate.get(1) && oldDate.get(2) == newDate.get(2) && oldDate.get(5) == newDate.get(5);
            }
            if (currentPropertyType.equals("DATETIME")) {
                return ((java.util.Date)oldProperty).equals((java.util.Date)newProperty);
            }
            if (currentPropertyType.equals("DECIMAL")) {
                return oldProperty.equals(new BigDecimal(newProperty.toString()));
            }
            if (currentPropertyType.equals("DOUBLE")) {
                return oldProperty.equals(new Double(newProperty.toString()));
            }
            if (currentPropertyType.equals("FLOAT")) {
                return oldProperty.equals(new Float(newProperty.toString()));
            }
            if (currentPropertyType.equals("INTEGER")) {
                return oldProperty.equals(new Integer(newProperty.toString()));
            }
            if (currentPropertyType.equals("LONG")) {
                return oldProperty.equals(new Long(newProperty.toString()));
            }
            if (currentPropertyType.equals("SHORT")) {
                return oldProperty.equals(new Short(newProperty.toString()));
            }
            if (this.handler.jsonImplemented && currentPropertyType.equals("EMBEDDED")) {
                boolean areEquals = OFunctionsHandler.haveDocumentsSameContent((ODocument)oldProperty, (ODocument)newProperty);
                return areEquals;
            }
            return oldProperty.toString().equals(newProperty.toString());
        }
        return oldProperty == null && newProperty == null;
    }

    public OVertex upsertReachedVertexWithEdge(ODatabaseDocument orientGraph, ResultSet foreignRecord, OCanonicalRelationship relation, OVertex currentOutVertex, OVertexType currentInVertexType, String edgeTypeName) throws SQLException {
        OVertex currentInVertex = null;
        String propsAndValuesOfKey = "";
        String direction = relation.getDirection();
        try {
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            List<OAttribute> fromColumns = relation.getFromColumns();
            Object[] propertyOfKey = new String[fromColumns.size()];
            Object[] valueOfKey = new String[fromColumns.size()];
            int index = 0;
            for (OAttribute foreignAttribute : fromColumns) {
                String attributeName = relation.getToColumns().get(index).getName();
                propertyOfKey[index] = this.mapper.getPropertyNameByVertexTypeAndAttribute(currentInVertexType, attributeName);
                valueOfKey[index] = foreignRecord.getString(foreignAttribute.getName());
                ++index;
            }
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                String s = "Keys and values in the lookup (upsertVisitedVertex):\t";
                for (int i = 0; i < propertyOfKey.length; ++i) {
                    propsAndValuesOfKey = propsAndValuesOfKey + propertyOfKey[i] + ":" + valueOfKey[i] + ",";
                }
                propsAndValuesOfKey = propsAndValuesOfKey.length() > 0 ? propsAndValuesOfKey.substring(0, propsAndValuesOfKey.length() - 1) : "no identifier for the current record.";
                s = s + propsAndValuesOfKey;
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n" + s + "\n");
            }
            boolean ok = true;
            for (int i = 0; i < valueOfKey.length; ++i) {
                if (valueOfKey[i] != null) continue;
                ok = false;
                break;
            }
            if (ok) {
                currentInVertex = OGraphCommands.getVertexByIndexedKey(orientGraph, (String[])propertyOfKey, (String[])valueOfKey, currentInVertexType.getName());
                if (currentInVertex == null) {
                    LinkedHashMap<String, Object> partialProperties = new LinkedHashMap<String, Object>();
                    for (int i = 0; i < propertyOfKey.length; ++i) {
                        partialProperties.put(propertyOfKey[i], valueOfKey[i]);
                    }
                    String classAndClusterName = currentInVertexType.getName();
                    currentInVertex = this.addVertexToGraph(orientGraph, classAndClusterName, partialProperties);
                    ++statistics.orientAddedVertices;
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNEW Reached vertex (id:value) --> %s:%s\n", new Object[]{Arrays.toString(propertyOfKey), Arrays.toString(valueOfKey)});
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew vertex inserted (only pk props set): %s\n", new Object[]{currentInVertex.toString()});
                    }
                } else if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNOT NEW Reached vertex, vertex %s:%s already present in the Orient Graph.\n", new Object[]{Arrays.toString(propertyOfKey), Arrays.toString(valueOfKey)});
                }
                this.upsertEdge(orientGraph, currentOutVertex, currentInVertex, edgeTypeName, null, direction);
            }
        }
        catch (Exception e) {
            String mess = "Problem encountered during the upsert of a reached vertex. Vertex Type: " + currentInVertexType.getName() + ";\tOriginal Record: " + propsAndValuesOfKey;
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return currentInVertex;
    }

    public void connectVertexToRelatedVertices(ODatabaseDocument orientGraph, OLogicalRelationship relation, OVertex currentOutVertex, OVertexType currentOutVertexType, OVertexType currentInVertexType, String edgeTypeName) {
        String propsAndValuesOfKey = "";
        String direction = relation.getDirection();
        try {
            List<OAttribute> fromColumns = relation.getFromColumns();
            String[] propertyOfKey = new String[fromColumns.size()];
            String[] valueOfKey = new String[fromColumns.size()];
            int index = 0;
            for (OAttribute foreignAttribute : fromColumns) {
                String attributeName = relation.getToColumns().get(index).getName();
                propertyOfKey[index] = this.mapper.getPropertyNameByVertexTypeAndAttribute(currentInVertexType, attributeName);
                String outVertexPropertyName = this.mapper.getPropertyNameByVertexTypeAndAttribute(currentOutVertexType, foreignAttribute.getName());
                valueOfKey[index] = (String)currentOutVertex.getProperty(outVertexPropertyName);
                ++index;
            }
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                String s = "Keys and values in the lookup (upsertVisitedVertex):\t";
                for (int i = 0; i < propertyOfKey.length; ++i) {
                    propsAndValuesOfKey = propsAndValuesOfKey + propertyOfKey[i] + ":" + valueOfKey[i] + ",";
                }
                propsAndValuesOfKey = propsAndValuesOfKey.length() > 0 ? propsAndValuesOfKey.substring(0, propsAndValuesOfKey.length() - 1) : "no identifier for the current record.";
                s = s + propsAndValuesOfKey;
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n" + s + "\n");
            }
            boolean ok = true;
            for (int i = 0; i < valueOfKey.length; ++i) {
                if (valueOfKey[i] != null) continue;
                ok = false;
                break;
            }
            if (ok) {
                int verticesCount;
                OTeleporterContext.getInstance().getStatistics().leftVerticesCurrentLogicalRelationship = verticesCount = (int)orientGraph.countClass(currentInVertexType.getName());
                OResultSet inVertices = OGraphCommands.getVertices(orientGraph, currentInVertexType.getName(), propertyOfKey, valueOfKey);
                while (inVertices.hasNext()) {
                    OVertex currentInVertex = (OVertex)inVertices.next().getVertex().get();
                    this.insertEdge(orientGraph, currentOutVertex, currentInVertex, edgeTypeName, null, direction);
                }
                inVertices.close();
            }
        }
        catch (Exception e) {
            String mess = "Problem encountered during the insert of the edge between two vertices. outVertexType: " + currentOutVertexType.getName() + ", inVertexType: " + currentInVertexType.getName();
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    public void upsertEdge(ODatabaseDocument orientGraph, OVertex currentOutVertex, OVertex currentInVertex, String edgeType, Map<String, Object> properties, String direction) {
        try {
            boolean edgeAlreadyPresent = false;
            Iterator it = currentOutVertex.getEdges(ODirection.OUT, new String[]{edgeType}).iterator();
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    OEdge currentEdge = (OEdge)it.next();
                    if (!currentEdge.getVertex(ODirection.IN).getIdentity().equals(currentInVertex.getIdentity())) continue;
                    edgeAlreadyPresent = true;
                    break;
                }
                if (edgeAlreadyPresent) {
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge between '%s' and '%s' already present.\n", new Object[]{currentOutVertex.toString(), currentInVertex.toString()});
                    }
                } else {
                    OEdge edge = null;
                    if (direction != null && direction.equals("direct")) {
                        edge = this.addEdgeToGraph(orientGraph, currentOutVertex, currentInVertex, edgeType, properties);
                    } else if (direction != null && direction.equals("inverse")) {
                        edge = this.addEdgeToGraph(orientGraph, currentInVertex, currentOutVertex, edgeType, properties);
                    }
                    ++statistics.orientAddedEdges;
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew edge inserted: %s\n", new Object[]{edge.toString()});
                    }
                }
            } else {
                OEdge edge = null;
                if (direction != null && direction.equals("direct")) {
                    edge = this.addEdgeToGraph(orientGraph, currentOutVertex, currentInVertex, edgeType, properties);
                } else if (direction != null && direction.equals("inverse")) {
                    edge = this.addEdgeToGraph(orientGraph, currentInVertex, currentOutVertex, edgeType, properties);
                }
                ++statistics.orientAddedEdges;
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew edge inserted: %s\n", new Object[]{edge.toString()});
                }
            }
        }
        catch (Exception e) {
            String mess = "Problem encountered during the upsert of an edge. Vertex-out: " + currentOutVertex + ";\tVertex-in: " + currentInVertex;
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    public void insertEdge(ODatabaseDocument orientGraph, OVertex currentOutVertex, OVertex currentInVertex, String edgeType, Map<String, Object> properties, String direction) {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        try {
            OEdge edge = null;
            if (direction != null && direction.equals("direct")) {
                edge = this.addEdgeToGraph(orientGraph, currentOutVertex, currentInVertex, edgeType, properties);
            } else if (direction != null && direction.equals("inverse")) {
                edge = this.addEdgeToGraph(orientGraph, currentInVertex, currentOutVertex, edgeType, properties);
            }
            ++statistics.orientAddedEdges;
            ++statistics.doneLeftVerticesCurrentLogicalRelationship;
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nNew edge inserted: %s\n", new Object[]{edge.toString()});
            }
        }
        catch (Exception e) {
            String mess = "Problem encountered during the insert of an edge. Vertex-out: " + currentOutVertex + ";\tVertex-in: " + currentInVertex;
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    public void upsertAggregatorEdge(ODatabaseDocument orientGraph, ResultSet jointTableRecord, OEntity joinTable, OAggregatorEdge aggregatorEdge) throws SQLException {
        try {
            OVertex currentInVertex;
            OVertex currentOutVertex;
            Iterator<OCanonicalRelationship> it = joinTable.getOutCanonicalRelationships().iterator();
            OCanonicalRelationship relationship1 = it.next();
            OCanonicalRelationship relationship2 = it.next();
            String[] keysOutVertex = new String[relationship1.getFromColumns().size()];
            String[] valuesOutVertex = new String[relationship1.getFromColumns().size()];
            int index = 0;
            for (OAttribute foreignKeyAttribute : relationship1.getFromColumns()) {
                keysOutVertex[index] = this.mapper.getPropertyNameByEntityAndAttribute(relationship1.getParentEntity(), relationship1.getToColumns().get(index).getName());
                valuesOutVertex[index] = jointTableRecord.getString(foreignKeyAttribute.getName());
                ++index;
            }
            String[] keysInVertex = new String[relationship2.getToColumns().size()];
            String[] valuesInVertex = new String[relationship2.getToColumns().size()];
            index = 0;
            for (OAttribute foreignKeyAttribute : relationship2.getFromColumns()) {
                keysInVertex[index] = this.mapper.getPropertyNameByEntityAndAttribute(relationship2.getParentEntity(), relationship2.getToColumns().get(index).getName());
                valuesInVertex[index] = jointTableRecord.getString(foreignKeyAttribute.getName());
                ++index;
            }
            String direction = joinTable.getDirectionOfN2NRepresentedRelationship();
            if (direction.equals("direct")) {
                currentOutVertex = OGraphCommands.getVertexByIndexedKey(orientGraph, keysOutVertex, valuesOutVertex, aggregatorEdge.getOutVertexClassName());
                currentInVertex = OGraphCommands.getVertexByIndexedKey(orientGraph, keysInVertex, valuesInVertex, aggregatorEdge.getInVertexClassName());
            } else {
                currentOutVertex = OGraphCommands.getVertexByIndexedKey(orientGraph, keysOutVertex, valuesOutVertex, aggregatorEdge.getInVertexClassName());
                currentInVertex = OGraphCommands.getVertexByIndexedKey(orientGraph, keysInVertex, valuesInVertex, aggregatorEdge.getOutVertexClassName());
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            OEdgeType edgeType = aggregatorEdge.getEdgeType();
            for (OModelProperty currentProperty : edgeType.getAllProperties()) {
                String currentPropertyName = currentProperty.getName();
                String currentPropertyType = currentProperty.getOrientdbType();
                if (currentProperty.getOrientdbType() == null) {
                    currentPropertyType = OTeleporterContext.getInstance().getDataTypeHandler().resolveType(currentProperty.getOriginalType().toLowerCase(Locale.ENGLISH)).toString();
                }
                String currentOriginalType = currentProperty.getOriginalType();
                OVertexType joinVertexType = this.mapper.getJoinVertexTypeByAggregatorEdge(edgeType.getName());
                try {
                    this.extractPropertiesFromRecordIntoVertex(jointTableRecord, properties, currentPropertyType, currentPropertyName, currentOriginalType, joinVertexType);
                }
                catch (Exception e) {
                    String mess = "Problem encountered during the extraction of the values from the records. Edge Type: " + edgeType.getName() + ";\tProperty: " + currentProperty.getName() + ";\tOriginal join table: " + joinTable.getName();
                    OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                    OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
                }
            }
            this.upsertEdge(orientGraph, currentOutVertex, currentInVertex, aggregatorEdge.getEdgeType().getName(), properties, direction);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    private OVertex addVertexToGraph(ODatabaseDocument orientGraph, String classAndClusterName) {
        return this.addVertexToGraph(orientGraph, classAndClusterName, null);
    }

    private OVertex addVertexToGraph(ODatabaseDocument orientGraph, String classAndClusterName, Map<String, Object> properties) {
        OVertex vertex = null;
        boolean alreadySaved = false;
        try {
            if (classAndClusterName != null) {
                vertex = orientGraph.newVertex(classAndClusterName);
                if (properties != null) {
                    this.setElementProperties((OElement)vertex, properties);
                    alreadySaved = true;
                }
            }
        }
        catch (OValidationException e) {
            OTeleporterContext.getInstance().getStatistics().errorMessages.add(e.getMessage());
        }
        if (!alreadySaved) {
            vertex.save();
        }
        return vertex;
    }

    private OEdge addEdgeToGraph(ODatabaseDocument orientGraph, OVertex currentOutVertex, OVertex currentInVertex, String edgeType) {
        return this.addEdgeToGraph(orientGraph, currentOutVertex, currentInVertex, edgeType, null);
    }

    private OEdge addEdgeToGraph(ODatabaseDocument orientGraph, OVertex currentOutVertex, OVertex currentInVertex, String edgeType, Map<String, Object> properties) {
        OEdge edge = null;
        boolean alreadySaved = false;
        try {
            edge = orientGraph.newEdge(currentOutVertex, currentInVertex, edgeType);
            if (properties != null) {
                this.setElementProperties((OElement)edge, properties);
                alreadySaved = true;
            }
        }
        catch (OValidationException e) {
            OTeleporterContext.getInstance().getStatistics().errorMessages.add(e.getMessage());
        }
        if (!alreadySaved) {
            edge.save();
        }
        return edge;
    }

    private void setElementProperties(OElement element, Map<String, Object> properties) {
        try {
            for (String property : properties.keySet()) {
                Object value = properties.get(property);
                element.setProperty(property, value);
            }
            element.save();
        }
        catch (OValidationException e) {
            OTeleporterContext.getInstance().getStatistics().errorMessages.add(e.getMessage());
        }
    }

    public void updateVertexAccordingToLogicalRelationship(OVertex currentOutVertex, OVertexType currentInVertexType, List<String> fromPropertiesToUpdate) {
        LinkedHashMap<String, Object> updatedProps = new LinkedHashMap<String, Object>();
        for (String property : fromPropertiesToUpdate) {
            String oldValue = (String)currentOutVertex.getProperty(property);
            String newValue = "$" + currentInVertexType.getName() + ":" + oldValue;
            updatedProps.put(property, newValue);
        }
        this.setElementProperties((OElement)currentOutVertex, updatedProps);
    }
}

