/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.main;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterMessageHandler;
import com.orientechnologies.teleporter.exception.OTeleporterIOException;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.factory.OStrategyFactory;
import com.orientechnologies.teleporter.http.OServerCommandTeleporter;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.strategy.OWorkflowStrategy;
import com.orientechnologies.teleporter.ui.OProgressMonitor;
import com.orientechnologies.teleporter.util.ODriverConfigurator;
import com.orientechnologies.teleporter.util.OMigrationConfigManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class OTeleporter
extends OServerPluginAbstract {
    private static OPluginMessageHandler messageHandler;
    private static final OStrategyFactory FACTORY;
    private static final String teleport = "OrientDB                  \n ______________________________________________________________________________ \n ___  __/__  ____/__  /___  ____/__  __ \\_  __ \\__  __\\__  __/__  ____/__  _ _ \\  \n __  /  __  __/  __  / __  __/  __  /_/ /  / / /_  /_/ /_  /  __  __/  __  /_/ /\n _  /   _  /___  _  /___  /___  _  ____// /_/ /_  _, _/_  /   _  /___  _  _, _/ \n /_/    /_____/  /_____/_____/  /_/     \\____/ /_/ |_| /_/    /_____/  /_/ |_|  \n\n                                                  http://orientdb.com/teleporter";
    private OServer server;

    public static void main(String[] args) throws Exception {
        String[] arrayTables;
        String tables;
        messageHandler = new OTeleporterMessageHandler(2);
        messageHandler.info(OTeleporter.class, "\n\nOrientDB                  \n ______________________________________________________________________________ \n ___  __/__  ____/__  /___  ____/__  __ \\_  __ \\__  __\\__  __/__  ____/__  _ _ \\  \n __  /  __  __/  __  / __  __/  __  /_/ /  / / /_  /_/ /_  /  __  __/  __  /_/ /\n _  /   _  /___  _  /___  /___  _  ____// /_/ /_  _, _/_  /   _  /___  _  _, _/ \n /_/    /_____/  /_____/_____/  /_/     \\____/ /_/ |_| /_/    /_____/  /_/ |_|  \n\n                                                  http://orientdb.com/teleporter\n\n");
        if (args.length < 6) {
            messageHandler.error(OTeleporter.class, "Syntax error, missing argument. Use:\n ./oteleporter.sh -jdriver <jdbc-driver> -jurl <jdbc-url> -juser <username> -jpasswd <password> -ourl <orientdb-url>.\n");
            throw new OTeleporterIOException();
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            arguments.put(args[i], args[i + 1]);
        }
        if (!arguments.containsKey("-ourl")) {
            messageHandler.error(OTeleporter.class, "Argument -ourl is mandatory, please try again with expected argument: -ourl <output-orientdb-desired-URL>\n");
            throw new OTeleporterIOException();
        }
        if (!(arguments.get("-jdriver") == null || ((String)arguments.get("-jdriver")).equalsIgnoreCase("Oracle") || ((String)arguments.get("-jdriver")).equalsIgnoreCase("SQLServer") || ((String)arguments.get("-jdriver")).equalsIgnoreCase("MySQL") || ((String)arguments.get("-jdriver")).equalsIgnoreCase("PostgreSQL") || ((String)arguments.get("-jdriver")).equalsIgnoreCase("HyperSQL"))) {
            messageHandler.error(OTeleporter.class, "Not valid db-driver name. Type one of the following driver names: 'Oracle','SQLServer','MySQL','PostgreSQL','HyperSQL'\n");
            throw new OTeleporterIOException();
        }
        if (arguments.get("-jurl") != null && !((String)arguments.get("-jurl")).contains("jdbc:")) {
            messageHandler.error(OTeleporter.class, "Not valid db-url.\n");
            throw new OTeleporterIOException();
        }
        if (!(((String)arguments.get("-ourl")).contains("plocal:") || ((String)arguments.get("-ourl")).contains("embedded:") || ((String)arguments.get("-ourl")).contains("remote:") || ((String)arguments.get("-ourl")).contains("memory:"))) {
            messageHandler.error(OTeleporter.class, "Not valid output orient db uri.\n");
            throw new OTeleporterIOException();
        }
        if (arguments.get("-s") != null && !(((String)arguments.get("-s")).equals("naive") | ((String)arguments.get("-s")).equals("naive-aggregate"))) {
            messageHandler.error(OTeleporter.class, "Not valid strategy.\n");
            throw new OTeleporterIOException();
        }
        if (arguments.get("-v") != null && !(((String)arguments.get("-v")).equals("0") | ((String)arguments.get("-v")).equals("1") | ((String)arguments.get("-v")).equals("2") | ((String)arguments.get("-v")).equals("3"))) {
            messageHandler.error(OTeleporter.class, "Not valid output level. Available levels:\n0 - No messages\n1 - Debug\n2 - Info\n3 - Warning \n4 - Error\n");
            throw new OTeleporterIOException();
        }
        if (arguments.get("-inheritance") != null && !((String)arguments.get("-inheritance")).contains("hibernate:")) {
            messageHandler.error(OTeleporter.class, "Not valid inheritance argument. Syntax: -inheritance hibernate:<xml-path>\n");
            throw new OTeleporterIOException();
        }
        if (arguments.get("-include") != null && arguments.get("-exclude") != null) {
            messageHandler.error(OTeleporter.class, "It's not possible to use both 'include' and 'exclude' arguments.\n");
            throw new OTeleporterIOException();
        }
        if (arguments.get("-conf") != null) {
            File file = new File((String)arguments.get("-conf"));
            try {
                file.getCanonicalPath();
            }
            catch (IOException e) {
                messageHandler.error(OTeleporter.class, "Configuration file path not valid.\n");
                throw new OTeleporterIOException(e);
            }
        }
        String driver = (String)arguments.get("-jdriver");
        String jurl = (String)arguments.get("-jurl");
        String outDbUrl = (String)arguments.get("-ourl");
        String username = (String)arguments.get("-juser");
        String password = (String)arguments.get("-jpasswd");
        String chosenStrategy = (String)arguments.get("-s");
        String nameResolver = (String)arguments.get("-nr");
        String outputLevel = (String)arguments.get("-v");
        String chosenMapper = "basicDBMapper";
        String xmlPath = null;
        if (arguments.containsKey("-inheritance")) {
            String argument = (String)arguments.get("-inheritance");
            chosenMapper = argument.substring(0, argument.indexOf(58));
            xmlPath = argument.substring(argument.indexOf(58) + 1);
        }
        ArrayList<String> includedTables = null;
        ArrayList<String> excludedTables = null;
        if (arguments.get("-include") != null) {
            tables = (String)arguments.get("-include");
            arrayTables = tables.split(",");
            includedTables = new ArrayList<String>(Arrays.asList(arrayTables));
        }
        if (arguments.get("-exclude") != null) {
            tables = (String)arguments.get("-exclude");
            arrayTables = tables.split(",");
            excludedTables = new ArrayList<String>(Arrays.asList(arrayTables));
        }
        String configurationPath = (String)arguments.get("-conf");
        OTeleporter.execute(driver, jurl, username, password, outDbUrl, chosenStrategy, chosenMapper, xmlPath, nameResolver, outputLevel, includedTables, excludedTables, configurationPath, messageHandler);
    }

    public static void execute(String driver, String jurl, String username, String password, String outDbUrl, String chosenStrategy, String chosenMapper, String xmlPath, String nameResolver, String outputLevel, List<String> includedTables, List<String> excludedTables, String configurationPath, OPluginMessageHandler messageHandler) throws OTeleporterIOException {
        ODocument migrationConfigDoc = null;
        String jsonMigrationConfig = null;
        if (configurationPath != null) {
            migrationConfigDoc = OMigrationConfigManager.loadMigrationConfigFromFile(null, configurationPath, messageHandler);
            if (migrationConfigDoc != null) {
                jsonMigrationConfig = migrationConfigDoc.toJSON("");
            } else {
                messageHandler.info(OTeleporter.class, "No migration configuration file was found in the suggested path. Migration will be performed according to standard mapping rules or to the latest configured policies if any.\n");
            }
        }
        OTeleporter.executeJob(driver, jurl, username, password, outDbUrl, chosenStrategy, chosenMapper, xmlPath, nameResolver, outputLevel, includedTables, excludedTables, jsonMigrationConfig, messageHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ODocument executeJob(String driver, String jurl, String username, String password, String outDbUrl, String chosenStrategy, String chosenMapper, String xmlPath, String nameResolver, String outputLevel, List<String> includedTables, List<String> excludedTables, String jsonMigrationConfig, OPluginMessageHandler messageHandler, OrientDB orientDBInstance) throws OTeleporterIOException {
        ODocument executionResult;
        String targetDBPath;
        File targetDatabaseDirectory;
        OrientDBVersion orientDBVersion;
        String dbName;
        String serverInitUrl;
        String protocol;
        ORecordSerializerFactory.instance().register("ORecordSerializerBinary", (ORecordSerializer)new ORecordSerializerBinary());
        if (outDbUrl.contains("embedded") || outDbUrl.contains("plocal")) {
            protocol = "embedded";
            outDbUrl = outDbUrl.replace("plocal", "embedded");
            serverInitUrl = outDbUrl.substring(0, outDbUrl.lastIndexOf(47) + 1);
            dbName = outDbUrl.substring(outDbUrl.lastIndexOf(47) + 1);
        } else if (outDbUrl.contains("remote")) {
            protocol = "remote";
            serverInitUrl = outDbUrl.substring(0, outDbUrl.lastIndexOf(47) + 1);
            dbName = outDbUrl.substring(outDbUrl.lastIndexOf(47) + 1);
        } else {
            protocol = "memory";
            serverInitUrl = outDbUrl;
            dbName = outDbUrl.substring(outDbUrl.lastIndexOf(58) + 1);
        }
        if (orientDBInstance == null) {
            OTeleporterContext.newInstance(serverInitUrl);
        } else {
            OTeleporterContext.newInstance(orientDBInstance);
        }
        OTeleporterContext.getInstance().setMessageHandler(messageHandler);
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class.forName("com.orientechnologies.agent.profiler.OEnterpriseProfiler", false, classLoader);
            orientDBVersion = OrientDBVersion.EE;
        }
        catch (ClassNotFoundException e) {
            orientDBVersion = OrientDBVersion.CE;
        }
        if (orientDBVersion.equals((Object)OrientDBVersion.CE) && (chosenStrategy == null || !chosenStrategy.startsWith("interactive")) && (targetDatabaseDirectory = new File(targetDBPath = outDbUrl.substring(outDbUrl.indexOf(":") + 1))).exists() && targetDatabaseDirectory.listFiles().length > 1) {
            String message = "Synchronization not allowed in OrientDB CE. Execution will be terminated.";
            OTeleporterContext.getInstance().getMessageHandler().error(OTeleporter.class, message);
            throw new OTeleporterRuntimeException(message);
        }
        ODriverConfigurator driverConfig = new ODriverConfigurator();
        List<OSourceDatabaseInfo> sourcesInfo = null;
        boolean sourceInfoLoaded = false;
        if (driver == null || jurl == null) {
            ODocument sourcesInfoDoc = OMigrationConfigManager.loadSourceInfo(outDbUrl);
            if (sourcesInfoDoc == null) {
                OTeleporterContext.getInstance().getMessageHandler().error(OTeleporter.class, "Arguments -jdriver, -jurl, -juser and -jpasswd, necessary to access the source databases, were not specified and no previous sources's info were found in the target OrientDB graph database.\n");
                throw new OTeleporterIOException();
            }
            sourceInfoLoaded = true;
            sourcesInfo = OMigrationConfigManager.extractSourceDatabaseInfo(sourcesInfoDoc);
        } else {
            String driverClassName = driverConfig.fetchDriverClassName(driver);
            OSourceDatabaseInfo sourceDBInfo = new OSourceDatabaseInfo(driver, driverClassName, jurl, username, password);
            sourcesInfo = new LinkedList<OSourceDatabaseInfo>();
            sourcesInfo.add(sourceDBInfo);
        }
        driverConfig.checkDriverConfiguration(sourcesInfo.get(0).getSourceIdName());
        OSourceDatabaseInfo sourceInfo = sourcesInfo.get(0);
        ODocument migrationConfig = null;
        if (jsonMigrationConfig != null && jsonMigrationConfig.length() > 0) {
            migrationConfig = new ODocument();
            migrationConfig.fromJSON(jsonMigrationConfig, "noMap");
        } else {
            OTeleporterContext.getInstance().getMessageHandler().info(OTeleporter.class, "\nTrying to load a previous configuration file in the target OrientDB database...\n");
            String configurationPath = OMigrationConfigManager.buildConfigurationFilePath(outDbUrl, OMigrationConfigManager.getConfigFileName());
            String configDirPath = configurationPath.substring(0, configurationPath.lastIndexOf("/") + 1);
            migrationConfig = OMigrationConfigManager.loadMigrationConfigFromFile(configurationPath);
            if (migrationConfig != null) {
                OTeleporterContext.getInstance().getMessageHandler().info((Object)"A previous configuration in the %s path was loaded and it will be used for the current migration.", configDirPath);
            } else {
                OTeleporterContext.getInstance().getMessageHandler().info(OTeleporter.class, "No previous configuration in the %s path was found.\nMigration will be performed according to standard mapping rules.\n\n", new Object[]{configurationPath});
            }
        }
        OGlobalConfiguration.QUERY_SCAN_THRESHOLD_TIP.setValue((Object)-1);
        if (outputLevel != null) {
            messageHandler.setOutputManagerLevel(Integer.parseInt(outputLevel));
        }
        OProgressMonitor progressMonitor = new OProgressMonitor();
        progressMonitor.initialize();
        ODBQueryEngine dbQueryEngine = new ODBQueryEngine(sourceInfo.getDriverName());
        OTeleporterContext.getInstance().setDbQueryEngine(dbQueryEngine);
        OWorkflowStrategy strategy = FACTORY.buildStrategy(chosenStrategy, protocol, serverInitUrl, dbName);
        Timer timer = new Timer();
        try {
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    OTeleporterContext.getInstance().getStatistics().notifyListeners();
                }
            }, 0L, 1000L);
            executionResult = strategy.executeStrategy(sourceInfo, outDbUrl, chosenMapper, xmlPath, nameResolver, includedTables, excludedTables, migrationConfig);
            OGlobalConfiguration.QUERY_SCAN_THRESHOLD_TIP.setValue((Object)50000);
            if (!sourceInfoLoaded) {
                OMigrationConfigManager.upsertSourceDatabaseInfo(sourcesInfo, outDbUrl);
            }
            if (executionResult != null) {
                OMigrationConfigManager.writeConfigurationInTargetDB(executionResult, outDbUrl);
            }
        }
        finally {
            timer.cancel();
        }
        return executionResult;
    }

    public static ODocument execute(String driver, String jurl, String username, String password, String outDbUrl, String chosenStrategy, String chosenMapper, String xmlPath, String nameResolver, String outputLevel, List<String> includedTables, List<String> excludedTables, OPluginMessageHandler messageHandler) throws OTeleporterIOException {
        return OTeleporter.executeJob(driver, jurl, username, password, outDbUrl, chosenStrategy, chosenMapper, xmlPath, nameResolver, outputLevel, includedTables, excludedTables, null, messageHandler, null);
    }

    public String getName() {
        return "teleporter";
    }

    public void startup() {
        OServerNetworkListener listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (listener == null) {
            throw new OConfigurationException("HTTP listener not found");
        }
        listener.registerStatelessCommand((OServerCommand)new OServerCommandTeleporter());
    }

    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.server = oServer;
    }

    public void shutdown() {
        super.shutdown();
    }

    static {
        FACTORY = new OStrategyFactory();
    }

    public static enum OrientDBVersion {
        CE,
        EE;

    }
}

