/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.mapper.rdbms;

import com.orientechnologies.teleporter.configuration.api.OAggregatedJoinTableMapping;
import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.configuration.api.OConfiguredEdgeClass;
import com.orientechnologies.teleporter.configuration.api.OConfiguredProperty;
import com.orientechnologies.teleporter.configuration.api.OConfiguredPropertyMapping;
import com.orientechnologies.teleporter.configuration.api.OConfiguredVertexClass;
import com.orientechnologies.teleporter.configuration.api.OEdgeMappingInformation;
import com.orientechnologies.teleporter.configuration.api.OSourceTable;
import com.orientechnologies.teleporter.configuration.api.OSplittingEdgeInformation;
import com.orientechnologies.teleporter.configuration.api.OVertexMappingInformation;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.mapper.OSource2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.OAggregatorEdge;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEEClassMapper;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEVClassMapper;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.ODataBaseSchema;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OForeignKey;
import com.orientechnologies.teleporter.model.dbschema.OLogicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OPrimaryKey;
import com.orientechnologies.teleporter.model.dbschema.ORelationship;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OGraphModel;
import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.persistence.util.ODBSourceConnection;
import com.orientechnologies.teleporter.persistence.util.OQueryResult;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OER2GraphMapper
extends OSource2GraphMapper {
    protected OSourceDatabaseInfo sourceDBInfo;
    protected ODataBaseSchema dataBaseSchema;
    protected Map<OEntity, List<OEVClassMapper>> entity2EVClassMappers;
    protected Map<OVertexType, List<OEVClassMapper>> vertexType2EVClassMappers;
    protected Map<String, List<OEEClassMapper>> entity2EEClassMappers;
    protected Map<String, List<OEEClassMapper>> edgeType2EEClassMappers;
    protected Map<ORelationship, OEdgeType> relationship2edgeType;
    protected Map<OEdgeType, LinkedList<ORelationship>> edgeType2relationships;
    protected Map<String, Integer> edgeTypeName2count;
    protected Map<OVertexType, OAggregatorEdge> joinVertex2aggregatorEdges;
    protected List<String> includedTables;
    protected List<String> excludedTables;
    protected OConfiguration migrationConfig;
    public final int DEFAULT_CLASS_MAPPER_INDEX = 0;

    public OER2GraphMapper(OSourceDatabaseInfo sourceDatabaseInfo, List<String> includedTables, List<String> excludedTables, OConfiguration migrationConfig) {
        this.sourceDBInfo = sourceDatabaseInfo;
        this.entity2EVClassMappers = new IdentityHashMap<OEntity, List<OEVClassMapper>>();
        this.vertexType2EVClassMappers = new IdentityHashMap<OVertexType, List<OEVClassMapper>>();
        this.relationship2edgeType = new IdentityHashMap<ORelationship, OEdgeType>();
        this.edgeType2relationships = new IdentityHashMap<OEdgeType, LinkedList<ORelationship>>();
        this.edgeTypeName2count = new TreeMap<String, Integer>();
        this.joinVertex2aggregatorEdges = new LinkedHashMap<OVertexType, OAggregatorEdge>();
        this.entity2EEClassMappers = new LinkedHashMap<String, List<OEEClassMapper>>();
        this.edgeType2EEClassMappers = new LinkedHashMap<String, List<OEEClassMapper>>();
        this.includedTables = includedTables != null ? includedTables : new ArrayList<String>();
        this.excludedTables = excludedTables != null ? excludedTables : new ArrayList<String>();
        this.dataBaseSchema = new ODataBaseSchema();
        this.graphModel = new OGraphModel();
        this.migrationConfig = migrationConfig;
    }

    public void upsertRelationshipEdgeRules(ORelationship currentRelationship, OEdgeType currentEdgeType) {
        this.relationship2edgeType.put(currentRelationship, currentEdgeType);
        LinkedList<ORelationship> representedRelationships = this.edgeType2relationships.get(currentEdgeType);
        if (representedRelationships == null) {
            representedRelationships = new LinkedList();
        }
        representedRelationships.add(currentRelationship);
        this.edgeType2relationships.put(currentEdgeType, representedRelationships);
    }

    public void upsertEVClassMappingRules(OEntity currentEntity, OVertexType currentVertexType, OEVClassMapper classMapper) {
        List<OEVClassMapper> classMappings = this.entity2EVClassMappers.get(currentEntity);
        if (classMappings == null) {
            classMappings = new LinkedList<OEVClassMapper>();
        }
        classMappings.add(classMapper);
        this.entity2EVClassMappers.put(currentEntity, classMappings);
        classMappings = this.vertexType2EVClassMappers.get(currentVertexType);
        if (classMappings == null) {
            classMappings = new LinkedList<OEVClassMapper>();
        }
        classMappings.add(classMapper);
        this.vertexType2EVClassMappers.put(currentVertexType, classMappings);
    }

    public void upsertEEClassMappingRules(OEntity currentEntity, OEdgeType currentEdgeType, OEEClassMapper classMapper) {
        List<OEEClassMapper> classMappings = this.entity2EEClassMappers.get(currentEntity.getName());
        if (classMappings == null) {
            classMappings = new LinkedList<OEEClassMapper>();
        }
        classMappings.add(classMapper);
        this.entity2EEClassMappers.put(currentEntity.getName(), classMappings);
        classMappings = this.edgeType2EEClassMappers.get(currentEdgeType.getName());
        if (classMappings == null) {
            classMappings = new LinkedList<OEEClassMapper>();
        }
        classMappings.add(classMapper);
        this.edgeType2EEClassMappers.put(currentEdgeType.getName(), classMappings);
    }

    public List<OEVClassMapper> getEVClassMappersByVertex(OVertexType vertexType) {
        return this.vertexType2EVClassMappers.get(vertexType);
    }

    public List<OEVClassMapper> getEVClassMappersByEntity(OEntity entity) {
        return this.entity2EVClassMappers.get(entity);
    }

    public List<OEEClassMapper> getEEClassMappersByEntity(OEntity entity) {
        return this.entity2EEClassMappers.get(entity.getName());
    }

    public List<OEEClassMapper> getEEClassMappersByEdge(OEdgeType edgeType) {
        return this.edgeType2EEClassMappers.get(edgeType.getName());
    }

    public Map<OEntity, List<OEVClassMapper>> getEntity2EVClassMappers() {
        return this.entity2EVClassMappers;
    }

    public Map<OVertexType, List<OEVClassMapper>> getVertexType2EVClassMappers() {
        return this.vertexType2EVClassMappers;
    }

    public Map<String, List<OEEClassMapper>> getEntity2EEClassMappers() {
        return this.entity2EEClassMappers;
    }

    public Map<String, List<OEEClassMapper>> getEdgeType2EEClassMappers() {
        return this.edgeType2EEClassMappers;
    }

    public String getAttributeByPropertyAboveMappers(String propertyName, List<OEVClassMapper> classMappers) {
        for (OEVClassMapper currClassMapper : classMappers) {
            String attributeName = currClassMapper.getAttributeByProperty(propertyName);
            if (attributeName == null) continue;
            return attributeName;
        }
        return null;
    }

    @Override
    public void buildSourceDatabaseSchema() {
        Connection connection = null;
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        statistics.startWork1Time = new Date();
        statistics.runningStepNumber = 1;
        statistics.notifyListeners();
        try {
            connection = ODBSourceConnection.getConnection(this.sourceDBInfo);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            int majorVersion = databaseMetaData.getDatabaseMajorVersion();
            int minorVersion = databaseMetaData.getDatabaseMinorVersion();
            int driverMajorVersion = databaseMetaData.getDriverMajorVersion();
            int driverMinorVersion = databaseMetaData.getDriverMinorVersion();
            String productName = databaseMetaData.getDatabaseProductName();
            String productVersion = databaseMetaData.getDatabaseProductVersion();
            this.dataBaseSchema.setMajorVersion(majorVersion);
            this.dataBaseSchema.setMinorVersion(minorVersion);
            this.dataBaseSchema.setDriverMajorVersion(driverMajorVersion);
            this.dataBaseSchema.setDriverMinorVersion(driverMinorVersion);
            this.dataBaseSchema.setProductName(productName);
            this.dataBaseSchema.setProductVersion(productVersion);
            int numberOfTables = this.buildEntities(databaseMetaData, connection);
            this.buildOutRelationships(databaseMetaData, numberOfTables);
            this.buildInRelationships();
        }
        catch (SQLException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                String mess = "";
                OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
            }
        }
        try {
            if (connection.isClosed()) {
                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nConnection to DB closed.\n");
                }
            } else {
                statistics.warningMessages.add("\nConnection to DB not closed.\n");
            }
        }
        catch (SQLException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
        }
        statistics.notifyListeners();
        statistics.runningStepNumber = -1;
    }

    private int buildEntities(DatabaseMetaData databaseMetaData, Connection sourceDBConnection) throws SQLException {
        int numberOfTables;
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        LinkedHashMap<String, String> tablesName2schema = new LinkedHashMap<String, String>();
        String tableCatalog = null;
        String tableSchemaPattern = null;
        String tableNamePattern = null;
        String[] tableTypes = new String[]{"TABLE"};
        if (this.sourceDBInfo.getDriverName().contains("Oracle")) {
            ResultSet schemas = databaseMetaData.getSchemas();
            while (schemas.next()) {
                if (!schemas.getString(1).equalsIgnoreCase(this.sourceDBInfo.getUsername())) continue;
                tableSchemaPattern = schemas.getString(1);
                break;
            }
        }
        ResultSet resultTable = databaseMetaData.getTables(tableCatalog, tableSchemaPattern, tableNamePattern, tableTypes);
        while (resultTable.next()) {
            String tableSchema = resultTable.getString("TABLE_SCHEM");
            String tableName = resultTable.getString("TABLE_NAME");
            if (!this.isTableAllowed(tableName)) continue;
            tablesName2schema.put(tableName, tableSchema);
        }
        statistics.totalNumberOfEntities = numberOfTables = tablesName2schema.size();
        this.closeCursor(resultTable);
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n%s tables found.\n", new Object[]{numberOfTables});
        }
        Statement statement = sourceDBConnection.createStatement();
        ODBQueryEngine dbQueryEngine = OTeleporterContext.getInstance().getDbQueryEngine();
        int totalNumberOfRecord = 0;
        int iteration = 1;
        for (String currentTableName : tablesName2schema.keySet()) {
            String currentTableSchema;
            OQueryResult result;
            ResultSet currentTableRecordAmount;
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding '%s' entity (%s/%s)...\n", currentTableName, new Object[]{iteration, numberOfTables});
            }
            if ((currentTableRecordAmount = (result = dbQueryEngine.countTableRecords(this.sourceDBInfo, currentTableName, currentTableSchema = (String)tablesName2schema.get(currentTableName))).getResult()).next()) {
                totalNumberOfRecord += currentTableRecordAmount.getInt(1);
            }
            this.closeCursor(currentTableRecordAmount);
            OEntity currentEntity = new OEntity(currentTableName, currentTableSchema, this.sourceDBInfo);
            OPrimaryKey pKey = new OPrimaryKey(currentEntity);
            String columnCatalog = null;
            String columnSchemaPattern = null;
            String columnNamePattern = null;
            String primaryKeyCatalog = null;
            String primaryKeySchema = currentTableSchema;
            ResultSet resultColumns = databaseMetaData.getColumns(columnCatalog, columnSchemaPattern, currentTableName, columnNamePattern);
            ResultSet resultPrimaryKeys = databaseMetaData.getPrimaryKeys(primaryKeyCatalog, primaryKeySchema, currentTableName);
            List<String> currentPrimaryKeys = this.getPrimaryKeysFromResulset(resultPrimaryKeys);
            while (resultColumns.next()) {
                OAttribute currentAttribute = new OAttribute(resultColumns.getString("COLUMN_NAME"), resultColumns.getInt("ORDINAL_POSITION"), resultColumns.getString("TYPE_NAME"), currentEntity);
                currentEntity.addAttribute(currentAttribute);
                if (!currentPrimaryKeys.contains(currentAttribute.getName())) continue;
                pKey.addAttribute(currentAttribute);
            }
            this.closeCursor(resultColumns);
            this.closeCursor(resultPrimaryKeys);
            currentEntity.setPrimaryKey(pKey);
            if (pKey.getInvolvedAttributes().size() == 0) {
                OTeleporterContext.getInstance().getStatistics().warningMessages.add("It's not declared a primary key for the Entity " + currentEntity.getName() + ", this might lead to issues during the migration or the sync executions (the first importing is quite safe).");
            }
            this.dataBaseSchema.getEntities().add(currentEntity);
            ++iteration;
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEntity %s built.\n", new Object[]{currentTableName});
            }
            ++statistics.builtEntities;
            statistics.totalNumberOfRecords = totalNumberOfRecord;
        }
        statement.close();
        return numberOfTables;
    }

    private void buildOutRelationships(DatabaseMetaData databaseMetaData, int numberOfTables) throws SQLException {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        int iteration = 1;
        for (OEntity currentForeignEntity : this.dataBaseSchema.getEntities()) {
            LinkedHashMap<String, String> currentExternalRow;
            String currentForeignEntityName = currentForeignEntity.getName();
            String foreignSchema = currentForeignEntity.getSchemaName();
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding OUT relationships starting from '%s' entity (%s/%s)...\n", currentForeignEntityName, new Object[]{iteration, numberOfTables});
            }
            String foreignCatalog = null;
            ResultSet resultForeignKeys = databaseMetaData.getImportedKeys(foreignCatalog, foreignSchema, currentForeignEntityName);
            List<LinkedHashMap<String, String>> currentEntityRelationships1 = this.fromResultSetToList(resultForeignKeys);
            LinkedList<LinkedHashMap<String, String>> currentEntityRelationships2 = new LinkedList<LinkedHashMap<String, String>>();
            for (LinkedHashMap<String, String> row : currentEntityRelationships1) {
                currentEntityRelationships2.add(row);
            }
            this.closeCursor(resultForeignKeys);
            Iterator<LinkedHashMap<String, String>> it1 = currentEntityRelationships1.iterator();
            Iterator it2 = currentEntityRelationships2.iterator();
            while (it1.hasNext() && !(currentExternalRow = it1.next()).get("key_seq").equals("2")) {
                String currentParentTableName = currentExternalRow.get("pktable_name");
                int currentKeySeq = Integer.parseInt(currentExternalRow.get("key_seq"));
                OEntity currentParentTable = this.dataBaseSchema.getEntityByName(currentParentTableName);
                OCanonicalRelationship currentRelationship = new OCanonicalRelationship(currentForeignEntity, currentParentTable);
                OForeignKey currentFk = new OForeignKey(currentForeignEntity);
                while (it2.hasNext()) {
                    LinkedHashMap row = (LinkedHashMap)it2.next();
                    if (!((String)row.get("pktable_name")).equals(currentParentTableName) || Integer.parseInt((String)row.get("key_seq")) != currentKeySeq) continue;
                    currentFk.addAttribute(currentForeignEntity.getAttributeByName((String)row.get("fkcolumn_name")));
                    it2.remove();
                    ++currentKeySeq;
                }
                it2 = currentEntityRelationships2.iterator();
                OPrimaryKey currentPk = this.dataBaseSchema.getEntityByName(currentParentTableName).getPrimaryKey();
                currentRelationship.setPrimaryKey(currentPk);
                currentRelationship.setForeignKey(currentFk);
                currentForeignEntity.getForeignKeys().add(currentFk);
                this.dataBaseSchema.getCanonicalRelationships().add(currentRelationship);
                currentForeignEntity.getOutCanonicalRelationships().add(currentRelationship);
                ++statistics.builtRelationships;
            }
            ++iteration;
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nOUT Relationships from %s built.\n", new Object[]{currentForeignEntityName});
            }
            ++statistics.entitiesAnalyzedForRelationship;
        }
        statistics.totalNumberOfRelationships = this.dataBaseSchema.getCanonicalRelationships().size();
    }

    private void buildInRelationships() {
        boolean iteration = true;
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nConnecting IN relationships...\n");
        }
        for (ORelationship oRelationship : this.dataBaseSchema.getCanonicalRelationships()) {
            OEntity currentInEntity = this.getDataBaseSchema().getEntityByName(oRelationship.getParentEntity().getName());
            currentInEntity.getInCanonicalRelationships().add((OCanonicalRelationship)oRelationship);
        }
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nIN relationships built.\n");
        }
    }

    private List<String> getPrimaryKeysFromResulset(ResultSet resultPrimaryKeys) throws SQLException {
        LinkedList<String> currentPrimaryKeys = new LinkedList<String>();
        while (resultPrimaryKeys.next()) {
            currentPrimaryKeys.add(resultPrimaryKeys.getString(4));
        }
        return currentPrimaryKeys;
    }

    private void closeCursor(ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
        }
    }

    private List<LinkedHashMap<String, String>> fromResultSetToList(ResultSet resultForeignKeys) {
        LinkedList<LinkedHashMap<String, String>> rows = new LinkedList<LinkedHashMap<String, String>>();
        try {
            int columnsAmount = resultForeignKeys.getMetaData().getColumnCount();
            while (resultForeignKeys.next()) {
                if (!this.isTableAllowed(resultForeignKeys.getString("pktable_name")) || this.dataBaseSchema.getEntityByName(resultForeignKeys.getString("pktable_name")) == null) continue;
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                for (int i = 1; i <= columnsAmount; ++i) {
                    row.put(resultForeignKeys.getMetaData().getColumnName(i).toLowerCase(Locale.ENGLISH), resultForeignKeys.getString(i));
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return rows;
    }

    @Override
    public void buildGraphModel(ONameResolver nameResolver) {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        statistics.startWork2Time = new Date();
        statistics.runningStepNumber = 2;
        this.buildVertexTypes(nameResolver);
        this.buildEdgeTypes(nameResolver);
        statistics.notifyListeners();
        statistics.runningStepNumber = -1;
    }

    private void buildVertexTypes(ONameResolver nameResolver) {
        int numberOfVertexType;
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        statistics.totalNumberOfModelVertices = numberOfVertexType = this.dataBaseSchema.getEntities().size();
        int iteration = 1;
        for (OEntity currentEntity : this.dataBaseSchema.getEntities()) {
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding '%s' vertex-type (%s/%s)...\n", currentEntity.getName(), new Object[]{iteration, numberOfVertexType});
            }
            String currentVertexTypeName = nameResolver.resolveVertexName(currentEntity.getName());
            boolean alreadyPresentInGraphModel = true;
            OVertexType currentVertexType = this.graphModel.getVertexTypeByName(currentVertexTypeName);
            if (currentVertexType == null) {
                currentVertexType = new OVertexType(currentVertexTypeName);
                alreadyPresentInGraphModel = false;
            }
            if (currentEntity.isAggregableJoinTable()) {
                currentVertexType.setIsFromJoinTable(true);
            } else {
                currentVertexType.setIsFromJoinTable(false);
            }
            LinkedHashMap<String, String> attribute2property = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> property2attribute = new LinkedHashMap<String, String>();
            for (OAttribute oAttribute : currentEntity.getAttributes()) {
                String orientdbDataType = OTeleporterContext.getInstance().getDataTypeHandler().resolveType(oAttribute.getDataType().toLowerCase(Locale.ENGLISH)).toString();
                OModelProperty currentProperty2 = new OModelProperty(nameResolver.resolveVertexProperty(oAttribute.getName()), oAttribute.getOrdinalPosition(), oAttribute.getDataType(), currentEntity.getPrimaryKey().getInvolvedAttributes().contains(oAttribute), currentVertexType);
                currentProperty2.setOrientdbType(orientdbDataType);
                currentVertexType.getProperties().add(currentProperty2);
                attribute2property.put(oAttribute.getName(), currentProperty2.getName());
                property2attribute.put(currentProperty2.getName(), oAttribute.getName());
            }
            for (OAttribute oAttribute : currentEntity.getInheritedAttributes()) {
                OModelProperty currentProperty = new OModelProperty(nameResolver.resolveVertexProperty(oAttribute.getName()), oAttribute.getOrdinalPosition(), oAttribute.getDataType(), currentEntity.getPrimaryKey().getInvolvedAttributes().contains(oAttribute), currentVertexType);
                currentVertexType.getInheritedProperties().add(currentProperty);
            }
            LinkedHashSet<String> externalKey = new LinkedHashSet<String>();
            for (OModelProperty currentProperty : currentVertexType.getAllProperties()) {
                if (!currentProperty.isFromPrimaryKey()) continue;
                externalKey.add(currentProperty.getName());
            }
            currentVertexType.setExternalKey(externalKey);
            if (currentEntity.getParentEntity() != null) {
                OVertexType oVertexType = this.graphModel.getVertexTypeByNameIgnoreCase(currentEntity.getParentEntity().getName());
                currentVertexType.setParentType(oVertexType);
                currentVertexType.setInheritanceLevel(currentEntity.getInheritanceLevel());
            }
            if (!alreadyPresentInGraphModel) {
                this.graphModel.getVerticesType().add(currentVertexType);
            }
            OEVClassMapper oEVClassMapper = new OEVClassMapper(currentEntity, currentVertexType, attribute2property, property2attribute);
            this.upsertEVClassMappingRules(currentEntity, currentVertexType, oEVClassMapper);
            ++iteration;
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nVertex-type %s built.\n", new Object[]{currentVertexTypeName});
            }
            ++statistics.builtModelVertexTypes;
        }
        Collections.sort(this.graphModel.getVerticesType());
    }

    private void buildEdgeTypes(ONameResolver nameResolver) {
        int numberOfEdgeType;
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        statistics.totalNumberOfModelEdges = numberOfEdgeType = this.dataBaseSchema.getCanonicalRelationships().size();
        String edgeType = null;
        int iteration = 1;
        if (numberOfEdgeType > 0) {
            for (OEntity currentEntity : this.dataBaseSchema.getEntities()) {
                OEdgeType currentEdgeType;
                OVertexType currentInVertex;
                OVertexType currentOutVertex;
                for (OCanonicalRelationship relationship : currentEntity.getOutCanonicalRelationships()) {
                    currentOutVertex = this.getVertexTypeByEntity(relationship.getForeignEntity());
                    currentInVertex = this.getVertexTypeByEntity(relationship.getParentEntity());
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding edge-type from '%s' to '%s' (%s/%s)...\n", currentOutVertex.getName(), new Object[]{currentInVertex.getName(), iteration, numberOfEdgeType});
                    }
                    if (currentOutVertex != null && currentInVertex != null) {
                        if (!(this.relationship2edgeType.containsKey(relationship) || currentEntity.getParentEntity() != null && currentEntity.getParentEntity().getName().equals(relationship.getParentEntity().getName()))) {
                            edgeType = nameResolver.resolveEdgeName(relationship);
                            currentEdgeType = this.graphModel.getEdgeTypeByName(edgeType);
                            if (currentEdgeType == null) {
                                currentEdgeType = new OEdgeType(edgeType, null, currentInVertex);
                                this.graphModel.getEdgesType().add(currentEdgeType);
                                if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                                    OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type %s built.\n", new Object[]{currentEdgeType.getName()});
                                }
                                ++statistics.builtModelEdgeTypes;
                            } else {
                                currentEdgeType.setNumberRelationshipsRepresented(currentEdgeType.getNumberRelationshipsRepresented() + 1);
                            }
                            if (!currentOutVertex.getOutEdgesType().contains(currentEdgeType)) {
                                currentOutVertex.getOutEdgesType().add(currentEdgeType);
                            }
                            if (!currentInVertex.getInEdgesType().contains(currentEdgeType)) {
                                currentInVertex.getInEdgesType().add(currentEdgeType);
                            }
                            this.upsertRelationshipEdgeRules(relationship, currentEdgeType);
                        }
                    } else {
                        OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "Error during graph model building phase: information loss, relationship missed. Edge-type not built.\n");
                    }
                    ++iteration;
                }
                for (OCanonicalRelationship relationship : currentEntity.getInheritedOutCanonicalRelationships()) {
                    currentOutVertex = this.getVertexTypeByEntity(currentEntity);
                    currentInVertex = this.getVertexTypeByEntity(relationship.getParentEntity());
                    if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)"\nBuilding edge-type from '%s' to '%s' (%s/%s)...\n", currentOutVertex.getName(), new Object[]{currentInVertex.getName(), iteration, numberOfEdgeType});
                    }
                    if (currentOutVertex != null && currentInVertex != null) {
                        currentEdgeType = this.graphModel.getEdgeTypeByName(edgeType);
                        currentOutVertex.getOutEdgesType().add(currentEdgeType);
                        currentInVertex.getInEdgesType().add(currentEdgeType);
                        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() != 1) continue;
                        OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type built.\n");
                        continue;
                    }
                    OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "Error during graph model building phase: information loss, relationship missed. Edge-type not built.\n");
                }
            }
            statistics.totalNumberOfModelEdges = statistics.builtModelEdgeTypes;
        }
    }

    @Override
    public void applyImportConfiguration() {
        if (this.migrationConfig != null) {
            this.upsertClassesFromConfiguration();
            this.upsertRelationshipsFromConfiguration();
        }
    }

    private void upsertClassesFromConfiguration() {
        List<OConfiguredVertexClass> configuredVertices = this.migrationConfig.getConfiguredVertices();
        ONameResolver nameResolver = OTeleporterContext.getInstance().getNameResolver();
        for (OConfiguredVertexClass currentConfiguredVertexClass : configuredVertices) {
            if (currentConfiguredVertexClass.isAlreadyAnalyzed()) continue;
            OVertexMappingInformation currentMapping = currentConfiguredVertexClass.getMapping();
            List<String> externalKeyProps = currentConfiguredVertexClass.getExternalKeyProps();
            List<OSourceTable> sourceTables = currentMapping.getSourceTables();
            String aggregationFunction = currentMapping.getAggregationFunction();
            HashMap<String, String> sourceId2tableName = new HashMap<String, String>();
            Map<String, List<OConfiguredVertexClass>> tableName2mappedConfiguredVertices = this.migrationConfig.buildTableName2MappedConfiguredVertices();
            for (OSourceTable currentSourceTable : sourceTables) {
                String currSourceIdName = currentSourceTable.getSourceIdName();
                String currTableName = currentSourceTable.getTableName();
                sourceId2tableName.put(currSourceIdName, currTableName);
            }
            if (sourceId2tableName.size() == 1) {
                String tableName = (String)sourceId2tableName.entrySet().iterator().next().getValue();
                if (tableName2mappedConfiguredVertices.get(tableName).size() == 1) {
                    this.performOne2OneMapping(sourceId2tableName, currentConfiguredVertexClass, externalKeyProps);
                    continue;
                }
                if (tableName2mappedConfiguredVertices.get(tableName).size() > 1) {
                    this.performSplittingMapping(sourceId2tableName, tableName2mappedConfiguredVertices);
                    continue;
                }
                OTeleporterContext.getInstance().getMessageHandler().error((Object)"Mapping error: No vertices are mapped with '%s' table.", tableName);
                throw new OTeleporterRuntimeException();
            }
            if (sourceId2tableName.size() <= 1) continue;
            this.performAggregationMapping(sourceId2tableName, currentConfiguredVertexClass, externalKeyProps);
        }
    }

    private void performOne2OneMapping(Map<String, String> sourceId2tableName, OConfiguredVertexClass currentConfiguredVertexClass, List<String> externalKeyProps) {
        String sourceTableName = sourceId2tableName.entrySet().iterator().next().getValue();
        OEVClassMapper currentClassMapper = this.entity2EVClassMappers.get(this.dataBaseSchema.getEntityByName(sourceTableName)).get(0);
        OVertexType currentVertexType = currentClassMapper.getVertexType();
        currentVertexType.setName(currentConfiguredVertexClass.getName());
        LinkedList<OConfiguredProperty> configuredPropertiedToAdd = new LinkedList<OConfiguredProperty>();
        for (OConfiguredProperty configuredProperty : currentConfiguredVertexClass.getConfiguredProperties()) {
            OConfiguredPropertyMapping propertyMapping = configuredProperty.getPropertyMapping();
            OModelProperty propertyToUpsert = null;
            String originalPropertyName = null;
            String columnName = null;
            String originalType = null;
            if (propertyMapping != null) {
                columnName = propertyMapping.getColumnName();
                originalType = propertyMapping.getType();
                originalPropertyName = currentClassMapper.getPropertyByAttribute(propertyMapping.getColumnName());
                propertyToUpsert = currentVertexType.getPropertyByNameAmongAll(originalPropertyName);
            } else {
                propertyToUpsert = currentVertexType.getPropertyByOrdinalPosition(configuredProperty.getOrdinalPosition());
            }
            String orientdbType = configuredProperty.getPropertyType();
            String actualPropertyName = configuredProperty.getPropertyName();
            if (propertyToUpsert != null) {
                if (originalPropertyName == null) {
                    originalPropertyName = propertyToUpsert.getName();
                }
                if (!originalPropertyName.equals(actualPropertyName)) {
                    propertyToUpsert.setName(actualPropertyName);
                    currentClassMapper.getAttribute2property().put(columnName, actualPropertyName);
                    currentClassMapper.getProperty2attribute().remove(originalPropertyName);
                    currentClassMapper.getProperty2attribute().put(actualPropertyName, columnName);
                }
                propertyToUpsert.setIncludedInMigration(configuredProperty.isIncludedInMigration());
                propertyToUpsert.setOrientdbType(configuredProperty.getPropertyType());
                propertyToUpsert.setMandatory(configuredProperty.isMandatory());
                propertyToUpsert.setReadOnly(configuredProperty.isReadOnly());
                propertyToUpsert.setNotNull(configuredProperty.isNotNull());
                propertyToUpsert.setOriginalType(originalType);
                propertyToUpsert.setOrientdbType(orientdbType);
                continue;
            }
            configuredPropertiedToAdd.add(configuredProperty);
        }
        this.addExternalKeyToVertexType(externalKeyProps, currentVertexType);
        for (OConfiguredProperty configuredProperty : configuredPropertiedToAdd) {
            String propertyName = configuredProperty.getPropertyName();
            String originalType = null;
            if (configuredProperty.getPropertyMapping() != null) {
                originalType = configuredProperty.getPropertyMapping().getType();
            }
            String orientdbType = configuredProperty.getPropertyType();
            int ordinalPosition = configuredProperty.getOrdinalPosition();
            OModelProperty newProperty = new OModelProperty(propertyName, ordinalPosition, originalType, orientdbType, false, currentVertexType, false, false, false);
            currentVertexType.getProperties().add(newProperty);
            currentClassMapper.getProperty2attribute().put(propertyName, null);
        }
        currentConfiguredVertexClass.setAlreadyAnalyzed(true);
    }

    private void performAggregationMapping(Map<String, String> sourceId2tableName, OConfiguredVertexClass currentConfiguredVertexClass, List<String> externalKeyProps) {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        LinkedList<OVertexType> verticesToMerge = new LinkedList<OVertexType>();
        OVertexType newAggregatedVertexType = new OVertexType(currentConfiguredVertexClass.getName());
        for (String sourceTableName : sourceId2tableName.values()) {
            List<OEVClassMapper> currentClassMappers = this.entity2EVClassMappers.get(this.dataBaseSchema.getEntityByName(sourceTableName));
            for (OEVClassMapper oEVClassMapper : currentClassMappers) {
                verticesToMerge.add(oEVClassMapper.getVertexType());
            }
        }
        boolean aggregable = true;
        Object currentParentType = null;
        String errorMsg = null;
        for (OVertexType oVertexType : verticesToMerge) {
            if (!oVertexType.isFromJoinTable()) continue;
            aggregable = false;
            errorMsg = "'" + oVertexType.getName() + "' comes from a join table, thus the requested aggregation will be skipped.";
            break;
        }
        if (aggregable) {
            OVertexType firstParentVertexType = (OVertexType)((OVertexType)verticesToMerge.get(0)).getParentType();
            for (OVertexType v : verticesToMerge) {
                OVertexType currentParentVertexType = (OVertexType)v.getParentType();
                if (firstParentVertexType == null) {
                    if (currentParentVertexType == null) continue;
                    aggregable = false;
                    break;
                }
                if (v.getParentType().equals(firstParentVertexType)) continue;
                aggregable = false;
                break;
            }
        }
        if (aggregable) {
            for (OVertexType oVertexType : verticesToMerge) {
                for (OEdgeType currentInEdgeType : oVertexType.getInEdgesType()) {
                    currentInEdgeType.setInVertexType(newAggregatedVertexType);
                    newAggregatedVertexType.getInEdgesType().add(currentInEdgeType);
                }
                for (OEdgeType currentOutEdgeType : oVertexType.getOutEdgesType()) {
                    currentOutEdgeType.setOutVertexType(newAggregatedVertexType);
                    newAggregatedVertexType.getOutEdgesType().add(currentOutEdgeType);
                }
            }
            int ordinalPosition = 1;
            LinkedHashMap<String, LinkedList<OConfiguredProperty>> linkedHashMap = new LinkedHashMap<String, LinkedList<OConfiguredProperty>>();
            for (OConfiguredProperty configuredProperty : currentConfiguredVertexClass.getConfiguredProperties()) {
                OConfiguredPropertyMapping propertyMapping = configuredProperty.getPropertyMapping();
                String source = propertyMapping.getSourceName();
                String tableName = sourceId2tableName.get(source);
                LinkedList<OConfiguredProperty> configuredproperties = (LinkedList<OConfiguredProperty>)linkedHashMap.get(tableName);
                if (configuredproperties == null) {
                    configuredproperties = new LinkedList<OConfiguredProperty>();
                }
                configuredproperties.add(configuredProperty);
                linkedHashMap.put(tableName, configuredproperties);
                String propertyName = configuredProperty.getPropertyName();
                boolean include = configuredProperty.isIncludedInMigration();
                String orientdbType = configuredProperty.getPropertyType();
                boolean isMandatory = configuredProperty.isMandatory();
                boolean isReadOnly = configuredProperty.isReadOnly();
                boolean isNotNull = configuredProperty.isNotNull();
                String columnName = propertyMapping.getColumnName();
                String originalType = propertyMapping.getType();
                String originalSource = propertyMapping.getSourceName();
                String originalSourceTableName = sourceId2tableName.get(originalSource);
                boolean fromPrimaryKey = false;
                OEVClassMapper currentClassMapper = this.entity2EVClassMappers.get(this.dataBaseSchema.getEntityByName(originalSourceTableName)).get(0);
                OEntity currentEntity = currentClassMapper.getEntity();
                if (currentEntity.getPrimaryKey().getAttributeByName(columnName) != null) {
                    fromPrimaryKey = true;
                }
                OModelProperty property = new OModelProperty(propertyName, ordinalPosition, originalType, orientdbType, fromPrimaryKey, newAggregatedVertexType, isMandatory, isReadOnly, isNotNull);
                property.setIncludedInMigration(include);
                newAggregatedVertexType.getProperties().add(property);
                ++ordinalPosition;
            }
            this.addExternalKeyToVertexType(externalKeyProps, newAggregatedVertexType);
            for (OVertexType v : verticesToMerge) {
                this.vertexType2EVClassMappers.remove(v);
            }
            for (String tableName : linkedHashMap.keySet()) {
                OEntity currentEntity = this.getDataBaseSchema().getEntityByName(tableName);
                HashMap<String, String> attribute2property = new HashMap<String, String>();
                HashMap<String, String> property2attribute = new HashMap<String, String>();
                for (OConfiguredProperty prop : (List)linkedHashMap.get(tableName)) {
                    String columnName = prop.getPropertyMapping().getColumnName();
                    String propertyName = prop.getPropertyName();
                    attribute2property.put(columnName, propertyName);
                    property2attribute.put(propertyName, columnName);
                }
                this.entity2EVClassMappers.remove(currentEntity);
                OEVClassMapper currentNewCM = new OEVClassMapper(currentEntity, newAggregatedVertexType, attribute2property, property2attribute);
                this.upsertEVClassMappingRules(currentEntity, newAggregatedVertexType, currentNewCM);
            }
            for (OVertexType v : verticesToMerge) {
                this.getGraphModel().getVerticesType().remove(v);
                --statistics.totalNumberOfModelVertices;
                --statistics.builtModelVertexTypes;
            }
            this.getGraphModel().getVerticesType().add(newAggregatedVertexType);
            ++statistics.totalNumberOfModelVertices;
            ++statistics.builtModelVertexTypes;
        }
        currentConfiguredVertexClass.setAlreadyAnalyzed(true);
    }

    private void performSplittingMapping(Map<String, String> sourceId2tableName, Map<String, List<OConfiguredVertexClass>> tableName2mappedConfiguredVertices) {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        String sourceTableName = sourceId2tableName.entrySet().iterator().next().getValue();
        OEVClassMapper currentClassMapper = this.entity2EVClassMappers.get(this.dataBaseSchema.getEntityByName(sourceTableName)).get(0);
        OEntity entity = currentClassMapper.getEntity();
        entity.setIsSplitEntity(true);
        OVertexType vertexType = currentClassMapper.getVertexType();
        Map<String, List<OEdgeType>> vertexType2inEdges = this.splitEdgesForVertexAccordingToRelationships(entity.getInCanonicalRelationships(), entity.getName(), tableName2mappedConfiguredVertices);
        Map<String, List<OEdgeType>> vertexType2outEdges = this.splitEdgesForVertexAccordingToRelationships(entity.getOutCanonicalRelationships(), entity.getName(), tableName2mappedConfiguredVertices);
        this.vertexType2EVClassMappers.remove(vertexType);
        this.entity2EVClassMappers.remove(entity);
        this.graphModel.removeVertexTypeByName(vertexType.getName());
        --statistics.totalNumberOfModelVertices;
        --statistics.builtModelVertexTypes;
        for (OConfiguredVertexClass currentConfiguredVertexClass : tableName2mappedConfiguredVertices.get(sourceTableName)) {
            OVertexType currentVertexType = this.graphModel.getVertexTypeByName(currentConfiguredVertexClass.getName());
            if (currentVertexType == null) {
                currentVertexType = new OVertexType(currentConfiguredVertexClass.getName());
                this.graphModel.getVerticesType().add(currentVertexType);
                ++statistics.totalNumberOfModelVertices;
                ++statistics.builtModelVertexTypes;
            }
            OSourceTable sourceTable = currentConfiguredVertexClass.getMapping().getSourceTables().get(0);
            List<String> primaryKeyColumns = sourceTable.getPrimaryKeyColumns();
            HashMap<String, String> attribute2property = new HashMap<String, String>();
            HashMap<String, String> property2attribute = new HashMap<String, String>();
            for (OConfiguredProperty configuredProperty : currentConfiguredVertexClass.getConfiguredProperties()) {
                OConfiguredPropertyMapping propertyMapping = configuredProperty.getPropertyMapping();
                String propertyName = configuredProperty.getPropertyName();
                int ordinalPosition = configuredProperty.getOrdinalPosition();
                String originalType = propertyMapping.getType();
                String orientdbType = configuredProperty.getPropertyType();
                boolean isMandatory = configuredProperty.isMandatory();
                boolean isReadOnly = configuredProperty.isReadOnly();
                boolean isNotNull = configuredProperty.isNotNull();
                boolean fromPrimaryKey = false;
                String columnName = propertyMapping.getColumnName();
                if (primaryKeyColumns.contains(columnName)) {
                    fromPrimaryKey = true;
                }
                OModelProperty currentProperty = new OModelProperty(propertyName, ordinalPosition, originalType, orientdbType, fromPrimaryKey, currentVertexType, isMandatory, isReadOnly, isNotNull);
                currentVertexType.getProperties().add(currentProperty);
                attribute2property.put(columnName, propertyName);
                property2attribute.put(propertyName, columnName);
            }
            this.addExternalKeyToVertexType(currentConfiguredVertexClass.getExternalKeyProps(), currentVertexType);
            List<OEdgeType> inEdgeTypes = vertexType2inEdges.get(currentVertexType.getName());
            List<OEdgeType> outEdgeTypes = vertexType2outEdges.get(currentVertexType.getName());
            if (inEdgeTypes != null) {
                currentVertexType.getInEdgesType().addAll(inEdgeTypes);
            }
            if (outEdgeTypes != null) {
                currentVertexType.getOutEdgesType().addAll(outEdgeTypes);
            }
            currentClassMapper = new OEVClassMapper(entity, currentVertexType, attribute2property, property2attribute);
            this.upsertEVClassMappingRules(entity, currentVertexType, currentClassMapper);
            currentConfiguredVertexClass.setAlreadyAnalyzed(true);
        }
    }

    private Map<String, List<OEdgeType>> splitEdgesForVertexAccordingToRelationships(Set<? extends ORelationship> relationships, String entityName, Map<String, List<OConfiguredVertexClass>> tableName2mappedConfiguredVertices) {
        HashMap<String, List<OEdgeType>> vertexType2edges = new HashMap<String, List<OEdgeType>>();
        block0: for (ORelationship oRelationship : relationships) {
            OEdgeType currOutEdge = this.getRelationship2edgeType().get(oRelationship);
            List<OAttribute> fromColumns = oRelationship.getFromColumns();
            for (OConfiguredVertexClass currConfiguredVertex : tableName2mappedConfiguredVertices.get(entityName)) {
                boolean vertexDetected = true;
                for (OAttribute currAttribute : fromColumns) {
                    if (currConfiguredVertex.getPropertyByAttribute(currAttribute.getName()) != null) continue;
                    vertexDetected = false;
                    break;
                }
                if (!vertexDetected) continue;
                LinkedList<OEdgeType> outEdgeTypes = (LinkedList<OEdgeType>)vertexType2edges.get(currConfiguredVertex.getName());
                if (outEdgeTypes == null) {
                    outEdgeTypes = new LinkedList<OEdgeType>();
                }
                outEdgeTypes.add(currOutEdge);
                vertexType2edges.put(currConfiguredVertex.getName(), outEdgeTypes);
                continue block0;
            }
        }
        return vertexType2edges;
    }

    private void addExternalKeyToVertexType(List<String> externalKeyProps, OVertexType currentVertexType) {
        if (externalKeyProps != null) {
            currentVertexType.getExternalKey().addAll(externalKeyProps);
        } else {
            for (OModelProperty currProperty : currentVertexType.getAllProperties()) {
                if (!currProperty.isFromPrimaryKey()) continue;
                currentVertexType.getExternalKey().add(currProperty.getName());
            }
        }
    }

    private void upsertRelationshipsFromConfiguration() {
        List<OConfiguredEdgeClass> configuredEdges = this.migrationConfig.getConfiguredEdges();
        ONameResolver nameResolver = OTeleporterContext.getInstance().getNameResolver();
        for (OConfiguredEdgeClass currentEdgeClass : configuredEdges) {
            String edgeName = currentEdgeClass.getName();
            List<OEdgeMappingInformation> edgeMappings = currentEdgeClass.getMappings();
            OSplittingEdgeInformation splittingEdgeInfo = currentEdgeClass.getSplittingEdgeInfo();
            if (edgeMappings != null) {
                for (OEdgeMappingInformation edgeMapping : edgeMappings) {
                    String currentForeignEntityName = edgeMapping.getFromTableName();
                    String currentParentEntityName = edgeMapping.getToTableName();
                    List<String> fromColumns = edgeMapping.getFromColumns();
                    List<String> toColumns = edgeMapping.getToColumns();
                    OAggregatedJoinTableMapping joinTableMapping = edgeMapping.getRepresentedJoinTableMapping();
                    if (currentForeignEntityName == null) {
                        OTeleporterContext.getInstance().getMessageHandler().error((Object)"Configuration error: 'fromTable' field not found in the '%s' edge-type definition.", edgeName);
                        throw new OTeleporterRuntimeException();
                    }
                    if (currentParentEntityName == null) {
                        OTeleporterContext.getInstance().getMessageHandler().error((Object)"Configuration error: 'toTable' field not found in the '%s' edge-type definition.", edgeName);
                        throw new OTeleporterRuntimeException();
                    }
                    if (fromColumns == null) {
                        OTeleporterContext.getInstance().getMessageHandler().error((Object)"Configuration error: 'fromColumns' field not found in the '%s' edge-type definition.", edgeName);
                        throw new OTeleporterRuntimeException();
                    }
                    if (toColumns == null) {
                        OTeleporterContext.getInstance().getMessageHandler().error((Object)"Configuration error: 'toColumns' field not found in the '%s' edge-type definition.", edgeName);
                        throw new OTeleporterRuntimeException();
                    }
                    String direction = edgeMapping.getDirection();
                    if (direction != null && !direction.equals("direct") && !direction.equals("inverse")) {
                        OTeleporterContext.getInstance().getMessageHandler().error((Object)"Configuration error: direction for the edge %s cannot be '%s'. Allowed values: 'direct' or 'inverse' \n", edgeName, new Object[]{direction});
                        throw new OTeleporterRuntimeException();
                    }
                    boolean foreignEntityIsJoinTableToAggregate = false;
                    if (joinTableMapping == null) {
                        ORelationship currentRelationship = this.buildRelationshipFromConfig(currentForeignEntityName, currentParentEntityName, fromColumns, toColumns, direction, foreignEntityIsJoinTableToAggregate);
                        this.buildEdgeTypeFromConfiguredRelationship(currentRelationship, edgeName, currentEdgeClass, foreignEntityIsJoinTableToAggregate);
                        continue;
                    }
                    String joinTableName = joinTableMapping.getTableName();
                    foreignEntityIsJoinTableToAggregate = true;
                    if (OTeleporterContext.getInstance().getExecutionStrategy().equals("naive-aggregate")) {
                        List<String> joinTableFromColumns = joinTableMapping.getFromColumns();
                        List<String> joinTableToColumns = joinTableMapping.getToColumns();
                        ORelationship currentRelationship = this.buildRelationshipFromConfig(joinTableName, currentForeignEntityName, joinTableFromColumns, fromColumns, direction, foreignEntityIsJoinTableToAggregate);
                        this.buildEdgeTypeFromConfiguredRelationship(currentRelationship, edgeName + "-left", currentEdgeClass, foreignEntityIsJoinTableToAggregate);
                        currentRelationship = this.buildRelationshipFromConfig(joinTableName, currentParentEntityName, joinTableToColumns, toColumns, direction, foreignEntityIsJoinTableToAggregate);
                        this.buildEdgeTypeFromConfiguredRelationship(currentRelationship, edgeName + "-right", currentEdgeClass, foreignEntityIsJoinTableToAggregate);
                        OEntity joinTable = this.dataBaseSchema.getEntityByName(joinTableName);
                        joinTable.setIsAggregableJoinTable(true);
                        joinTable.setDirectionOfN2NRepresentedRelationship(direction);
                        joinTable.setNameOfN2NRepresentedRelationship(edgeName);
                        OVertexType correspondentVertexType = this.getVertexTypeByEntity(joinTable);
                        correspondentVertexType.setIsFromJoinTable(true);
                        continue;
                    }
                    if (!OTeleporterContext.getInstance().getExecutionStrategy().equals("naive")) continue;
                    OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "Configuration not compliant with the chosen strategy: you cannot perform the aggregation declared in the migrationConfigDoc for the join table %s while executing migration with a not-aggregating strategy. Thus no aggregation will be performed.\n", new Object[]{joinTableName});
                    throw new OTeleporterRuntimeException();
                }
                continue;
            }
            if (splittingEdgeInfo == null) continue;
            this.buildEdgeTypeFromConfiguredSplittingEdge(currentEdgeClass, splittingEdgeInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ORelationship buildRelationshipFromConfig(String currentForeignEntityName, String currentParentEntityName, List<String> fromColumns, List<String> toColumns, String direction, boolean foreignEntityIsJoinTableToAggregate) {
        List<OAttribute> keyAttributes;
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        ORelationship currentRelationship = null;
        OEntity currentForeignEntity = this.dataBaseSchema.getEntityByName(currentForeignEntityName);
        OEntity currentParentEntity = this.dataBaseSchema.getEntityByName(currentParentEntityName);
        boolean isCanonicalRelationship = true;
        OPrimaryKey primaryKey = currentParentEntity.getPrimaryKey();
        if (!currentParentEntity.isSplitEntity().booleanValue()) {
            keyAttributes = primaryKey.getInvolvedAttributes();
        } else {
            keyAttributes = new LinkedList<OAttribute>();
            List<OEVClassMapper> classMappers = this.getEVClassMappersByEntity(currentParentEntity);
            for (String string : toColumns) {
                keyAttributes.add(currentParentEntity.getAttributeByName(string));
            }
        }
        if (toColumns.size() != keyAttributes.size()) {
            isCanonicalRelationship = false;
        }
        if (isCanonicalRelationship) {
            for (String currColumnName : toColumns) {
                if (primaryKey.getAttributeByName(currColumnName) != null) continue;
                isCanonicalRelationship = false;
                break;
            }
        }
        boolean relationshipAlreadyPresentInDBSchema = true;
        currentRelationship = this.dataBaseSchema.getRelationshipByInvolvedEntitiesAndAttributes(currentForeignEntity, currentParentEntity, fromColumns, toColumns);
        if (isCanonicalRelationship) {
            if (currentRelationship == null) {
                currentRelationship = new OCanonicalRelationship(currentForeignEntity, currentParentEntity);
                relationshipAlreadyPresentInDBSchema = false;
                ++statistics.builtRelationships;
                ++statistics.totalNumberOfRelationships;
            }
            if (!relationshipAlreadyPresentInDBSchema) {
                void var16_21;
                OForeignKey currentFk = new OForeignKey(currentForeignEntity);
                for (String column : fromColumns) {
                    currentFk.addAttribute(currentForeignEntity.getAttributeByName(column));
                }
                if (!currentParentEntity.isSplitEntity().booleanValue()) {
                    OPrimaryKey oPrimaryKey = this.dataBaseSchema.getEntityByName(currentParentEntityName).getPrimaryKey();
                } else {
                    OPrimaryKey oPrimaryKey = new OPrimaryKey(currentParentEntity);
                    oPrimaryKey.setInvolvedAttributes(keyAttributes);
                }
                ((OCanonicalRelationship)currentRelationship).setPrimaryKey((OPrimaryKey)var16_21);
                ((OCanonicalRelationship)currentRelationship).setForeignKey(currentFk);
                currentForeignEntity.getForeignKeys().add(currentFk);
                this.dataBaseSchema.getCanonicalRelationships().add((OCanonicalRelationship)currentRelationship);
                currentForeignEntity.getOutCanonicalRelationships().add((OCanonicalRelationship)currentRelationship);
                currentParentEntity.getInCanonicalRelationships().add((OCanonicalRelationship)currentRelationship);
            }
        } else {
            if (currentRelationship == null) {
                currentRelationship = new OLogicalRelationship(currentForeignEntity, currentParentEntity);
                ++statistics.builtRelationships;
                ++statistics.totalNumberOfRelationships;
            }
            LinkedList<OAttribute> fromAttributes = new LinkedList<OAttribute>();
            for (String columnName : fromColumns) {
                OAttribute currAttribute = currentForeignEntity.getAttributeByName(columnName);
                fromAttributes.add(currAttribute);
            }
            LinkedList<OAttribute> linkedList = new LinkedList<OAttribute>();
            for (String columnName : toColumns) {
                OAttribute currAttribute = currentParentEntity.getAttributeByName(columnName);
                linkedList.add(currAttribute);
            }
            ((OLogicalRelationship)currentRelationship).setFromColumns(fromAttributes);
            ((OLogicalRelationship)currentRelationship).setToColumns(linkedList);
            currentForeignEntity.getOutLogicalRelationships().add((OLogicalRelationship)currentRelationship);
            this.dataBaseSchema.getLogicalRelationships().add((OLogicalRelationship)currentRelationship);
        }
        if (direction != null && !foreignEntityIsJoinTableToAggregate) {
            if (direction.equals("direct") || direction.equals("inverse")) {
                currentRelationship.setDirection(direction);
            } else {
                OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "Wrong value for the direction of the relationship between %s and %s: \"%s\" is not a valid direction. Direction \"direct\" will be adopted for the current migration/synchronization.\n", new Object[]{currentRelationship.getForeignEntity(), currentRelationship.getParentEntity(), direction});
            }
        }
        return currentRelationship;
    }

    private void buildEdgeTypeFromConfiguredRelationship(ORelationship currentRelationship, String edgeName, OConfiguredEdgeClass currentEdgeClass, boolean foreignEntityIsJoinTableToAggregate) {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        OEntity currentParentEntity = currentRelationship.getParentEntity();
        OEntity currentForeignEntity = currentRelationship.getForeignEntity();
        OEdgeType currentEdgeType = this.relationship2edgeType.get(currentRelationship);
        boolean edgeTypeAlreadyPresent = false;
        if (foreignEntityIsJoinTableToAggregate) {
            if (currentEdgeType != null) {
                currentEdgeType.setNumberRelationshipsRepresented(currentEdgeType.getNumberRelationshipsRepresented() - 1);
            }
            currentEdgeType = new OEdgeType(edgeName, null, null);
            this.graphModel.getEdgesType().add(currentEdgeType);
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type %s built.\n", new Object[]{currentEdgeType.getName()});
            }
            ++statistics.builtModelEdgeTypes;
            ++statistics.totalNumberOfModelEdges;
        } else if (currentEdgeType == null) {
            currentEdgeType = new OEdgeType(edgeName, null, null);
            this.graphModel.getEdgesType().add(currentEdgeType);
            if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
                OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type %s built.\n", new Object[]{currentEdgeType.getName()});
            }
            ++statistics.builtModelEdgeTypes;
            ++statistics.totalNumberOfModelEdges;
        } else {
            edgeTypeAlreadyPresent = true;
            currentEdgeType.setName(edgeName);
        }
        this.addPropertiesToEdgeTypeFromConfiguredClass(currentEdgeType, currentEdgeClass);
        String currentRelationshipDirection = currentRelationship.getDirection();
        boolean mappingAlreadyPresent = true;
        if (this.relationship2edgeType.get(currentRelationship) == null) {
            mappingAlreadyPresent = false;
        }
        if (edgeTypeAlreadyPresent) {
            if (currentRelationshipDirection != null && currentRelationshipDirection.equals("inverse")) {
                OVertexType currentInVertexType = this.getVertexTypeByEntityAndRelationship(currentForeignEntity, (OCanonicalRelationship)currentRelationship);
                OVertexType currentOutVertexType = this.getVertexTypeByEntity(currentParentEntity);
                currentInVertexType.getOutEdgesType().remove(currentEdgeType);
                currentOutVertexType.getInEdgesType().remove(currentEdgeType);
                currentInVertexType.getInEdgesType().add(currentEdgeType);
                currentOutVertexType.getOutEdgesType().add(currentEdgeType);
                currentEdgeType.setInVertexType(currentInVertexType);
            }
        } else {
            OVertexType currentOutVertexType;
            OVertexType currentInVertexType;
            if (currentRelationshipDirection == null) {
                currentInVertexType = this.getVertexTypeByEntityAndRelationship(currentParentEntity, (OCanonicalRelationship)currentRelationship);
                currentOutVertexType = this.getVertexTypeByEntity(currentForeignEntity);
            } else if (foreignEntityIsJoinTableToAggregate) {
                currentInVertexType = this.getVertexTypeByEntityAndRelationship(currentParentEntity, (OCanonicalRelationship)currentRelationship);
                currentOutVertexType = this.getVertexTypeByEntity(currentForeignEntity);
                List<ORelationship> relationships = this.getRelationshipsByForeignAndParentTables(currentForeignEntity.getName(), currentParentEntity.getName());
                for (ORelationship currRelationship : relationships) {
                    OEdgeType edgeTypeToDel = this.getRelationship2edgeType().get(currentRelationship);
                    currentOutVertexType.getOutEdgesType().remove(edgeTypeToDel);
                    if (edgeTypeToDel == null || edgeTypeToDel.getNumberRelationshipsRepresented() != 0) continue;
                    currentInVertexType.getInEdgesType().remove(edgeTypeToDel);
                    this.graphModel.getEdgesType().remove(edgeTypeToDel);
                    this.edgeType2relationships.remove(edgeTypeToDel);
                    --statistics.builtModelEdgeTypes;
                    --statistics.totalNumberOfModelEdges;
                }
            } else if (currentRelationshipDirection.equals("direct")) {
                currentInVertexType = this.getVertexTypeByEntityAndRelationship(currentParentEntity, currentRelationship);
                currentOutVertexType = this.getVertexTypeByEntity(currentForeignEntity);
            } else {
                currentInVertexType = this.getVertexTypeByEntity(currentForeignEntity);
                currentOutVertexType = this.getVertexTypeByEntity(currentParentEntity);
            }
            currentInVertexType.getInEdgesType().add(currentEdgeType);
            currentOutVertexType.getOutEdgesType().add(currentEdgeType);
            currentEdgeType.setInVertexType(currentInVertexType);
            this.upsertRelationshipEdgeRules(currentRelationship, currentEdgeType);
        }
    }

    private void buildEdgeTypeFromConfiguredSplittingEdge(OConfiguredEdgeClass currentEdgeClass, OSplittingEdgeInformation splittingEdgeInfo) {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        OVertexType inVertexType = this.graphModel.getVertexTypeByName(splittingEdgeInfo.getToVertexClass());
        OVertexType outVertexType = this.graphModel.getVertexTypeByName(splittingEdgeInfo.getFromVertexClass());
        OEdgeType edgeType = new OEdgeType(currentEdgeClass.getName(), outVertexType, inVertexType, 0, true);
        this.graphModel.getEdgesType().add(edgeType);
        outVertexType.getOutEdgesType().add(edgeType);
        inVertexType.getInEdgesType().add(edgeType);
        this.addPropertiesToEdgeTypeFromConfiguredClass(edgeType, currentEdgeClass);
        String sourceTableName = splittingEdgeInfo.getSourceTable();
        OEntity entity = this.getDataBaseSchema().getEntityByName(sourceTableName);
        LinkedHashMap<String, String> attribute2property = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> property2attribute = new LinkedHashMap<String, String>();
        for (OConfiguredProperty currConfiguredProperty : currentEdgeClass.getConfiguredProperties()) {
            String propertyName = currConfiguredProperty.getPropertyName();
            String attributeName = currConfiguredProperty.getPropertyMapping().getColumnName();
            attribute2property.put(attributeName, propertyName);
            property2attribute.put(propertyName, attributeName);
        }
        OEEClassMapper classMapper = new OEEClassMapper(entity, edgeType, attribute2property, property2attribute);
        this.upsertEEClassMappingRules(entity, edgeType, classMapper);
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nEdge-type %s built.\n", new Object[]{edgeType.getName()});
        }
        ++statistics.builtModelEdgeTypes;
        ++statistics.totalNumberOfModelEdges;
    }

    private void addPropertiesToEdgeTypeFromConfiguredClass(OEdgeType currentEdgeType, OConfiguredEdgeClass currentEdgeClass) {
        Collection<OConfiguredProperty> properties = currentEdgeClass.getConfiguredProperties();
        if (properties != null) {
            int ordinalPosition = currentEdgeType.getProperties().size() + 1;
            for (OConfiguredProperty configuredProperty : properties) {
                Boolean notNull;
                Boolean readOnly;
                OConfiguredPropertyMapping propertyMapping = configuredProperty.getPropertyMapping();
                String propertyName = configuredProperty.getPropertyName();
                ordinalPosition = configuredProperty.getOrdinalPosition();
                String originalType = null;
                if (propertyMapping != null) {
                    originalType = propertyMapping.getType();
                }
                String orientdbType = configuredProperty.getPropertyType();
                OModelProperty currentProperty = currentEdgeType.getPropertyByName(propertyName);
                if (currentProperty == null) {
                    currentProperty = new OModelProperty(propertyName, ordinalPosition, originalType, false, currentEdgeType);
                    ++ordinalPosition;
                }
                currentProperty.setFromPrimaryKey(false);
                Boolean mandatory = configuredProperty.isMandatory();
                if (mandatory != null) {
                    currentProperty.setMandatory(mandatory);
                }
                if ((readOnly = Boolean.valueOf(configuredProperty.isReadOnly())) != null) {
                    currentProperty.setReadOnly(readOnly);
                }
                if ((notNull = Boolean.valueOf(configuredProperty.isNotNull())) != null) {
                    currentProperty.setNotNull(notNull);
                }
                currentProperty.setOrientdbType(orientdbType);
                currentEdgeType.getProperties().add(currentProperty);
            }
        }
    }

    public void performAggregations() {
        this.performMany2ManyAggregation();
    }

    public void performMany2ManyAggregation() {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        Iterator<OVertexType> it = this.graphModel.getVerticesType().iterator();
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\n\nJoin Table aggregation phase...\n");
        }
        while (it.hasNext()) {
            OModelProperty newProperty;
            OVertexType inVertexType;
            OVertexType outVertexType;
            OVertexType currentVertexType = it.next();
            if (!currentVertexType.isFromJoinTable() || currentVertexType.getOutEdgesType().size() != 2) continue;
            OEdgeType currentOutEdge1 = currentVertexType.getOutEdgesType().get(0);
            OEdgeType currentOutEdge2 = currentVertexType.getOutEdgesType().get(1);
            String direction = this.getEntityByVertexType(currentVertexType).getDirectionOfN2NRepresentedRelationship();
            if (direction.equals("direct")) {
                outVertexType = currentOutEdge1.getInVertexType();
                inVertexType = currentOutEdge2.getInVertexType();
            } else {
                outVertexType = currentOutEdge2.getInVertexType();
                inVertexType = currentOutEdge1.getInVertexType();
            }
            OEntity joinTable = this.getEntityByVertexType(currentVertexType);
            String nameOfRelationship = joinTable.getNameOfN2NRepresentedRelationship();
            String edgeType = nameOfRelationship != null ? nameOfRelationship : currentVertexType.getName();
            OEdgeType newAggregatorEdge = new OEdgeType(edgeType, outVertexType, inVertexType);
            int position = 1;
            for (OModelProperty currentProperty : currentVertexType.getProperties()) {
                if (currentProperty.isFromPrimaryKey()) continue;
                newProperty = new OModelProperty(currentProperty.getName(), position, currentProperty.getOriginalType(), currentProperty.isFromPrimaryKey(), newAggregatorEdge);
                newProperty.setOrientdbType(currentProperty.getOrientdbType());
                if (currentProperty.isMandatory() != null) {
                    newProperty.setMandatory(currentProperty.isMandatory());
                }
                if (currentProperty.isReadOnly() != null) {
                    newProperty.setReadOnly(currentProperty.isReadOnly());
                }
                if (currentProperty.isNotNull() != null) {
                    newProperty.setNotNull(currentProperty.isNotNull());
                }
                newAggregatorEdge.getProperties().add(newProperty);
                ++position;
            }
            for (OModelProperty currentProperty : currentOutEdge1.getProperties()) {
                if (newAggregatorEdge.getPropertyByName(currentProperty.getName()) != null) continue;
                newProperty = new OModelProperty(currentProperty.getName(), position, currentProperty.getOriginalType(), currentProperty.isFromPrimaryKey(), newAggregatorEdge);
                newProperty.setOrientdbType(currentProperty.getOrientdbType());
                if (currentProperty.isMandatory() != null) {
                    newProperty.setMandatory(currentProperty.isMandatory());
                }
                if (currentProperty.isReadOnly() != null) {
                    newProperty.setReadOnly(currentProperty.isReadOnly());
                }
                if (currentProperty.isNotNull() != null) {
                    newProperty.setNotNull(currentProperty.isNotNull());
                }
                newAggregatorEdge.getProperties().add(newProperty);
                ++position;
            }
            for (OModelProperty currentProperty : currentOutEdge2.getProperties()) {
                if (newAggregatorEdge.getPropertyByName(currentProperty.getName()) != null) continue;
                newProperty = new OModelProperty(currentProperty.getName(), position, currentProperty.getOriginalType(), currentProperty.isFromPrimaryKey(), newAggregatorEdge);
                newProperty.setOrientdbType(currentProperty.getOrientdbType());
                if (currentProperty.isMandatory() != null) {
                    newProperty.setMandatory(currentProperty.isMandatory());
                }
                if (currentProperty.isReadOnly() != null) {
                    newProperty.setReadOnly(currentProperty.isReadOnly());
                }
                if (currentProperty.isNotNull() != null) {
                    newProperty.setNotNull(currentProperty.isNotNull());
                }
                newAggregatorEdge.getProperties().add(newProperty);
                ++position;
            }
            currentOutEdge1.setNumberRelationshipsRepresented(currentOutEdge1.getNumberRelationshipsRepresented() - 1);
            currentOutEdge2.setNumberRelationshipsRepresented(currentOutEdge2.getNumberRelationshipsRepresented() - 1);
            if (currentOutEdge1.getNumberRelationshipsRepresented() == 0) {
                this.graphModel.getEdgesType().remove(currentOutEdge1);
                --statistics.builtModelEdgeTypes;
                --statistics.totalNumberOfModelEdges;
            }
            if (currentOutEdge2.getNumberRelationshipsRepresented() == 0) {
                this.graphModel.getEdgesType().remove(currentOutEdge2);
                --statistics.builtModelEdgeTypes;
                --statistics.totalNumberOfModelEdges;
            }
            if (direction.equals("direct")) {
                outVertexType.getInEdgesType().remove(currentOutEdge1);
                inVertexType.getInEdgesType().remove(currentOutEdge2);
            } else {
                outVertexType.getInEdgesType().remove(currentOutEdge2);
                inVertexType.getInEdgesType().remove(currentOutEdge1);
            }
            this.joinVertex2aggregatorEdges.put(currentVertexType, new OAggregatorEdge(outVertexType.getName(), inVertexType.getName(), newAggregatorEdge));
            it.remove();
            --statistics.builtModelVertexTypes;
            --statistics.totalNumberOfModelVertices;
            this.graphModel.getEdgesType().add(newAggregatorEdge);
            ++statistics.builtModelEdgeTypes;
            ++statistics.totalNumberOfModelEdges;
            outVertexType.getOutEdgesType().add(newAggregatorEdge);
            inVertexType.getInEdgesType().add(newAggregatorEdge);
        }
        if (OTeleporterContext.getInstance().getMessageHandler().getOutputManagerLevel() == 1) {
            OTeleporterContext.getInstance().getMessageHandler().debug((Object)this, "\nAggregation performed.\n");
        }
    }

    public ODataBaseSchema getDataBaseSchema() {
        return this.dataBaseSchema;
    }

    public void setDataBaseSchema(ODataBaseSchema dataBaseSchema) {
        this.dataBaseSchema = dataBaseSchema;
    }

    public OEntity getEntityByVertexType(OVertexType vertexType) {
        return this.getEntityByVertexType(vertexType, 0);
    }

    public OEntity getEntityByVertexType(OVertexType vertexType, int classMapperIndex) {
        return this.getEVClassMappersByVertex(vertexType).get(classMapperIndex).getEntity();
    }

    public OVertexType getVertexTypeByEntity(OEntity entity) {
        return this.getVertexTypeByEntity(entity, 0);
    }

    public OVertexType getVertexTypeByEntity(OEntity entity, int classMapperIndex) {
        return this.getEVClassMappersByEntity(entity).get(classMapperIndex).getVertexType();
    }

    public OVertexType getVertexTypeByEntityAndRelationship(OEntity currentParentEntity, ORelationship currentRelationship) {
        List<OEVClassMapper> classMappers = this.getEVClassMappersByEntity(currentParentEntity);
        if (classMappers.size() == 1) {
            return this.getVertexTypeByEntity(currentParentEntity);
        }
        List<OAttribute> toAttributes = currentRelationship.getToColumns();
        OVertexType correspondentVertexType = null;
        for (OEVClassMapper classMapper : classMappers) {
            boolean found = true;
            for (OAttribute currAttribute : toAttributes) {
                if (classMapper.getAttribute2property().get(currAttribute.getName()) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            correspondentVertexType = classMapper.getVertexType();
            break;
        }
        return correspondentVertexType;
    }

    public String getAttributeNameByVertexTypeAndProperty(OVertexType vertexType, String propertyName) {
        OVertexType parentType;
        OEVClassMapper cm;
        String attributeName = null;
        Iterator<OEVClassMapper> iterator = this.getEVClassMappersByVertex(vertexType).iterator();
        while (iterator.hasNext() && (attributeName = (cm = iterator.next()).getAttributeByProperty(propertyName)) == null) {
        }
        if (attributeName == null && (parentType = (OVertexType)vertexType.getParentType()) != null) {
            return this.getAttributeNameByVertexTypeAndProperty(parentType, propertyName);
        }
        return attributeName;
    }

    public String getPropertyNameByVertexTypeAndAttribute(OVertexType vertexType, String attributeName) {
        OVertexType parentType;
        OEVClassMapper currentClassMapper;
        List<OEVClassMapper> classMappers = this.getEVClassMappersByVertex(vertexType);
        String propertyName = null;
        Iterator<OEVClassMapper> iterator = classMappers.iterator();
        while (iterator.hasNext() && (propertyName = (currentClassMapper = iterator.next()).getPropertyByAttribute(attributeName)) == null) {
        }
        if (propertyName == null && (parentType = (OVertexType)vertexType.getParentType()) != null) {
            return this.getPropertyNameByVertexTypeAndAttribute(parentType, attributeName);
        }
        return propertyName;
    }

    public String getAttributeNameByEdgeTypeAndProperty(OEdgeType edgeType, String propertyName) {
        OVertexType parentType;
        OEEClassMapper cm;
        String attributeName = null;
        Iterator<OEEClassMapper> iterator = this.getEEClassMappersByEdge(edgeType).iterator();
        while (iterator.hasNext() && (attributeName = (cm = iterator.next()).getAttributeByProperty(propertyName)) == null) {
        }
        if (attributeName == null && (parentType = (OVertexType)edgeType.getParentType()) != null) {
            return this.getAttributeNameByVertexTypeAndProperty(parentType, propertyName);
        }
        return attributeName;
    }

    public String getPropertyNameByEntityAndAttribute(OEntity entity, String attributeName) {
        OEntity parentEntity;
        OEVClassMapper currentClassMapper;
        List<OEVClassMapper> classMappers = this.getEVClassMappersByEntity(entity);
        String propertyName = null;
        Iterator<OEVClassMapper> iterator = classMappers.iterator();
        while (iterator.hasNext() && (propertyName = (currentClassMapper = iterator.next()).getPropertyByAttribute(attributeName)) == null) {
        }
        if (propertyName == null && (parentEntity = entity.getParentEntity()) != null) {
            return this.getPropertyNameByEntityAndAttribute(parentEntity, attributeName);
        }
        return propertyName;
    }

    public OVertexType getJoinVertexTypeByAggregatorEdge(String edgeType) {
        for (Map.Entry<OVertexType, OAggregatorEdge> entry : this.joinVertex2aggregatorEdges.entrySet()) {
            if (!entry.getValue().getEdgeType().getName().equals(edgeType)) continue;
            OVertexType joinVertexType = entry.getKey();
            return joinVertexType;
        }
        return null;
    }

    public OAggregatorEdge getAggregatorEdgeByJoinVertexTypeName(String vertexTypeName) {
        for (OVertexType currentVertexType : this.joinVertex2aggregatorEdges.keySet()) {
            if (!currentVertexType.getName().equals(vertexTypeName)) continue;
            return this.joinVertex2aggregatorEdges.get(currentVertexType);
        }
        return null;
    }

    public OAggregatorEdge getAggregatorEdgeByEdgeTypeName(String edgeTypeName) {
        for (OAggregatorEdge currAggregatorEdge : this.joinVertex2aggregatorEdges.values()) {
            if (!currAggregatorEdge.getEdgeType().getName().equals(edgeTypeName)) continue;
            return currAggregatorEdge;
        }
        return null;
    }

    public List<ORelationship> getRelationshipsByForeignAndParentTables(String currentForeignEntity, String currentParentEntity) {
        LinkedList<ORelationship> relationships = new LinkedList<ORelationship>();
        for (ORelationship oRelationship : this.dataBaseSchema.getCanonicalRelationships()) {
            if (!oRelationship.getForeignEntity().getName().equals(currentForeignEntity) || !oRelationship.getParentEntity().getName().equals(currentParentEntity)) continue;
            relationships.add(oRelationship);
        }
        return relationships;
    }

    public Map<ORelationship, OEdgeType> getRelationship2edgeType() {
        return this.relationship2edgeType;
    }

    public void setRelationship2edgeType(Map<ORelationship, OEdgeType> relationship2edgeTypeRules) {
        this.relationship2edgeType = relationship2edgeTypeRules;
    }

    public Map<OEdgeType, LinkedList<ORelationship>> getEdgeType2relationships() {
        return this.edgeType2relationships;
    }

    public void setEdgeType2relationships(Map<OEdgeType, LinkedList<ORelationship>> edgeType2relationships) {
        this.edgeType2relationships = edgeType2relationships;
    }

    public Map<String, Integer> getEdgeTypeName2count() {
        return this.edgeTypeName2count;
    }

    public void setEdgeTypeName2count(Map<String, Integer> edgeTypeName2count) {
        this.edgeTypeName2count = edgeTypeName2count;
    }

    public Map<OVertexType, OAggregatorEdge> getJoinVertex2aggregatorEdges() {
        return this.joinVertex2aggregatorEdges;
    }

    public void setJoinVertex2aggregatorEdges(Map<OVertexType, OAggregatorEdge> joinVertex2aggregatorEdges) {
        this.joinVertex2aggregatorEdges = joinVertex2aggregatorEdges;
    }

    public List<String> getIncludedTables() {
        return this.includedTables;
    }

    public void setIncludedTables(List<String> includedTables) {
        this.includedTables = includedTables;
    }

    public List<String> getExcludedTables() {
        return this.excludedTables;
    }

    public void setExcludedTables(List<String> excludedTables) {
        this.excludedTables = excludedTables;
    }

    public OConfiguration getMigrationConfig() {
        return this.migrationConfig;
    }

    public void setMigrationConfig(OConfiguration migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    public boolean isTableAllowed(String tableName) {
        if (this.includedTables.size() > 0) {
            return this.includedTables.contains(tableName);
        }
        if (this.excludedTables.size() > 0) {
            return !this.excludedTables.contains(tableName);
        }
        return true;
    }

    @Override
    public String toString() {
        String s = "\n\n\n------------------------------ MAPPER DESCRIPTION ------------------------------\n\n\n";
        s = s + "RULES\n\n";
        s = s + "- Class mappings:\n\n";
        for (List<OEVClassMapper> classMappers : this.entity2EVClassMappers.values()) {
            for (OEVClassMapper classMapper : classMappers) {
                s = s + classMapper.toString() + "\n";
            }
        }
        s = s + "\n\n- Relaionship2EdgeType Rules:\n\n";
        for (ORelationship relationship : this.relationship2edgeType.keySet()) {
            s = s + relationship.getForeignEntity() + "2" + relationship.getParentEntity() + " --> " + this.relationship2edgeType.get(relationship).getName() + "\n";
        }
        s = s + "\n\n- EdgeTypeName2Count Rules:\n\n";
        for (String edgeName : this.edgeTypeName2count.keySet()) {
            s = s + edgeName + " --> " + this.edgeTypeName2count.get(edgeName) + "\n";
        }
        s = s + "\n";
        return s;
    }
}

