/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.mapper.rdbms;

import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OHierarchicalBag;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OHibernate2GraphMapper
extends OER2GraphMapper {
    private String xmlPath;

    public OHibernate2GraphMapper(OSourceDatabaseInfo sourceDBInfo, String xmlPath, List<String> includedTables, List<String> excludedTables, OConfiguration migrationConfig) {
        super(sourceDBInfo, includedTables, excludedTables, migrationConfig);
        this.xmlPath = xmlPath;
    }

    @Override
    public void buildSourceDatabaseSchema() {
        try {
            super.buildSourceDatabaseSchema();
            File xmlFile = new File(this.xmlPath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document dom = dBuilder.parse(xmlFile);
            NodeList entities = dom.getElementsByTagName("class");
            OEntity currentEntity = null;
            for (int i = 0; i < entities.getLength(); ++i) {
                Element currentEntityElement = (Element)entities.item(i);
                if (!currentEntityElement.hasAttribute("table")) {
                    OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "XML Format error: problem in class definition, table attribute missing in the class node.\n");
                    throw new OTeleporterRuntimeException();
                }
                currentEntity = this.dataBaseSchema.getEntityByNameIgnoreCase(currentEntityElement.getAttribute("table"));
                if (currentEntity == null) continue;
                this.detectInheritanceAndUpdateSchema(currentEntity, currentEntityElement);
            }
            Collections.sort(this.dataBaseSchema.getEntities());
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    private void detectInheritanceAndUpdateSchema(OEntity parentEntity, Element parentEntityElement) {
        LinkedHashSet<OEntity> tmp;
        NodeList subclassElements = parentEntityElement.getElementsByTagName("subclass");
        NodeList joinedSubclassElements = parentEntityElement.getElementsByTagName("joined-subclass");
        NodeList unionSubclassElements = parentEntityElement.getElementsByTagName("union-subclass");
        Element discriminatorElement = (Element)parentEntityElement.getElementsByTagName("discriminator").item(0);
        OHierarchicalBag hierarchicalBag = new OHierarchicalBag();
        String rootDiscriminatorValue = null;
        if (subclassElements.getLength() > 0) {
            if (parentEntityElement.hasAttribute("discriminator-value")) {
                rootDiscriminatorValue = parentEntityElement.getAttribute("discriminator-value");
            }
            this.performSubclassTagInheritance(hierarchicalBag, parentEntity, subclassElements, discriminatorElement, rootDiscriminatorValue);
        }
        if (joinedSubclassElements.getLength() > 0) {
            hierarchicalBag.setInheritancePattern("table-per-type");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet<OEntity>();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            this.performJoinedSubclassTagInheritance(hierarchicalBag, parentEntity, joinedSubclassElements);
        }
        if (unionSubclassElements.getLength() > 0) {
            hierarchicalBag.setInheritancePattern("table-per-concrete-type");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            this.performUnionSubclassTagInheritance(hierarchicalBag, parentEntity, unionSubclassElements);
        }
    }

    private void performSubclassTagInheritance(OHierarchicalBag hierarchicalBag, OEntity parentEntity, NodeList subclassElements, Element discriminatorElement, String rootDiscriminatorValue) {
        String currentEntityElementName = null;
        Element currentEntityElement = (Element)subclassElements.item(0);
        NodeList joinElements = currentEntityElement.getElementsByTagName("join");
        if (joinElements.getLength() > 0) {
            hierarchicalBag.setInheritancePattern("table-per-type");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                LinkedHashSet<OEntity> tmp = new LinkedHashSet<OEntity>();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            for (int j = 0; j < subclassElements.getLength(); ++j) {
                currentEntityElement = (Element)subclassElements.item(j);
                joinElements = currentEntityElement.getElementsByTagName("join");
                this.performJoinedSubclassTagInheritance(hierarchicalBag, parentEntity, joinElements);
            }
        } else {
            hierarchicalBag.setInheritancePattern("table-per-hierarchy");
            this.dataBaseSchema.getHierarchicalBags().add(hierarchicalBag);
            if (hierarchicalBag.getDepth2entities().get(parentEntity.getInheritanceLevel()) == null) {
                LinkedHashSet<OEntity> tmp = new LinkedHashSet<OEntity>();
                tmp.add(parentEntity);
                hierarchicalBag.getDepth2entities().put(parentEntity.getInheritanceLevel(), tmp);
                parentEntity.setHierarchicalBag(hierarchicalBag);
            }
            if (discriminatorElement != null) {
                hierarchicalBag.setDiscriminatorColumn(discriminatorElement.getAttribute("column"));
            }
            hierarchicalBag.getEntityName2discriminatorValue().put(parentEntity.getName(), rootDiscriminatorValue);
            for (int i = 0; i < subclassElements.getLength(); ++i) {
                Set<Object> tmp;
                currentEntityElement = (Element)subclassElements.item(i);
                if (!currentEntityElement.hasAttribute("name")) {
                    OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "XML Format error: problem in subclass definition, table attribute missing in the joined-subclass nodes.\n");
                    throw new OTeleporterRuntimeException();
                }
                currentEntityElementName = currentEntityElement.getAttribute("name");
                OEntity currentChildEntity = new OEntity(currentEntityElementName, null, this.sourceDBInfo);
                String discriminatorColumnName = discriminatorElement.getAttribute("column");
                parentEntity.removeAttributeByNameIgnoreCase(discriminatorColumnName);
                parentEntity.renumberAttributesOrdinalPositions();
                currentChildEntity.setPrimaryKey(parentEntity.getPrimaryKey());
                NodeList propertiesElements = currentEntityElement.getElementsByTagName("property");
                for (int j = 0; j < propertiesElements.getLength(); ++j) {
                    Element currentPropertyElement = (Element)propertiesElements.item(j);
                    OAttribute currentParentCorrespondingAttribute = parentEntity.getAttributeByNameIgnoreCase(currentPropertyElement.getAttribute("column"));
                    OAttribute currentChildAttribute = new OAttribute(currentParentCorrespondingAttribute.getName(), j + 1, currentParentCorrespondingAttribute.getDataType(), currentChildEntity);
                    currentChildEntity.addAttribute(currentChildAttribute);
                    parentEntity.getAttributes().remove(currentParentCorrespondingAttribute);
                }
                parentEntity.renumberAttributesOrdinalPositions();
                this.dataBaseSchema.getEntities().add(currentChildEntity);
                currentChildEntity.setParentEntity(parentEntity);
                currentChildEntity.setInheritanceLevel(parentEntity.getInheritanceLevel() + 1);
                if (hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel()) == null) {
                    tmp = new LinkedHashSet<OEntity>();
                    tmp.add(currentChildEntity);
                    hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
                } else {
                    tmp = hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel());
                    tmp.add(currentChildEntity);
                    hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
                }
                currentChildEntity.setHierarchicalBag(hierarchicalBag);
                hierarchicalBag.getEntityName2discriminatorValue().put(currentChildEntity.getName(), currentEntityElement.getAttribute("discriminator-value"));
            }
        }
    }

    private void performJoinedSubclassTagInheritance(OHierarchicalBag hierarchicalBag, OEntity parentEntity, NodeList joinedSubclassElements) {
        String currentChildEntityName = null;
        for (int i = 0; i < joinedSubclassElements.getLength(); ++i) {
            Set<Object> tmp;
            Element currentChildElement = (Element)joinedSubclassElements.item(i);
            if (!currentChildElement.hasAttribute("table")) {
                OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "XML Format error: problem in subclass definition, table attribute missing in the joined-subclass nodes.\n");
                throw new OTeleporterRuntimeException();
            }
            currentChildEntityName = currentChildElement.getAttribute("table");
            OEntity currentChildEntity = this.dataBaseSchema.getEntityByNameIgnoreCase(currentChildEntityName);
            currentChildEntity.setParentEntity(parentEntity);
            currentChildEntity.setInheritanceLevel(parentEntity.getInheritanceLevel() + 1);
            Iterator<OAttribute> it = currentChildEntity.getAttributes().iterator();
            while (it.hasNext()) {
                OAttribute currentAttribute = it.next();
                if (!currentChildEntity.getPrimaryKey().getInvolvedAttributes().contains(currentAttribute)) continue;
                it.remove();
            }
            currentChildEntity.renumberAttributesOrdinalPositions();
            if (hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet<OEntity>();
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            } else {
                tmp = hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel());
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            }
            currentChildEntity.setHierarchicalBag(hierarchicalBag);
            this.detectInheritanceAndUpdateSchema(currentChildEntity, currentChildElement);
        }
    }

    void performUnionSubclassTagInheritance(OHierarchicalBag hierarchicalBag, OEntity parentEntity, NodeList unionSubclassElements) {
        String currentChildEntityName = null;
        for (int i = 0; i < unionSubclassElements.getLength(); ++i) {
            Set<Object> tmp;
            OAttribute currentAttribute;
            Element currentChildElement = (Element)unionSubclassElements.item(i);
            if (!currentChildElement.hasAttribute("table")) {
                OTeleporterContext.getInstance().getMessageHandler().error((Object)this, "XML Format error: problem in subclass definition, table attribute missing in the joined-subclass nodes.\n");
                throw new OTeleporterRuntimeException();
            }
            currentChildEntityName = currentChildElement.getAttribute("table");
            OEntity currentChildEntity = this.dataBaseSchema.getEntityByNameIgnoreCase(currentChildEntityName);
            currentChildEntity.setParentEntity(parentEntity);
            currentChildEntity.setInheritanceLevel(parentEntity.getInheritanceLevel() + 1);
            Iterator<OAttribute> it = currentChildEntity.getAttributes().iterator();
            while (it.hasNext()) {
                currentAttribute = it.next();
                if (!currentChildEntity.getPrimaryKey().getInvolvedAttributes().contains(currentAttribute)) continue;
                it.remove();
            }
            currentChildEntity.renumberAttributesOrdinalPositions();
            if (hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel()) == null) {
                tmp = new LinkedHashSet<OEntity>();
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            } else {
                tmp = hierarchicalBag.getDepth2entities().get(currentChildEntity.getInheritanceLevel());
                tmp.add(currentChildEntity);
                hierarchicalBag.getDepth2entities().put(currentChildEntity.getInheritanceLevel(), tmp);
            }
            currentChildEntity.setHierarchicalBag(hierarchicalBag);
            this.detectInheritanceAndUpdateSchema(currentChildEntity, currentChildElement);
            it = currentChildEntity.getAttributes().iterator();
            while (it.hasNext()) {
                currentAttribute = it.next();
                if (!parentEntity.getAttributes().contains(currentAttribute)) continue;
                it.remove();
                currentChildEntity.getInheritedAttributes().add(currentAttribute);
            }
            currentChildEntity.renumberAttributesOrdinalPositions();
        }
    }
}

