/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.dbschema;

import com.orientechnologies.teleporter.model.ODataSourceSchemaInfo;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OHierarchicalBag;
import com.orientechnologies.teleporter.model.dbschema.OLogicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.ORelationship;
import java.util.ArrayList;
import java.util.List;

public class ODataBaseSchema
implements ODataSourceSchemaInfo {
    private int majorVersion;
    private int minorVersion;
    private int driverMajorVersion;
    private int driverMinorVersion;
    private String productName;
    private String productVersion;
    private List<OEntity> entities;
    private List<OCanonicalRelationship> canonicalRelationships;
    private List<OLogicalRelationship> logicalRelationships;
    private List<OHierarchicalBag> hierarchicalBags;

    public ODataBaseSchema(int majorVersion, int minorVersion, int driverMajorVersion, int driverMinorVersion, String productName, String productVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
        this.productName = productName;
        this.productVersion = productVersion;
        this.entities = new ArrayList<OEntity>();
        this.canonicalRelationships = new ArrayList<OCanonicalRelationship>();
        this.logicalRelationships = new ArrayList<OLogicalRelationship>();
        this.hierarchicalBags = new ArrayList<OHierarchicalBag>();
    }

    public ODataBaseSchema() {
        this.entities = new ArrayList<OEntity>();
        this.canonicalRelationships = new ArrayList<OCanonicalRelationship>();
        this.logicalRelationships = new ArrayList<OLogicalRelationship>();
        this.hierarchicalBags = new ArrayList<OHierarchicalBag>();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public void setDriverMajorVersion(int driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public void setDriverMinorVersion(int driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public List<OEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<OEntity> entitiess) {
        this.entities = entitiess;
    }

    public List<OCanonicalRelationship> getCanonicalRelationships() {
        return this.canonicalRelationships;
    }

    public void setCanonicalRelationships(List<OCanonicalRelationship> canonicalRelationships) {
        this.canonicalRelationships = canonicalRelationships;
    }

    public List<OLogicalRelationship> getLogicalRelationships() {
        return this.logicalRelationships;
    }

    public void setLogicalRelationships(List<OLogicalRelationship> logicalRelationships) {
        this.logicalRelationships = logicalRelationships;
    }

    public List<OHierarchicalBag> getHierarchicalBags() {
        return this.hierarchicalBags;
    }

    public void setHierarchicalBags(List<OHierarchicalBag> hierarchicalBags) {
        this.hierarchicalBags = hierarchicalBags;
    }

    public OEntity getEntityByName(String entityName) {
        for (OEntity currentEntity : this.entities) {
            if (!currentEntity.getName().equals(entityName)) continue;
            return currentEntity;
        }
        return null;
    }

    public OEntity getEntityByNameIgnoreCase(String entityName) {
        for (OEntity currentEntity : this.entities) {
            if (!currentEntity.getName().equalsIgnoreCase(entityName)) continue;
            return currentEntity;
        }
        return null;
    }

    public ORelationship getRelationshipByInvolvedEntitiesAndAttributes(OEntity currentForeignEntity, OEntity currentParentEntity, List<String> fromColumns, List<String> toColumns) {
        for (ORelationship oRelationship : this.canonicalRelationships) {
            if (!oRelationship.getForeignEntity().getName().equals(currentForeignEntity.getName()) || !oRelationship.getParentEntity().getName().equals(currentParentEntity.getName()) || !this.sameAttributesInvolved(oRelationship.getFromColumns(), fromColumns) || !this.sameAttributesInvolved(oRelationship.getToColumns(), toColumns)) continue;
            return oRelationship;
        }
        return null;
    }

    private boolean sameAttributesInvolved(List<OAttribute> columns, List<String> columnsName) {
        if (columns.size() != columnsName.size()) {
            return false;
        }
        for (String column : columnsName) {
            boolean present = false;
            for (OAttribute attribute : columns) {
                if (!attribute.getName().equals(column)) continue;
                present = true;
                break;
            }
            if (present) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "\n\n\n------------------------------ DB SCHEMA DESCRIPTION ------------------------------\n\n\nProduct name: " + this.productName + "\tProduct version: " + this.productVersion + "\nMajor version: " + this.majorVersion + "\tMinor Version: " + this.minorVersion + "\nDriver major version: " + this.driverMajorVersion + "\tDriver minor version: " + this.driverMinorVersion + "\n\n\n";
        s = s + "Number of Entities: " + this.entities.size() + ".\nNumber of Relationship: " + this.canonicalRelationships.size() + ".\n\n\n";
        for (OEntity e : this.entities) {
            s = s + e.toString();
        }
        return s;
    }
}

