/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.dbschema;

import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OForeignKey;
import com.orientechnologies.teleporter.model.dbschema.OHierarchicalBag;
import com.orientechnologies.teleporter.model.dbschema.OLogicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OPrimaryKey;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class OEntity
implements Comparable<OEntity> {
    private String name;
    private OSourceDatabaseInfo sourceDbInfo;
    private String schemaName;
    private Set<OAttribute> attributes;
    private Set<OAttribute> inheritedAttributes;
    private boolean inheritedAttributesRecovered;
    private OPrimaryKey primaryKey;
    private List<OForeignKey> foreignKeys;
    private Set<OCanonicalRelationship> outCanonicalRelationships;
    private Set<OCanonicalRelationship> inheritedOutCanonicalRelationships;
    private boolean inheritedOutCanonicalRelationshipsRecovered;
    private Set<OCanonicalRelationship> inCanonicalRelationships;
    private Set<OCanonicalRelationship> inheritedInCanonicalRelationships;
    private boolean inheritedInCanonicalRelationshipsRecovered;
    private Set<OLogicalRelationship> outLogicalRelationships;
    private Set<OLogicalRelationship> inLogicalRelationships;
    private Boolean isAggregable;
    private Boolean isSplitEntity;
    private String directionOfN2NRepresentedRelationship;
    private String nameOfN2NRepresentedRelationship;
    private OEntity parentEntity;
    private int inheritanceLevel;
    private OHierarchicalBag hierarchicalBag;

    public OEntity(String name, String schemaName, OSourceDatabaseInfo sourceDbInfo) {
        this.name = name;
        this.sourceDbInfo = sourceDbInfo;
        this.schemaName = schemaName;
        this.attributes = new LinkedHashSet<OAttribute>();
        this.inheritedAttributes = new LinkedHashSet<OAttribute>();
        this.inheritedAttributesRecovered = false;
        this.foreignKeys = new LinkedList<OForeignKey>();
        this.outCanonicalRelationships = new LinkedHashSet<OCanonicalRelationship>();
        this.inheritedOutCanonicalRelationships = new LinkedHashSet<OCanonicalRelationship>();
        this.inheritedOutCanonicalRelationshipsRecovered = false;
        this.inCanonicalRelationships = new LinkedHashSet<OCanonicalRelationship>();
        this.inheritedInCanonicalRelationships = new LinkedHashSet<OCanonicalRelationship>();
        this.inheritedInCanonicalRelationshipsRecovered = false;
        this.outLogicalRelationships = new LinkedHashSet<OLogicalRelationship>();
        this.inLogicalRelationships = new LinkedHashSet<OLogicalRelationship>();
        this.isAggregable = null;
        this.isSplitEntity = false;
        this.inheritanceLevel = 0;
    }

    public boolean isAggregableJoinTable() {
        if (this.isAggregable != null) {
            return this.isAggregable;
        }
        if (this.foreignKeys.size() != 2) {
            return false;
        }
        boolean aggregable = this.isJunctionTable();
        this.isAggregable = aggregable;
        if (this.isAggregable.booleanValue() && this.directionOfN2NRepresentedRelationship == null) {
            this.directionOfN2NRepresentedRelationship = "direct";
        }
        return this.isAggregable;
    }

    private boolean isJunctionTable() {
        boolean isJunctionTable = true;
        block0: for (OForeignKey currentFk : this.foreignKeys) {
            for (OAttribute attribute : currentFk.getInvolvedAttributes()) {
                if (this.primaryKey.getInvolvedAttributes().contains(attribute)) continue;
                isJunctionTable = false;
                continue block0;
            }
        }
        if (isJunctionTable && this.getAllInCanonicalRelationships().size() > 0) {
            isJunctionTable = false;
        }
        return isJunctionTable;
    }

    public Boolean isSplitEntity() {
        return this.isSplitEntity;
    }

    public void setIsSplitEntity(Boolean splitEntity) {
        this.isSplitEntity = splitEntity;
    }

    public void setIsAggregableJoinTable(boolean isAggregable) {
        this.isAggregable = isAggregable;
    }

    public String getDirectionOfN2NRepresentedRelationship() {
        return this.directionOfN2NRepresentedRelationship;
    }

    public void setDirectionOfN2NRepresentedRelationship(String directionOfN2NRepresentedRelationship) {
        this.directionOfN2NRepresentedRelationship = directionOfN2NRepresentedRelationship;
    }

    public String getNameOfN2NRepresentedRelationship() {
        return this.nameOfN2NRepresentedRelationship;
    }

    public void setNameOfN2NRepresentedRelationship(String nameOfN2NRepresentedRelationship) {
        this.nameOfN2NRepresentedRelationship = nameOfN2NRepresentedRelationship;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OSourceDatabaseInfo getSourceDataseInfo() {
        return this.sourceDbInfo;
    }

    public void setSourceDbInfo(OSourceDatabaseInfo sourceDbInfo) {
        this.sourceDbInfo = sourceDbInfo;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Set<OAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<OAttribute> attributes) {
        this.attributes = attributes;
    }

    public Set<OAttribute> getInheritedAttributes() {
        if (this.inheritedAttributesRecovered) {
            return this.inheritedAttributes;
        }
        if (this.parentEntity != null) {
            this.inheritedAttributes = this.parentEntity.getAllAttributes();
            this.inheritedAttributesRecovered = true;
            return this.inheritedAttributes;
        }
        return this.inheritedAttributes;
    }

    public Set<OAttribute> getAllAttributes() {
        LinkedHashSet<OAttribute> allAttributes = new LinkedHashSet<OAttribute>();
        allAttributes.addAll(this.getInheritedAttributes());
        allAttributes.addAll(this.attributes);
        return allAttributes;
    }

    public void setInheritedAttributes(Set<OAttribute> inheritedAttributes) {
        this.inheritedAttributes = inheritedAttributes;
    }

    public boolean isInheritedAttributesRecovered() {
        return this.inheritedAttributesRecovered;
    }

    public void setInheritedAttributesRecovered(boolean inheritedAttributesRecovered) {
        this.inheritedAttributesRecovered = inheritedAttributesRecovered;
    }

    public OPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(OPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public List<OForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(List<OForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public boolean addAttribute(OAttribute attribute) {
        boolean added = this.attributes.add(attribute);
        LinkedList<OAttribute> temp = new LinkedList<OAttribute>(this.attributes);
        if (added) {
            Collections.sort(temp);
        }
        this.attributes.clear();
        this.attributes.addAll(temp);
        return added;
    }

    public void removeAttributeByNameIgnoreCase(String toRemove) {
        Iterator<OAttribute> it = this.attributes.iterator();
        while (it.hasNext()) {
            OAttribute currentAttribute = it.next();
            if (!currentAttribute.getName().equalsIgnoreCase(toRemove)) continue;
            it.remove();
            break;
        }
    }

    public OAttribute getAttributeByName(String name) {
        OAttribute toReturn = null;
        for (OAttribute a : this.attributes) {
            if (!a.getName().equals(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public OAttribute getAttributeByNameIgnoreCase(String name) {
        OAttribute toReturn = null;
        for (OAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public OAttribute getAttributeByOrdinalPosition(int position) {
        OAttribute toReturn = null;
        for (OAttribute a : this.attributes) {
            if (a.getOrdinalPosition() != position) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public OAttribute getInheritedAttributeByName(String name) {
        OAttribute toReturn = null;
        for (OAttribute a : this.getInheritedAttributes()) {
            if (!a.getName().equals(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public OAttribute getInheritedAttributeByNameIgnoreCase(String name) {
        OAttribute toReturn = null;
        for (OAttribute a : this.getInheritedAttributes()) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public Set<OCanonicalRelationship> getOutCanonicalRelationships() {
        return this.outCanonicalRelationships;
    }

    public void setOutCanonicalRelationships(Set<OCanonicalRelationship> outCanonicalRelationships) {
        this.outCanonicalRelationships = outCanonicalRelationships;
    }

    public Set<OCanonicalRelationship> getInheritedOutCanonicalRelationships() {
        if (this.inheritedOutCanonicalRelationshipsRecovered) {
            return this.inheritedOutCanonicalRelationships;
        }
        if (this.parentEntity != null) {
            this.inheritedOutCanonicalRelationships = this.parentEntity.getAllOutCanonicalRelationships();
            this.inheritedOutCanonicalRelationshipsRecovered = true;
            return this.inheritedOutCanonicalRelationships;
        }
        return this.inheritedOutCanonicalRelationships;
    }

    public void setInheritedOutCanonicalRelationships(Set<OCanonicalRelationship> inheritedOutCanonicalRelationships) {
        this.inheritedOutCanonicalRelationships = inheritedOutCanonicalRelationships;
    }

    public Set<OCanonicalRelationship> getAllOutCanonicalRelationships() {
        LinkedHashSet<OCanonicalRelationship> allRelationships = new LinkedHashSet<OCanonicalRelationship>();
        allRelationships.addAll(this.getInheritedOutCanonicalRelationships());
        allRelationships.addAll(this.outCanonicalRelationships);
        return allRelationships;
    }

    public boolean isInheritedOutCanonicalRelationshipsRecovered() {
        return this.inheritedOutCanonicalRelationshipsRecovered;
    }

    public void setInheritedOutCanonicalRelationshipsRecovered(boolean inheritedOutCanonicalRelationshipsRecovered) {
        this.inheritedOutCanonicalRelationshipsRecovered = inheritedOutCanonicalRelationshipsRecovered;
    }

    public Set<OCanonicalRelationship> getInCanonicalRelationships() {
        return this.inCanonicalRelationships;
    }

    public void setInCanonicalRelationships(Set<OCanonicalRelationship> inCanonicalRelationships) {
        this.inCanonicalRelationships = inCanonicalRelationships;
    }

    public Set<OCanonicalRelationship> getInheritedInCanonicalRelationships() {
        if (this.inheritedInCanonicalRelationshipsRecovered) {
            return this.inheritedInCanonicalRelationships;
        }
        if (this.parentEntity != null) {
            this.inheritedInCanonicalRelationships = this.parentEntity.getAllInCanonicalRelationships();
            this.inheritedInCanonicalRelationshipsRecovered = true;
            return this.inheritedInCanonicalRelationships;
        }
        return this.inheritedInCanonicalRelationships;
    }

    public void setInheritedInCanonicalRelationships(Set<OCanonicalRelationship> inheritedInCanonicalRelationships) {
        this.inheritedInCanonicalRelationships = inheritedInCanonicalRelationships;
    }

    public Set<OCanonicalRelationship> getAllInCanonicalRelationships() {
        LinkedHashSet<OCanonicalRelationship> allRelationships = new LinkedHashSet<OCanonicalRelationship>();
        allRelationships.addAll(this.getInheritedInCanonicalRelationships());
        allRelationships.addAll(this.inCanonicalRelationships);
        return allRelationships;
    }

    public boolean isInheritedInCanonicalRelationshipsRecovered() {
        return this.inheritedInCanonicalRelationshipsRecovered;
    }

    public void setInheritedInCanonicalRelationshipsRecovered(boolean inheritedInCanonicalRelationshipsRecovered) {
        this.inheritedInCanonicalRelationshipsRecovered = inheritedInCanonicalRelationshipsRecovered;
    }

    public Set<OLogicalRelationship> getOutLogicalRelationships() {
        return this.outLogicalRelationships;
    }

    public void setOutLogicalRelationships(Set<OLogicalRelationship> outLogicalRelationships) {
        this.outLogicalRelationships = outLogicalRelationships;
    }

    public Set<OLogicalRelationship> getInLogicalRelationships() {
        return this.inLogicalRelationships;
    }

    public void setInLogicalRelationships(Set<OLogicalRelationship> inLogicalRelationships) {
        this.inLogicalRelationships = inLogicalRelationships;
    }

    public OEntity getParentEntity() {
        return this.parentEntity;
    }

    public void setParentEntity(OEntity parentEntity) {
        this.parentEntity = parentEntity;
    }

    public int getInheritanceLevel() {
        return this.inheritanceLevel;
    }

    public void setInheritanceLevel(int inheritanceLevel) {
        this.inheritanceLevel = inheritanceLevel;
    }

    public OHierarchicalBag getHierarchicalBag() {
        return this.hierarchicalBag;
    }

    public void setHierarchicalBag(OHierarchicalBag hierarchicalBag) {
        this.hierarchicalBag = hierarchicalBag;
    }

    public void renumberAttributesOrdinalPositions() {
        int i = 1;
        for (OAttribute attribute : this.attributes) {
            attribute.setOrdinalPosition(i);
            ++i;
        }
    }

    @Override
    public int compareTo(OEntity toCompare) {
        if (this.inheritanceLevel > toCompare.getInheritanceLevel()) {
            return 1;
        }
        if (this.inheritanceLevel < toCompare.getInheritanceLevel()) {
            return -1;
        }
        return this.name.compareTo(toCompare.getName());
    }

    public String toString() {
        String s = "Entity [name = " + this.name + ", number of attributes = " + this.attributes.size() + "]";
        if (this.isAggregableJoinTable()) {
            s = s + "\t\t\tJoin Entity (Aggregable Join Table)";
        }
        s = s + "\n|| ";
        for (OAttribute a : this.attributes) {
            s = s + a.getOrdinalPosition() + ": " + a.getName() + " ( " + a.getDataType() + " ) || ";
        }
        s = s + "\nPrimary Key (" + this.primaryKey.getInvolvedAttributes().size() + " involved attributes): ";
        int cont = 1;
        int size = this.primaryKey.getInvolvedAttributes().size();
        for (OAttribute a : this.primaryKey.getInvolvedAttributes()) {
            s = cont < size ? s + a.getName() + ", " : s + a.getName() + ".";
            ++cont;
        }
        if (this.outCanonicalRelationships.size() > 0) {
            s = s + "\nForeign Keys (" + this.outCanonicalRelationships.size() + "):\n";
            int index = 1;
            for (OCanonicalRelationship relationship : this.outCanonicalRelationships) {
                s = s + index + ".  ";
                s = s + "Foreign Entity: " + relationship.getForeignEntity().getName() + ", Foreign Key: " + relationship.getForeignKey().toString() + "\t||\tParent Entity: " + relationship.getParentEntity().getName() + ", Primary Key: " + relationship.getForeignKey().toString() + "\n";
                ++index;
            }
        } else {
            s = s + "\nForeign Key: Not Present\n";
        }
        s = s + "\n\n";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        OEntity that = (OEntity)obj;
        return this.name.equals(that.getName()) && this.getSourceDataseInfo().equals(that.getSourceDataseInfo());
    }
}

