/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.dbschema;

import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import java.util.LinkedList;
import java.util.List;

public class OKey {
    protected OEntity belongingEntity;
    protected List<OAttribute> involvedAttributes;

    public OKey() {
        this.involvedAttributes = new LinkedList<OAttribute>();
    }

    public OKey(OEntity belongingEntity) {
        this.belongingEntity = belongingEntity;
        this.involvedAttributes = new LinkedList<OAttribute>();
    }

    public OEntity getBelongingEntity() {
        return this.belongingEntity;
    }

    public void setBelongingEntity(OEntity belongingEntity) {
        this.belongingEntity = belongingEntity;
    }

    public List<OAttribute> getInvolvedAttributes() {
        return this.involvedAttributes;
    }

    public void setInvolvedAttributes(List<OAttribute> involvedAttributes) {
        this.involvedAttributes = involvedAttributes;
    }

    public void addAttribute(OAttribute attribute) {
        this.involvedAttributes.add(attribute);
    }

    public boolean removeAttribute(OAttribute toRemove) {
        return this.involvedAttributes.remove(toRemove);
    }

    public OAttribute getAttributeByName(String name) {
        OAttribute toReturn = null;
        for (OAttribute a : this.involvedAttributes) {
            if (!a.getName().equals(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public OAttribute getAttributeByNameIgnoreCase(String name) {
        OAttribute toReturn = null;
        for (OAttribute a : this.involvedAttributes) {
            if (!a.getName().equalsIgnoreCase(name)) continue;
            toReturn = a;
            break;
        }
        return toReturn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.belongingEntity == null ? 0 : this.belongingEntity.getName().hashCode());
        result = 31 * result + (this.involvedAttributes == null ? 0 : this.involvedAttributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        OKey that = (OKey)obj;
        return this.belongingEntity.getName().equals(that.belongingEntity.getName()) && this.involvedAttributes.equals(that.getInvolvedAttributes());
    }

    public String toString() {
        String s = "[";
        for (OAttribute attribute : this.involvedAttributes) {
            s = s + attribute.getName() + ",";
        }
        s = s.substring(0, s.length() - 1);
        s = s + "]";
        return s;
    }
}

