/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.dbschema;

import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.ORelationship;
import java.util.List;

public class OLogicalRelationship
extends ORelationship {
    private List<OAttribute> fromColumns;
    private List<OAttribute> toColumns;

    public OLogicalRelationship(OEntity foreignEntity, OEntity parentEntity) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.direction = "direct";
    }

    public OLogicalRelationship(OEntity foreignEntity, OEntity parentEntity, List<OAttribute> fromColumns, List<OAttribute> toColumns) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.fromColumns = fromColumns;
        this.toColumns = toColumns;
        this.direction = "direct";
    }

    @Override
    public List<OAttribute> getFromColumns() {
        return this.fromColumns;
    }

    public void setFromColumns(List<OAttribute> columns) {
        this.fromColumns = columns;
    }

    @Override
    public List<OAttribute> getToColumns() {
        return this.toColumns;
    }

    public void setToColumns(List<OAttribute> columns) {
        this.toColumns = columns;
    }

    public boolean equals(Object obj) {
        OCanonicalRelationship that = (OCanonicalRelationship)obj;
        return this.foreignEntity.equals(that.getForeignEntity()) && this.parentEntity.equals(that.getParentEntity()) && this.fromColumns.equals(that.getFromColumns()) && this.toColumns.equals(that.getToColumns());
    }

    public String toString() {
        String fromColumns = "[";
        for (OAttribute attribute : this.fromColumns) {
            fromColumns = fromColumns + attribute.getName() + ",";
        }
        fromColumns = fromColumns.substring(0, fromColumns.length() - 1);
        fromColumns = fromColumns + "]";
        String toColumns = "[";
        for (OAttribute attribute : this.toColumns) {
            toColumns = toColumns + attribute.getName() + ",";
        }
        toColumns = toColumns.substring(0, toColumns.length() - 1);
        toColumns = toColumns + "]";
        return "OLogicalRelationship [foreignEntity=" + this.foreignEntity.getName() + ", parentEntity=" + this.parentEntity.getName() + ", From Columns=" + fromColumns + ", To Columns=" + toColumns + " ]";
    }
}

