/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.graphmodel;

import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OGraphModel {
    private List<OVertexType> verticesType = new ArrayList<OVertexType>();
    private List<OEdgeType> edgesType = new ArrayList<OEdgeType>();

    public OVertexType getVertexTypeByName(String name) {
        OVertexType vertex = null;
        for (OVertexType currentVertex : this.verticesType) {
            if (!currentVertex.getName().equals(name)) continue;
            vertex = currentVertex;
            break;
        }
        return vertex;
    }

    public OVertexType getVertexTypeByNameIgnoreCase(String name) {
        OVertexType vertex = null;
        for (OVertexType currentVertex : this.verticesType) {
            if (!currentVertex.getName().equalsIgnoreCase(name)) continue;
            vertex = currentVertex;
            break;
        }
        return vertex;
    }

    public List<OVertexType> getVerticesType() {
        return this.verticesType;
    }

    public void setVerticesType(List<OVertexType> verticesType) {
        this.verticesType = verticesType;
    }

    public List<OEdgeType> getEdgesType() {
        return this.edgesType;
    }

    public void setEdgesType(List<OEdgeType> edgesType) {
        this.edgesType = edgesType;
    }

    public OEdgeType getEdgeTypeByName(String name) {
        for (OEdgeType currentEdgetype : this.edgesType) {
            if (!currentEdgetype.getName().equals(name)) continue;
            return currentEdgetype;
        }
        return null;
    }

    public OEdgeType getEdgeTypeByNameIgnoreCase(String name) {
        for (OEdgeType currentEdgetype : this.edgesType) {
            if (!currentEdgetype.getName().equalsIgnoreCase(name)) continue;
            return currentEdgetype;
        }
        return null;
    }

    public boolean removeVertexTypeByName(String vertexName) {
        Iterator<OVertexType> iterator = this.verticesType.iterator();
        while (iterator.hasNext()) {
            OVertexType currVertexType = iterator.next();
            if (!currVertexType.getName().equals(vertexName)) continue;
            for (OEdgeType currInEdgeType : currVertexType.getInEdgesType()) {
                currInEdgeType.setInVertexType(null);
            }
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeEdgeTypeByName(String vertexName) {
        Iterator<OEdgeType> iterator = this.edgesType.iterator();
        while (iterator.hasNext()) {
            OEdgeType currEdgeType = iterator.next();
            if (!currEdgeType.getName().equals(vertexName)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "\n\n\n------------------------------ MODEL GRAPH DESCRIPTION ------------------------------\n\n\n";
        s = s + "Number of Vertex-type: " + this.verticesType.size() + ".\nNumber of Edge-type: " + this.edgesType.size() + ".\n\n";
        s = s + "Vertex-type:\n\n";
        for (OVertexType v : this.verticesType) {
            s = s + v.toString() + "\n\n";
        }
        s = s + "\n\n";
        s = s + "Edge-type:\n\n";
        for (OEdgeType e : this.edgesType) {
            s = s + e.toString() + "\n";
        }
        s = s + "\n\n";
        s = s + "Graph structure:\n\n";
        for (OVertexType v : this.verticesType) {
            for (OEdgeType e : v.getOutEdgesType()) {
                s = s + v.getName() + " -----------[" + e.getName() + "]-----------> " + e.getInVertexType().getName() + "\n";
            }
        }
        return s;
    }
}

